/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.treetable.transfer;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testcase.treetable.transfer.ScriptTransferData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;

public class ScriptTransfer
extends ByteArrayTransfer {
    protected static final Class<?> getTypeClass() {
        return ScriptTransferData.class;
    }

    protected static final String getTypeName() {
        return ScriptTransfer.getTypeClass().getName();
    }

    protected static final int getTypeID() {
        return ScriptTransfer.registerType((String)ScriptTransfer.getTypeName());
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkType(object) || !this.isSupportedType(transferData)) {
            DND.error((int)2003);
        }
        ScriptTransferData[] treeEntites = (ScriptTransferData[])object;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream writeOut = new DataOutputStream(out);
            int i = 0;
            int length = treeEntites.length;
            while (i < length) {
                byte[] buffer = this.objectToBytes(treeEntites[i]);
                writeOut.writeInt(buffer.length);
                writeOut.write(buffer);
                ++i;
            }
            byte[] buffer = out.toByteArray();
            writeOut.close();
            super.javaToNative((Object)buffer, transferData);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public Object nativeToJava(TransferData transferData) {
        if (this.isSupportedType(transferData)) {
            byte[] buffer = (byte[])super.nativeToJava(transferData);
            if (buffer == null) {
                return null;
            }
            ScriptTransferData[] myData = new ScriptTransferData[]{};
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(buffer);
                DataInputStream readIn = new DataInputStream(in);
                while (readIn.available() > 20) {
                    int size = readIn.readInt();
                    byte[] payload = new byte[size];
                    readIn.read(payload);
                    Object obj = this.bytesToObject(payload);
                    ScriptTransferData datum = (ScriptTransferData)obj;
                    ScriptTransferData[] newMyData = new ScriptTransferData[myData.length + 1];
                    System.arraycopy(myData, 0, newMyData, 0, myData.length);
                    newMyData[myData.length] = datum;
                    myData = newMyData;
                }
                readIn.close();
            }
            catch (Exception ex) {
                LoggerSingleton.logError((Throwable)ex);
                return null;
            }
            return myData;
        }
        return null;
    }

    protected String[] getTypeNames() {
        return new String[]{ScriptTransfer.getTypeName()};
    }

    protected int[] getTypeIds() {
        return new int[]{ScriptTransfer.getTypeID()};
    }

    protected boolean checkType(Object object) {
        if (object == null || !(object instanceof ScriptTransferData[]) || ((ScriptTransferData[])object).length == 0) {
            return false;
        }
        ScriptTransferData[] elementArray = (ScriptTransferData[])object;
        int i = 0;
        while (i < elementArray.length) {
            if (elementArray[i] == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean validate(Object object) {
        return this.checkType(object);
    }

    protected byte[] objectToBytes(Object theObject) throws Exception {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(bos);
            os.writeObject(theObject);
            return bos.toByteArray();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    protected Object bytesToObject(byte[] bytes) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream is = new ObjectInputStream(bis);
        return is.readObject();
    }
}

