/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.console.handlers;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.core.util.FailedTestThreshold;
import com.kms.katalon.execution.console.ApplicationConfigOptions;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.handler.ApiKeyOnPremiseHandler;
import com.kms.katalon.logging.LogUtil;
import java.time.Duration;
import joptsimple.OptionSet;
import org.apache.commons.lang3.StringUtils;

public class ArgumentOptionsHandler {
    private final boolean DEFAULT_ENABLE_LICENSE_RETRY = false;
    private final Duration DEFAULT_LICENSE_RETRY_MAX_DURATION_IN_MINUTES = Duration.ofMinutes(20L);
    private final Duration DEFAULT_LICENSE_RETRY_INTERVAL_IN_MINUTES = Duration.ofMinutes(5L);
    private final Duration DEFAULT_LICENSE_RETRY_MAX_JITTER_IN_MINUTES = Duration.ofMinutes(2L);
    private final String INVALID_LICENSE_RETRY_MAX_DURATION_MSG = "Invalid input: licenseRetryMaxDuration's value must be an integer";
    private final String INVALID_LICENSE_RETRY_INTERVAL_MSG = "Invalid input: licenseRetryInterval's value must be an integer";
    private final String INVALID_LICENSE_RETRY_MAX_JITTER_MSG = "Invalid input: licenseRetryMaxJitter's value must be an integer";
    private final String INVALID_ENABLE_LICENSE_RETRY_MSG = "Invalid input: enableLicenseRetry's value must be a boolean";
    private static ArgumentOptionsHandler _instance;
    private OptionSet options;

    private ArgumentOptionsHandler() {
    }

    public static ArgumentOptionsHandler getInstance() {
        if (_instance == null) {
            _instance = new ArgumentOptionsHandler();
        }
        return _instance;
    }

    public boolean isRunWithTestCloudBrowser() {
        String browserType = this.getBrowserType();
        return browserType.equalsIgnoreCase(GlobalMessageConstants.TESTCLOUD_NAME);
    }

    public String getBrowserType() {
        String browserType = "";
        if (this.options.has("browserType")) {
            browserType = String.valueOf(this.options.valueOf("browserType"));
        }
        return browserType;
    }

    public boolean isRunningTestSuite() {
        return StringUtils.isNotBlank((CharSequence)this.getTestSuitePath());
    }

    public String getTestSuitePath() {
        String testSuitePath = "";
        if (this.options.has("testSuitePath")) {
            testSuitePath = String.valueOf(this.options.valueOf("testSuitePath"));
        }
        return testSuitePath;
    }

    public String getAdminServerUrl() {
        String adminServerUrl = null;
        if (this.options.has("serverUrl")) {
            adminServerUrl = String.valueOf(this.options.valueOf("serverUrl"));
        }
        if (this.options.has("serverURL")) {
            adminServerUrl = String.valueOf(this.options.valueOf("serverURL"));
        }
        if (!StringUtils.isEmpty((CharSequence)adminServerUrl)) {
            ApplicationInfo.setAdminServer((String)adminServerUrl);
        }
        return adminServerUrl;
    }

    public void prepareApplicationConfiguration(ApplicationConfigOptions applicationConfigOptions) throws Exception {
        for (ConsoleOption opt : applicationConfigOptions.getConsoleOptionList()) {
            String optionName = opt.getOption();
            if (!this.options.hasArgument(optionName)) continue;
            applicationConfigOptions.setArgumentValue(opt, String.valueOf(this.options.valueOf(optionName)));
        }
    }

    public void validateOption() {
        if (this.options.has("maxFailedTests")) {
            try {
                int maxFailedTestValue = Integer.valueOf(this.options.valueOf("maxFailedTests").toString().replaceAll("'", ""));
                if (maxFailedTestValue <= 0) {
                    maxFailedTestValue = -1;
                    LogUtil.printErrorLine((String)ExecutionMessageConstants.MSG_ERR_MAX_FAILED_TEST_INVALID_INPUT);
                } else {
                    this.saveFailedTestThreshold(maxFailedTestValue);
                }
            }
            catch (NumberFormatException numberFormatException) {
                LogUtil.printErrorLine((String)ExecutionMessageConstants.MSG_ERR_MAX_FAILED_TEST_INVALID_INPUT);
            }
        }
        if (this.options.has("delayBetweenInstances")) {
            this.delayBetweenInstanceErrorLogInfo();
        }
    }

    public String getApiKeyValue() {
        String apiKeyValue = null;
        if (this.options.has("apiKey")) {
            apiKeyValue = String.valueOf(this.options.valueOf("apiKey"));
        }
        if (this.options.has("apikey")) {
            apiKeyValue = String.valueOf(this.options.valueOf("apikey"));
        }
        return apiKeyValue;
    }

    public String getOrganizationId() {
        String organizationId = null;
        if (this.options.has("orgId")) {
            organizationId = String.valueOf(this.options.valueOf("orgId"));
        }
        if (this.options.has("orgID")) {
            organizationId = String.valueOf(this.options.valueOf("orgID"));
        }
        return organizationId;
    }

    public String getApiKeyOnpremiseValue() {
        String apiKeyOnPremiseValue = null;
        if (this.options.has("apiKeyOnPremise")) {
            apiKeyOnPremiseValue = String.valueOf(this.options.valueOf("apiKeyOnPremise"));
        }
        if (this.options.has("apiKeyOP")) {
            apiKeyOnPremiseValue = String.valueOf(this.options.valueOf("apiKeyOP"));
        }
        ApiKeyOnPremiseHandler.setApiKeyOnPremiseToProject((String)apiKeyOnPremiseValue);
        return apiKeyOnPremiseValue;
    }

    public boolean getLicenseRelease() {
        if (this.options.has("licenseRelease")) {
            return Boolean.valueOf(this.options.valueOf("licenseRelease").toString());
        }
        return false;
    }

    private void saveFailedTestThreshold(int numOfFailedTests) {
        FailedTestThreshold instance = FailedTestThreshold.getInstance();
        instance.setThreshold(numOfFailedTests);
        instance.setThresholdAvailable(true);
    }

    private void delayBetweenInstanceErrorLogInfo() {
        try {
            int delay = Integer.parseInt(this.options.valueOf("delayBetweenInstances").toString());
            if (delay < 0 || delay > 999) {
                LogUtil.logInfo((String)ExecutionMessageConstants.MSG_DELAY_BETWEEN_INSTANCE_INVALID);
            }
        }
        catch (NumberFormatException numberFormatException) {
            LogUtil.logInfo((String)ExecutionMessageConstants.MSG_DELAY_BETWEEN_INSTANCE_INVALID);
        }
    }

    public Boolean getTestOpsEnabled() {
        Boolean testOpsEnabled = null;
        if (this.options.has("testOps.enabled")) {
            testOpsEnabled = Boolean.parseBoolean(String.valueOf(this.options.valueOf("testOps.enabled")));
        }
        return testOpsEnabled;
    }

    public String getTestOpsServerUrl() {
        String testOpsServerUrl = null;
        if (this.options.has("testOps.serverUrl")) {
            testOpsServerUrl = String.valueOf(this.options.valueOf("testOps.serverUrl"));
        }
        if (StringUtils.isNotBlank(testOpsServerUrl)) {
            ApplicationInfo.setTestOpsServer(testOpsServerUrl);
        }
        return testOpsServerUrl;
    }

    public Long getTestOpsProjectId() {
        Long projectId = null;
        if (this.options.has("testOpsProjectId")) {
            try {
                projectId = (Long)this.options.valueOf("testOpsProjectId");
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return projectId;
    }

    public boolean useTestOpsServerUrlArgument() {
        return StringUtils.isNotBlank((CharSequence)this.getTestOpsServerUrl());
    }

    public boolean isEnableLicenseRetry() {
        if (this.options.has("enableLicenseRetry")) {
            String value = String.valueOf(this.options.valueOf("enableLicenseRetry"));
            if (value.equalsIgnoreCase("true")) {
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                return false;
            }
            throw new IllegalStateException("Invalid input: enableLicenseRetry's value must be a boolean");
        }
        return false;
    }

    public Duration getLicenseRetryMaxDuration() {
        if (this.options.has("licenseRetryMaxDuration")) {
            String value = String.valueOf(this.options.valueOf("licenseRetryMaxDuration"));
            try {
                return Duration.ofMinutes(Integer.parseInt(value));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalStateException("Invalid input: licenseRetryMaxDuration's value must be an integer");
            }
        }
        return this.DEFAULT_LICENSE_RETRY_MAX_DURATION_IN_MINUTES;
    }

    public Duration getLicenseRetryInterval() {
        if (this.options.has("licenseRetryInterval")) {
            String value = String.valueOf(this.options.valueOf("licenseRetryInterval"));
            try {
                return Duration.ofMinutes(Integer.parseInt(value));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalStateException("Invalid input: licenseRetryInterval's value must be an integer");
            }
        }
        return this.DEFAULT_LICENSE_RETRY_INTERVAL_IN_MINUTES;
    }

    public Duration getLicenseRetryMaxJitter() {
        if (this.options.has("licenseRetryMaxJitter")) {
            String value = String.valueOf(this.options.valueOf("licenseRetryMaxJitter"));
            try {
                return Duration.ofMinutes(Integer.parseInt(value));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalStateException("Invalid input: licenseRetryMaxJitter's value must be an integer");
            }
        }
        return this.DEFAULT_LICENSE_RETRY_MAX_JITTER_IN_MINUTES;
    }

    public OptionSet getOptions() {
        return this.options;
    }

    public void setOptions(OptionSet options) {
        this.options = options;
    }
}

