/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.listeners;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.testsuite.providers.TestCaseTableViewer;
import com.kms.katalon.composer.testsuite.transfer.TestSuiteTestCaseLinkTransferData;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TableDropTargetEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableItem;

public class TestCaseTableDropListener
extends TableDropTargetEffect {
    private TestCaseTableViewer viewer;

    public TestCaseTableDropListener(TestCaseTableViewer viewer) {
        super(viewer.getTable());
        this.viewer = viewer;
    }

    public void drop(DropTargetEvent event) {
        try {
            event.detail = 1;
            Point pt = Display.getCurrent().map(null, (Control)this.viewer.getTable(), event.x, event.y);
            TableItem tableItem = this.viewer.getTable().getItem(pt);
            TestSuiteTestCaseLink selectedItem = tableItem != null && tableItem.getData() instanceof TestSuiteTestCaseLink ? (TestSuiteTestCaseLink)tableItem.getData() : null;
            ArrayList<TestSuiteTestCaseLink> addedTestCaseLinked = new ArrayList<TestSuiteTestCaseLink>();
            if (event.data instanceof ITreeEntity[]) {
                int selectedIndex = selectedItem != null ? this.viewer.getIndex(selectedItem) : this.viewer.getInput().size();
                ITreeEntity[] treeEntities = (ITreeEntity[])event.data;
                int i = treeEntities.length - 1;
                while (i >= 0) {
                    if (treeEntities[i] instanceof TestCaseTreeEntity) {
                        TestSuiteTestCaseLink link = this.viewer.insertTestCase(((TestCaseTreeEntity)treeEntities[i]).getObject(), selectedIndex);
                        addedTestCaseLinked.add(link);
                    } else if (treeEntities[i] instanceof FolderTreeEntity) {
                        for (TestCaseEntity testCase : this.getTestCasesFromFolderTree((FolderTreeEntity)treeEntities[i])) {
                            addedTestCaseLinked.add(this.viewer.insertTestCase(testCase, selectedIndex));
                        }
                    }
                    --i;
                }
            } else if (event.data instanceof TestSuiteTestCaseLinkTransferData[]) {
                int selectedIndex = selectedItem != null ? this.viewer.getIndex(selectedItem) : this.viewer.getInput().size() - 1;
                TestSuiteTestCaseLinkTransferData[] testSuiteTestCaseLinkTransferDatas = (TestSuiteTestCaseLinkTransferData[])event.data;
                if (testSuiteTestCaseLinkTransferDatas.length != 1) {
                    return;
                }
                int previousIndex = this.viewer.getIndex(testSuiteTestCaseLinkTransferDatas[0].getTestSuiteTestCaseLink());
                if (previousIndex == selectedIndex) {
                    return;
                }
                Collections.swap(this.viewer.getInput(), previousIndex, selectedIndex);
                addedTestCaseLinked.add(testSuiteTestCaseLinkTransferDatas[0].getTestSuiteTestCaseLink());
                this.viewer.updateDirty(true);
            }
            this.viewer.getTable().forceFocus();
            this.viewer.setSelection((ISelection)new StructuredSelection(addedTestCaseLinked));
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private List<TestCaseEntity> getTestCasesFromFolderTree(FolderTreeEntity folderTree) {
        ArrayList<TestCaseEntity> lstTestCases = new ArrayList<TestCaseEntity>();
        try {
            Object[] objectArray = folderTree.getChildren();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (child instanceof TestCaseTreeEntity) {
                    lstTestCases.add(((TestCaseTreeEntity)child).getObject());
                } else if (child instanceof FolderTreeEntity) {
                    lstTestCases.addAll(this.getTestCasesFromFolderTree((FolderTreeEntity)child));
                }
                ++n2;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return lstTestCases;
    }
}

