/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.providers;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Display;

public class DataColumnLabelProvider
extends StyledCellLabelProvider {
    private String searchString = "";

    public void setSearchString(String text) {
        this.searchString = text.trim().toLowerCase();
    }

    public void update(ViewerCell cell) {
        String cellText = cell.getElement().toString();
        cell.setText(cellText);
        if (this.searchString.equals("")) {
            cell.setStyleRanges(null);
        } else {
            Matcher matcher = Pattern.compile(this.searchString).matcher(cellText.toLowerCase());
            ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
            while (matcher.find()) {
                int rangeLength = matcher.end() - matcher.start();
                StyleRange myStyledRange = new StyleRange(matcher.start(), rangeLength, null, Display.getCurrent().getSystemColor(7));
                styleRanges.add(myStyledRange);
            }
            cell.setStyleRanges(styleRanges.toArray(new StyleRange[0]));
        }
        super.update(cell);
    }
}

