/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.support;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testsuite.parts.TestSuitePartDataBindingView;
import com.kms.katalon.entity.link.TestCaseTestDataLink;
import com.kms.katalon.entity.link.TestDataCombinationType;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.swt.widgets.Composite;

public class TestDataCombinationColumnEditingSupport
extends EditingSupport {
    private TestSuitePartDataBindingView mpart;

    public TestDataCombinationColumnEditingSupport(ColumnViewer viewer, TestSuitePartDataBindingView mpart) {
        super(viewer);
        this.mpart = mpart;
    }

    protected CellEditor getCellEditor(Object element) {
        if (element != null && element instanceof TestCaseTestDataLink) {
            return new CheckboxCellEditor((Composite)this.getViewer().getControl());
        }
        return null;
    }

    protected boolean canEdit(Object element) {
        if (!this.mpart.getSelectedTestCaseLink().isUsingDataBindingAtTestSuiteLevel()) {
            return false;
        }
        return element != null && element instanceof TestCaseTestDataLink;
    }

    protected Object getValue(Object element) {
        if (element != null && element instanceof TestCaseTestDataLink) {
            TestCaseTestDataLink link = (TestCaseTestDataLink)element;
            if (link.getCombinationType() == TestDataCombinationType.ONE) {
                return true;
            }
            return false;
        }
        return "";
    }

    protected void setValue(Object element, Object value) {
        try {
            if (element != null && element instanceof TestCaseTestDataLink && value instanceof Boolean) {
                TestCaseTestDataLink link = (TestCaseTestDataLink)element;
                boolean isOneOne = (Boolean)value;
                if (link.getCombinationType() == TestDataCombinationType.ONE != isOneOne) {
                    if (isOneOne) {
                        link.setCombinationType(TestDataCombinationType.ONE);
                    } else {
                        link.setCombinationType(TestDataCombinationType.MANY);
                    }
                    this.getViewer().update(element, null);
                    this.mpart.setDirty(true);
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

