/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.support;

import com.kms.katalon.composer.components.impl.editors.DataColumnChooserEditor;
import com.kms.katalon.composer.components.impl.support.TypeCheckedEditingSupport;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testsuite.constants.ComposerTestsuiteMessageConstants;
import com.kms.katalon.composer.testsuite.constants.StringConstants;
import com.kms.katalon.composer.testsuite.editors.VariableBindingScriptBuilderEditor;
import com.kms.katalon.composer.testsuite.parts.TestSuitePartDataBindingView;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.core.testdata.TestData;
import com.kms.katalon.core.testdata.TestDataFactory;
import com.kms.katalon.entity.link.TestCaseTestDataLink;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.testdata.DataFileEntity;
import java.text.MessageFormat;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class VariableValueEditingSupport
extends TypeCheckedEditingSupport<VariableLink> {
    private TestSuitePartDataBindingView testDataView;
    private TestData testData;

    public VariableValueEditingSupport(ColumnViewer viewer, TestSuitePartDataBindingView mpart) {
        super(viewer);
        this.testDataView = mpart;
    }

    public String[] getTestDataColumnNames(String testDataId) {
        try {
            if (StringUtils.isNotEmpty((String)testDataId)) {
                TestData testData = TestDataFactory.findTestDataForExternalBundleCaller((String)testDataId, (String)this.getProjectFolderLocation());
                return testData.getColumnNames();
            }
        }
        catch (Exception ex) {
            MessageDialog.openWarning(null, (String)StringConstants.WARN_TITLE, (String)MessageFormat.format(ComposerTestsuiteMessageConstants.PA_WARN_MSG_DATA_SRC_NOT_AVAILABLE, testDataId));
            LoggerSingleton.logError((Throwable)ex);
        }
        return null;
    }

    protected Class<VariableLink> getElementType() {
        return VariableLink.class;
    }

    protected CellEditor getCellEditorByElement(VariableLink variableLink) {
        Composite composite = this.getComposite();
        switch (variableLink.getType()) {
            case DATA_COLUMN: {
                return new DataColumnChooserEditor(composite, this.testData, variableLink.getValue());
            }
            case DATA_COLUMN_INDEX: {
                return new TextCellEditor(composite);
            }
            case SCRIPT_VARIABLE: {
                return new VariableBindingScriptBuilderEditor(composite, this.testDataView.getSelectedTestCaseLink(), variableLink.clone());
            }
        }
        return null;
    }

    protected boolean canEditElement(VariableLink variableLink) {
        switch (variableLink.getType()) {
            case DEFAULT: {
                return false;
            }
            case SCRIPT_VARIABLE: {
                return true;
            }
            case DATA_COLUMN: 
            case DATA_COLUMN_INDEX: {
                return this.isTestDataAvailable(variableLink);
            }
        }
        return false;
    }

    private String getProjectFolderLocation() {
        return ProjectController.getInstance().getCurrentProject().getFolderLocation();
    }

    private boolean isTestDataAvailable(VariableLink variableLink) {
        this.testData = null;
        TestSuiteTestCaseLink testCaseLink = this.testDataView.getSelectedTestCaseLink();
        if (testCaseLink == null) {
            return false;
        }
        TestCaseTestDataLink testDataLink = TestSuiteController.getInstance().getTestDataLink(variableLink.getTestDataLinkId(), testCaseLink);
        if (!this.isTestDataLinkValid(variableLink, testDataLink)) {
            return false;
        }
        String testDataId = testDataLink.getTestDataId();
        if (!this.isTestDataIdValid(variableLink, testDataId)) {
            return false;
        }
        String projectLocation = this.getProjectFolderLocation();
        try {
            this.testData = TestDataController.getInstance().getTestDataInstance(testDataId, projectLocation);
            return true;
        }
        catch (Exception ex) {
            MessageDialog.openWarning(null, (String)StringConstants.WARN_TITLE, (String)MessageFormat.format(ComposerTestsuiteMessageConstants.SUP_WARN_MSG_TEST_DATA_NOT_AVAILABLE, testDataId));
            LoggerSingleton.logError((Throwable)ex);
            return false;
        }
    }

    private boolean isTestDataLinkValid(VariableLink variableLink, TestCaseTestDataLink testDataLink) {
        if (testDataLink != null) {
            return true;
        }
        if (StringUtils.isEmpty((String)variableLink.getValue())) {
            MessageDialog.openInformation(null, (String)ComposerTestsuiteMessageConstants.INFORMATION_TITLE, (String)ComposerTestsuiteMessageConstants.SUP_INFORMATION_MSG_CHOOSE_TEST_DATA);
        } else {
            MessageDialog.openWarning(null, (String)StringConstants.WARN_TITLE, (String)ComposerTestsuiteMessageConstants.SUP_WARN_MSG_TEST_DATA_NOT_AVAILABLE);
        }
        return false;
    }

    private boolean isTestDataIdValid(VariableLink variableLink, String testDataId) {
        DataFileEntity dataFileEntity;
        block4: {
            try {
                dataFileEntity = TestDataController.getInstance().getTestDataByDisplayId(testDataId);
                if (dataFileEntity != null) break block4;
                MessageDialog.openWarning(null, (String)StringConstants.WARN_TITLE, (String)MessageFormat.format(ComposerTestsuiteMessageConstants.SUP_WARN_MSG_TEST_DATA_NOT_FOUND, testDataId));
                return false;
            }
            catch (Exception e) {
                MessageDialog.openWarning(null, (String)StringConstants.WARN_TITLE, (String)MessageFormat.format(ComposerTestsuiteMessageConstants.SUP_WARN_MSG_TEST_DATA_NOT_FOUND, testDataId));
                LoggerSingleton.logError((Throwable)e);
                return false;
            }
        }
        if (!dataFileEntity.isContainsHeaders() && variableLink.getType() == VariableLink.VariableType.DATA_COLUMN) {
            MessageDialog.openWarning(null, (String)StringConstants.WARN_TITLE, (String)MessageFormat.format(ComposerTestsuiteMessageConstants.SUP_WARN_MSG_TEST_DATA_NO_HEADER, testDataId));
            return false;
        }
        return true;
    }

    protected Object getElementValue(VariableLink variableLink) {
        return variableLink.getValue();
    }

    protected void setElementValue(VariableLink variableLink, Object value) {
        if (!(value instanceof String) || ObjectUtils.equals((Object)variableLink.getValue(), (Object)value)) {
            return;
        }
        variableLink.setValue((String)value);
        this.getViewer().refresh((Object)variableLink);
        this.testDataView.setDirty(true);
    }
}

