/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.application;

import com.kms.katalon.core.model.KatalonPackage;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.util.FileHashUtil;
import com.kms.katalon.util.NetworkUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Platform;

public class KatalonApplication {
    private static final String UNKNOWN_HOST = "Unknown";
    public static final String SESSION_ID = UUID.randomUUID().toString();
    private static final String MAC_ADDRESS = KatalonApplication.getMacAddress();
    public static final String USER_KEY = KatalonApplication.hashMacAndHostName();
    public static String USER_SESSION_ID = UUID.randomUUID().toString();

    public static void refreshUserSession() {
        USER_SESSION_ID = UUID.randomUUID().toString();
    }

    private static String hashMacAndHostName() {
        String hostName = KatalonApplication.getDefaultLocalName();
        String macAddress = KatalonApplication.getMacAddress();
        LocalMacAdress localMacAddress = new LocalMacAdress(hostName, macAddress);
        try {
            return FileHashUtil.hash((String)JsonUtil.toJson((Object)localMacAddress), (String)"MD5");
        }
        catch (IOException | NoSuchAlgorithmException e) {
            LogUtil.logError((Throwable)e);
            return macAddress;
        }
    }

    public static String getMachineId() {
        return USER_KEY;
    }

    private static String getDefaultLocalName() {
        String hostName;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            hostName = UNKNOWN_HOST;
        }
        return hostName;
    }

    public static KatalonPackage getKatalonPackage() {
        boolean isDevelopmentMode = Platform.inDevelopmentMode();
        boolean isRunningInKatalonC = KatalonApplication.isRunningInKatalonC();
        RunningMode runMode = ApplicationRunningMode.get();
        if (isRunningInKatalonC || isDevelopmentMode && runMode == RunningMode.CONSOLE) {
            return KatalonPackage.ENGINE;
        }
        return KatalonPackage.KSE;
    }

    private static boolean isRunningInKatalonC() {
        Properties props = System.getProperties();
        String launcherName = props.getProperty("eclipse.launcher.name");
        return "katalonc".equalsIgnoreCase(launcherName);
    }

    public static boolean isRunningInDevOpsEnvironment() {
        return "1.11".equals(System.getenv("ECLIPSE_SANDBOX"));
    }

    public static String getMacAddress() {
        String macAdress = "";
        try {
            macAdress = NetworkUtil.getMacAddress((String)NetworkUtil.getLocalHostAddress());
        }
        catch (SocketException | UnknownHostException iOException) {}
        return StringUtils.defaultString((String)macAdress, (String)UNKNOWN_HOST);
    }

    private static class LocalMacAdress {
        private String hostName;
        private String macAddress;

        public LocalMacAdress(String hostName, String macAddress) {
            this.setHostName(hostName);
            this.setMacAddress(macAddress);
        }

        public String getHostName() {
            return this.hostName;
        }

        public void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public String getMacAddress() {
            return this.macAddress;
        }

        public void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }
    }
}

