/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.application.hardware;

import com.kms.katalon.application.exception.KatalonRuntimeException;
import com.kms.katalon.logging.LogUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class Hardware4Nix {
    private static String sn = "";

    private Hardware4Nix() {
    }

    public static final String getSerialNumber() {
        if (sn == null) {
            Hardware4Nix.readDmidecode();
        }
        if (sn == null) {
            Hardware4Nix.readLshal();
        }
        if (sn == null) {
            throw new KatalonRuntimeException("Cannot find computer SN");
        }
        return sn;
    }

    private static BufferedReader read(String command) {
        OutputStream os = null;
        InputStream is = null;
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(command.split(" "));
        }
        catch (IOException e) {
            throw new KatalonRuntimeException(e);
        }
        os = process.getOutputStream();
        is = process.getInputStream();
        try {
            os.close();
        }
        catch (IOException e) {
            throw new KatalonRuntimeException(e);
        }
        return new BufferedReader(new InputStreamReader(is));
    }

    private static void readDmidecode() {
        String line = null;
        String marker = "Serial Number:";
        BufferedReader br = null;
        try {
            try {
                br = Hardware4Nix.read("dmidecode -t system");
                while ((line = br.readLine()) != null) {
                    if (line.indexOf(marker) == -1) continue;
                    sn = line.split(marker)[1].trim();
                    break;
                }
            }
            catch (IOException e) {
                throw new KatalonRuntimeException(e);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    LogUtil.logError((Throwable)e);
                }
            }
        }
    }

    private static void readLshal() {
        String line = null;
        String marker = "system.hardware.serial =";
        BufferedReader br = null;
        try {
            try {
                br = Hardware4Nix.read("lshal");
                while ((line = br.readLine()) != null) {
                    if (line.indexOf(marker) == -1) continue;
                    sn = line.split(marker)[1].replaceAll("\\(string\\)|(\\')", "").trim();
                    break;
                }
            }
            catch (IOException e) {
                throw new KatalonRuntimeException(e);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    LogUtil.logError((Throwable)e);
                }
            }
        }
    }
}

