/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.application.usagetracking;

import com.kms.katalon.application.KatalonApplication;
import com.kms.katalon.application.preference.ProjectSettingPreference;
import com.kms.katalon.application.usagetracking.UsageActionTrigger;
import com.kms.katalon.application.usagetracking.UsageInformation;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.util.FileUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class UsageInfoCollector {
    private static final String TEST_CASE_FOLDER = "Test Cases";
    private static final String REPORT_FOLDER = "Reports";
    private static final String EMAIL_KEY = "email";

    private UsageInfoCollector() {
    }

    private static Date restorePreviousUsageInfo(UsageInformation usageInfo) {
        try {
            String sTime = ApplicationInfo.getAppProperty("orgTime");
            if (sTime == null) {
                return new Date(0L);
            }
            usageInfo.setTestCaseCount(UsageInfoCollector.getIntProperty("ntc"));
            usageInfo.setTestCaseRunCount(UsageInfoCollector.getIntProperty("ntr"));
            usageInfo.setNewTestCaseCreatedCount(UsageInfoCollector.getIntProperty("ntcc"));
            usageInfo.setNewProjectCreatedCount(UsageInfoCollector.getIntProperty("npc"));
            return new Date(Long.parseLong(sTime));
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex);
            usageInfo.setTestCaseCount(0);
            usageInfo.setTestCaseRunCount(0);
            return new Date(0L);
        }
    }

    private static int getIntProperty(String key) {
        return Integer.parseInt(ApplicationInfo.getAppProperty(key));
    }

    public static UsageInformation getActivatedUsageInfo(UsageActionTrigger actionTrigger, RunningMode runningMode) {
        String email = ApplicationInfo.getAppProperty(EMAIL_KEY);
        UsageInformation usageInfo = UsageInformation.createActivatedInfo(email, KatalonApplication.SESSION_ID, KatalonApplication.USER_KEY);
        Date orgTime = UsageInfoCollector.restorePreviousUsageInfo(usageInfo);
        List<String> projectPaths = UsageInfoCollector.getRecentProjects();
        usageInfo.setVersion(ApplicationInfo.versionNo() + " build " + ApplicationInfo.buildNo());
        usageInfo.setTriggeredBy(actionTrigger.getAction());
        usageInfo.setRunningMode(runningMode.getMode());
        for (String prjPath : projectPaths) {
            try {
                UsageInfoCollector.collectUsageProjectInfo(prjPath, usageInfo, orgTime);
            }
            catch (IOException ex) {
                LogUtil.printAndLogError((Throwable)ex);
            }
        }
        return usageInfo;
    }

    public static UsageInformation getAnonymousUsageInfo(UsageActionTrigger actionTrigger, RunningMode runningMode) {
        UsageInformation usageInfo = UsageInformation.createAnonymousInfo(KatalonApplication.SESSION_ID, KatalonApplication.USER_KEY);
        usageInfo.setVersion(ApplicationInfo.versionNo() + " build " + ApplicationInfo.buildNo());
        usageInfo.setTriggeredBy(actionTrigger.getAction());
        usageInfo.setRunningMode(runningMode.getMode());
        return usageInfo;
    }

    private static void collectUsageProjectInfo(String prjPath, UsageInformation usageInfo, Date orgTime) throws IOException {
        File reportFolder = new File(prjPath + File.separator + REPORT_FOLDER);
        File testcaseFolder = new File(prjPath + File.separator + TEST_CASE_FOLDER);
        File[] csvFiles = FileUtil.getFiles((File)reportFolder, (String)".csv", (Date)orgTime);
        int newTestRunCount = 0;
        int newTestcaseCount = 0;
        if (FileUtil.isFileCreateAfter((File)new File(prjPath), (Date)orgTime)) {
            usageInfo.setNewProjectCount(usageInfo.getNewProjectCount() + 1);
        }
        usageInfo.setProjectCount(usageInfo.getProjectCount() + 1);
        newTestcaseCount = FileUtil.countAllFiles((File)testcaseFolder, (String)".tc", (Date)orgTime);
        usageInfo.setNewTestCaseCount(usageInfo.getNewTestCaseCount() + newTestcaseCount);
        usageInfo.setTestCaseCount(usageInfo.getTestCaseCount() + newTestcaseCount);
        File[] fileArray = csvFiles;
        int n = csvFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File csvfile = fileArray[n2];
            newTestRunCount += UsageInfoCollector.getNumberTestRun(csvfile);
            ++n2;
        }
        usageInfo.setNewTestRunCount(usageInfo.getNewTestRunCount() + newTestRunCount);
        usageInfo.setTestCaseRunCount(usageInfo.getTestCaseRunCount() + newTestRunCount);
    }

    private static int getNumberTestRun(File csvFile) {
        int count = 0;
        try {
            List<String> lines = Files.readAllLines(csvFile.toPath(), Charset.forName("UTF-8"));
            for (String line : lines) {
                if (!line.startsWith("Test Cases/")) continue;
                ++count;
            }
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex);
        }
        return count;
    }

    private static List<String> getRecentProjects() {
        ArrayList<String> projectPaths = new ArrayList<String>();
        try {
            for (ProjectEntity prEntity : new ProjectSettingPreference().getRecentProjects()) {
                projectPaths.add(prEntity.getFolderLocation());
            }
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex);
        }
        return projectPaths;
    }
}

