/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.application.utils;

import com.google.common.collect.Range;
import com.kms.katalon.application.exception.KatalonVersionFormatException;
import com.kms.katalon.application.utils.VersionInfo;
import com.kms.katalon.logging.LogUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class VersionRange {
    private static final String LOWER_CLOSED = "[";
    private static final String LOWER_OPEN = "(";
    private static final String UPPER_CLOSED = "]";
    private static final String UPPER_OPEN = ")";
    private static final String VERSION_SEPERATOR = "-";
    private static final String MSG_ILLEGAL_VERSION_INTERVAL_FORMAT = "{0} is an invalid version interval.";
    private Range<VersionInfo> versionInterval;
    private String maximumVersion;

    public VersionRange(String strVersionInterval, String latestVersion) {
        VersionInfo[] versionRange;
        this.maximumVersion = latestVersion;
        if (strVersionInterval.startsWith(LOWER_CLOSED)) {
            versionRange = this.getEndpoints(strVersionInterval.substring(1, strVersionInterval.length() - 1));
            if (strVersionInterval.endsWith(UPPER_CLOSED)) {
                this.versionInterval = Range.closed((Comparable)versionRange[0], (Comparable)versionRange[1]);
                return;
            }
            if (strVersionInterval.endsWith(UPPER_OPEN)) {
                this.versionInterval = Range.closedOpen((Comparable)versionRange[0], (Comparable)versionRange[1]);
                return;
            }
        }
        if (strVersionInterval.startsWith(LOWER_OPEN)) {
            versionRange = this.getEndpoints(strVersionInterval.substring(1, strVersionInterval.length() - 1));
            if (strVersionInterval.endsWith(UPPER_CLOSED)) {
                this.versionInterval = Range.openClosed((Comparable)versionRange[0], (Comparable)versionRange[1]);
                return;
            }
            if (strVersionInterval.endsWith(UPPER_OPEN)) {
                this.versionInterval = Range.open((Comparable)versionRange[0], (Comparable)versionRange[1]);
                return;
            }
        }
        if (!VersionRange.isValidKatalonVersion(strVersionInterval)) {
            throw new KatalonVersionFormatException(MessageFormat.format(MSG_ILLEGAL_VERSION_INTERVAL_FORMAT, strVersionInterval));
        }
        strVersionInterval = strVersionInterval.concat(VERSION_SEPERATOR).concat(strVersionInterval);
        versionRange = this.getEndpoints(strVersionInterval);
        this.versionInterval = Range.closed((Comparable)versionRange[0], (Comparable)versionRange[1]);
    }

    private VersionInfo[] getEndpoints(String versionInterval) {
        String upperVersionEnpoint;
        List<String> splittedEndpoints = this.split(versionInterval, VERSION_SEPERATOR);
        if (splittedEndpoints.size() != 2) {
            throw new KatalonVersionFormatException(MessageFormat.format(MSG_ILLEGAL_VERSION_INTERVAL_FORMAT, versionInterval));
        }
        if (splittedEndpoints.get(0).isEmpty()) {
            splittedEndpoints.set(0, "3.0.5");
        }
        if ((upperVersionEnpoint = splittedEndpoints.get(1)).isEmpty()) {
            upperVersionEnpoint = this.maximumVersion;
            int[] splittedVer = Arrays.stream(StringUtils.split((String)upperVersionEnpoint, (char)'.')).mapToInt(Integer::parseInt).toArray();
            int j = splittedVer.length;
            while (j < 5) {
                upperVersionEnpoint = upperVersionEnpoint.concat(".100");
                ++j;
            }
            splittedEndpoints.set(1, upperVersionEnpoint);
        }
        VersionInfo[] result = new VersionInfo[2];
        int i = 0;
        while (i < result.length) {
            int[] splittedVer = Arrays.stream(StringUtils.split((String)splittedEndpoints.get(i), (char)'.')).mapToInt(Integer::parseInt).toArray();
            String endpoint = splittedEndpoints.get(i);
            int j = splittedVer.length;
            while (j < 5) {
                endpoint = endpoint.concat(".0");
                ++j;
            }
            result[i] = new VersionInfo();
            result[i].setVersion(endpoint);
            ++i;
        }
        return result;
    }

    private List<String> split(String versionInterval, String seperator) {
        ArrayList<String> result = new ArrayList<String>();
        int seperatorIndex = versionInterval.indexOf(seperator);
        if (seperatorIndex >= versionInterval.length() || seperatorIndex < 0) {
            return null;
        }
        result.addAll(Arrays.asList(versionInterval.split(seperator)));
        if (seperatorIndex == versionInterval.length() - 1) {
            result.add("");
        }
        return result;
    }

    public static boolean isValidKatalonVersion(String version) {
        try {
            Arrays.stream(StringUtils.split((String)version, (char)'.')).mapToInt(Integer::parseInt).toArray();
        }
        catch (Exception exception) {
            LogUtil.logError((Throwable)exception);
            return false;
        }
        return true;
    }

    public boolean contains(String version) {
        VersionInfo comparedVersion = new VersionInfo();
        comparedVersion.setVersion(version);
        return this.versionInterval.contains((Comparable)comparedVersion);
    }
}

