/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.builder;

import cucumber.eclipse.editor.steps.BuildStorage;
import cucumber.eclipse.editor.steps.GlueRepository;
import cucumber.eclipse.editor.steps.GlueStorage;
import cucumber.eclipse.editor.steps.StepDefinitionsRepository;
import cucumber.eclipse.editor.steps.StepDefinitionsStorage;
import cucumber.eclipse.editor.steps.UniversalStepDefinitionsProvider;
import cucumber.eclipse.editor.util.FileUtil;
import cucumber.eclipse.steps.integration.GherkinStepWrapper;
import cucumber.eclipse.steps.integration.Glue;
import cucumber.eclipse.steps.integration.StepDefinition;
import cucumber.eclipse.steps.integration.StepPreferences;
import cucumber.eclipse.steps.integration.filter.Filter;
import cucumber.eclipse.steps.integration.filter.FilterUtil;
import cucumber.eclipse.steps.integration.filter.SameLocationFilter;
import cucumber.eclipse.steps.integration.marker.MarkerFactory;
import gherkin.formatter.Formatter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.ExamplesTableRow;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import gherkin.lexer.LexingError;
import gherkin.parser.Parser;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public class CucumberGherkinBuilder {
    protected MarkerFactory markerFactory = MarkerFactory.INSTANCE;
    protected final UniversalStepDefinitionsProvider stepDefinitionsProvider = UniversalStepDefinitionsProvider.INSTANCE;
    protected final BuildStorage<GlueRepository> glueStorage = GlueStorage.INSTANCE;
    protected volatile boolean fullBuildRequired = false;
    private IProject project;
    public static CucumberGherkinBuilder INSTANCE;

    public static CucumberGherkinBuilder getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CucumberGherkinBuilder();
        }
        return INSTANCE;
    }

    public void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        try {
            boolean glueDetectionEnabled = StepPreferences.INSTANCE.isStepDefinitionsMatchingEnabled();
            this.fullBuildRequired = false;
            delta.accept((IResourceDeltaVisitor)new KatalonGherkinBuildCheckVisitor(glueDetectionEnabled));
            if (this.fullBuildRequired && this.project != null) {
                this.fullBuild(this.project, monitor);
            } else {
                delta.accept((IResourceDeltaVisitor)new CucumberGherkinBuildVisitor(this.markerFactory, glueDetectionEnabled, monitor));
            }
            if (this.project != null) {
                this.glueStorage.persist(this.project, monitor);
            }
        }
        catch (CoreException e) {
            throw new CoreException((IStatus)new Status(4, "cucumber.eclipse.steps.integration", e.getMessage(), (Throwable)e));
        }
    }

    public void incrementalBuild(IResource resource, IProgressMonitor monitor) throws CoreException {
        try {
            boolean glueDetectionEnabled = StepPreferences.INSTANCE.isStepDefinitionsMatchingEnabled();
            this.fullBuildRequired = false;
            new CucumberGherkinBuildVisitor(this.markerFactory, glueDetectionEnabled, monitor).visit(resource);
            if (this.project != null) {
                this.glueStorage.persist(this.project, monitor);
            }
        }
        catch (CoreException e) {
            throw new CoreException((IStatus)new Status(4, "cucumber.eclipse.steps.integration", e.getMessage(), (Throwable)e));
        }
    }

    public void fullBuild(IProject project, IProgressMonitor monitor) throws CoreException {
        try {
            this.project = project;
            boolean glueDetectionEnabled = StepPreferences.INSTANCE.isStepDefinitionsMatchingEnabled();
            project.accept((IResourceVisitor)new CucumberGherkinBuildVisitor(this.markerFactory, glueDetectionEnabled, monitor));
            this.glueStorage.persist(project, monitor);
        }
        catch (CoreException e) {
            throw new CoreException((IStatus)new Status(4, "cucumber.eclipse.steps.integration", e.getMessage(), (Throwable)e));
        }
    }

    public void fullBuild(IProgressMonitor monitor) throws CoreException {
        if (this.project == null) {
            return;
        }
        this.fullBuild(this.project, monitor);
    }

    public void clean(IProgressMonitor monitor) throws CoreException {
        this.project.accept((IResourceVisitor)new CucumberGherkinCleanBuildVisitor(this.markerFactory, monitor));
    }

    class CucumberGherkinBuildVisitor
    implements IResourceVisitor,
    IResourceDeltaVisitor {
        private IProgressMonitor monitor;
        private MarkerFactory markerFactory;
        private boolean glueDetectionEnabled;

        public CucumberGherkinBuildVisitor(MarkerFactory markerFactory, boolean glueDetectionEnabled, IProgressMonitor monitor) {
            this.monitor = monitor;
            this.markerFactory = markerFactory;
            this.glueDetectionEnabled = glueDetectionEnabled;
        }

        public boolean visit(IResource resource) throws CoreException {
            return this.buildGherkin(resource, false, this.glueDetectionEnabled);
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            return this.buildGherkin(resource, true, this.glueDetectionEnabled);
        }

        protected boolean buildGherkin(IResource resource, boolean isIncrementalBuild, boolean glueDetectionEnabled) throws CoreException {
            boolean isGherkinFile;
            if (this.monitor.isCanceled()) {
                return false;
            }
            if (!resource.exists()) {
                return false;
            }
            long start = System.currentTimeMillis();
            if (!(resource instanceof IFile)) {
                return true;
            }
            if (resource.getFullPath().toString().contains("test-classes")) {
                return false;
            }
            IFile file = (IFile)resource;
            String fileExtension = file.getFileExtension();
            boolean bl = isGherkinFile = "feature".equals(fileExtension) || "story".equals(fileExtension);
            if (!isGherkinFile) {
                return true;
            }
            GlueRepository glueRepository = CucumberGherkinBuilder.this.glueStorage.getOrCreate(resource.getProject(), null);
            glueRepository.clean(resource);
            this.markerFactory.cleanMarkers(resource);
            try {
                String gherkinSource = FileUtil.read(file);
                MarkerFormatter formatter = new MarkerFormatter((IDocument)new Document(gherkinSource), resource, this.markerFactory, glueDetectionEnabled);
                Parser gherkinParser = new Parser((Formatter)formatter, false);
                gherkinParser.parse(gherkinSource, file.getFullPath().toString(), Integer.valueOf(0));
            }
            catch (LexingError e) {
                String error;
                String firstLine = e.getMessage().split("\\R", 2)[0];
                Pattern pattern = Pattern.compile("Lexing error on line (\\d+): '(.*)");
                Matcher matcher = pattern.matcher(firstLine);
                int lineNumber = 0;
                if (matcher.matches()) {
                    lineNumber = Integer.valueOf(matcher.group(1));
                    error = matcher.group(2);
                } else {
                    lineNumber = 0;
                    error = e.getMessage();
                }
                RuntimeException runtimeException = new RuntimeException("Syntax error: " + error);
                this.markerFactory.syntaxErrorOnGherkin(resource, (Exception)runtimeException, lineNumber);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new CoreException((IStatus)new Status(4, "cucumber.eclipse.steps.integration", e.getMessage()));
            }
            long end = System.currentTimeMillis();
            return true;
        }
    }

    class CucumberGherkinCleanBuildVisitor
    implements IResourceVisitor {
        private IProgressMonitor monitor;
        private MarkerFactory markerFactory;

        public CucumberGherkinCleanBuildVisitor(MarkerFactory markerFactory, IProgressMonitor monitor) {
            this.monitor = monitor;
            this.markerFactory = markerFactory;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (this.monitor.isCanceled()) {
                return false;
            }
            this.markerFactory.cleanMarkers(resource);
            GlueRepository glueRepository = CucumberGherkinBuilder.this.glueStorage.getOrCreate(CucumberGherkinBuilder.this.project, null);
            glueRepository.clean(resource);
            return true;
        }
    }

    class KatalonGherkinBuildCheckVisitor
    implements IResourceDeltaVisitor {
        private boolean glueDetectionEnabled;

        public KatalonGherkinBuildCheckVisitor(boolean glueDetectionEnabled) {
            this.glueDetectionEnabled = glueDetectionEnabled;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            boolean isGherkinFile;
            boolean contentChanged;
            IResource resource = delta.getResource();
            if (!resource.exists()) {
                return false;
            }
            if (!(resource instanceof IFile)) {
                if (resource instanceof IProject) {
                    boolean projectConfigurationChanged;
                    boolean bl = projectConfigurationChanged = (delta.getFlags() & 0x80000) != 0;
                    if (projectConfigurationChanged) {
                        CucumberGherkinBuilder.this.fullBuildRequired = true;
                    }
                }
                return true;
            }
            int flags = delta.getFlags();
            boolean bl = contentChanged = (flags & 0x100) != 0;
            if (!contentChanged) {
                return true;
            }
            if (resource.getFullPath().toString().contains("test-classes")) {
                return false;
            }
            IFile file = (IFile)resource;
            String fileExtension = file.getFileExtension();
            boolean bl2 = isGherkinFile = "feature".equals(fileExtension) || "story".equals(fileExtension);
            if (!isGherkinFile) {
                if (!this.glueDetectionEnabled) {
                    return true;
                }
                StepDefinitionsRepository stepDefinitionsRepository = StepDefinitionsStorage.INSTANCE.getOrCreate(CucumberGherkinBuilder.this.project, null);
                boolean isStepDefinitionsResource = stepDefinitionsRepository.isStepDefinitionsResource(resource);
                if (isStepDefinitionsResource && CucumberGherkinBuilder.this.stepDefinitionsProvider.support((IResource)file)) {
                    CucumberGherkinBuilder.this.fullBuildRequired = true;
                }
            }
            return true;
        }
    }

    protected class MarkerFormatter
    implements Formatter {
        private IResource gherkinFile;
        private IDocument gherkinDocument;
        private IProject project;
        private MarkerFactory markerFactory;
        private boolean inScenarioOutline = false;
        private List<Step> scenarioOutlineSteps;
        private boolean isGlueDetectionEnabled;
        private GlueRepository glueRepository;
        private StepPreferences stepPreferences = StepPreferences.INSTANCE;

        public MarkerFormatter(IDocument document, IResource gherkinFile, MarkerFactory markerFactory, boolean isGlueDetectionEnabled) throws CoreException {
            this.gherkinFile = gherkinFile;
            this.project = gherkinFile.getProject();
            this.gherkinDocument = document;
            this.markerFactory = markerFactory;
            this.isGlueDetectionEnabled = isGlueDetectionEnabled;
            this.glueRepository = CucumberGherkinBuilder.this.glueStorage.getOrCreate(this.project, null);
        }

        public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
            this.markerFactory.syntaxErrorOnGherkin(this.gherkinFile, (Exception)new ParseException(event, line));
        }

        public void uri(String uri) {
        }

        public void feature(Feature feature) {
        }

        public void scenarioOutline(ScenarioOutline scenarioOutline) {
            this.inScenarioOutline = true;
            this.scenarioOutlineSteps = new ArrayList<Step>();
        }

        public void examples(Examples examples) {
            ExamplesTableRow examplesHeader = (ExamplesTableRow)examples.getRows().get(0);
            int i = 1;
            while (i < examples.getRows().size()) {
                ExamplesTableRow currentExample = (ExamplesTableRow)examples.getRows().get(i);
                try {
                    this.matchScenarioOutlineExample(examplesHeader, currentExample);
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
                ++i;
            }
        }

        private void matchScenarioOutlineExample(ExamplesTableRow header, ExamplesTableRow example) throws CoreException {
            Map<String, String> exampleVariablesMap = this.getExampleVariablesMap(header, example);
            for (Step scenarioOutlineStepLine : this.scenarioOutlineSteps) {
                this.validate(scenarioOutlineStepLine, exampleVariablesMap, example.getLine());
            }
        }

        private String getResolvedStepStringForExample(Step stepLine, Map<String, String> examplesLineMap) {
            String derivateGherkinStep = stepLine.getName();
            if (examplesLineMap != null) {
                for (Map.Entry<String, String> examplesLineEntry : examplesLineMap.entrySet()) {
                    derivateGherkinStep = derivateGherkinStep.replace("<" + examplesLineEntry.getKey() + ">", examplesLineEntry.getValue());
                }
            }
            return derivateGherkinStep;
        }

        protected void validate(Step step) throws CoreException {
            if (!this.isGlueDetectionEnabled) {
                return;
            }
            Set<StepDefinition> allStepDefinitions = CucumberGherkinBuilder.this.stepDefinitionsProvider.getStepDefinitions(this.project);
            Set<StepDefinition> stepDefinitionsScope = this.filter((IFile)this.gherkinFile, allStepDefinitions);
            StepDefinition glueStepDefinition = this.glueRepository.findMatchingStep(stepDefinitionsScope, step.getName());
            boolean isFound = glueStepDefinition != null;
            GherkinStepWrapper gherkinStepWrapper = new GherkinStepWrapper(step, this.gherkinFile);
            if (isFound) {
                Glue glue = this.glueRepository.add(gherkinStepWrapper, glueStepDefinition);
                this.markerFactory.glueFound(glue);
            } else {
                this.markerFactory.unmatchedStep(this.gherkinDocument, gherkinStepWrapper);
                this.glueRepository.clean(step);
            }
        }

        private void validate(Step scenarioOutlineStepLine, Map<String, String> exampleVariablesMap, Integer exampleLine) throws CoreException {
            if (!this.isGlueDetectionEnabled) {
                return;
            }
            String derivateGherkinStepSource = this.getResolvedStepStringForExample(scenarioOutlineStepLine, exampleVariablesMap);
            Set<StepDefinition> allStepDefinitions = CucumberGherkinBuilder.this.stepDefinitionsProvider.getStepDefinitions(this.project);
            Set<StepDefinition> stepDefinitionsScope = this.filter((IFile)this.gherkinFile, allStepDefinitions);
            StepDefinition glueStepDefinition = this.glueRepository.findMatchingStep(stepDefinitionsScope, derivateGherkinStepSource);
            boolean isFound = glueStepDefinition != null;
            GherkinStepWrapper gherkinStepWrapper = new GherkinStepWrapper(scenarioOutlineStepLine, this.gherkinFile);
            if (isFound) {
                Glue glue = this.glueRepository.add(gherkinStepWrapper, glueStepDefinition);
                this.markerFactory.glueFound(glue);
            } else {
                this.markerFactory.unmatchedStep(this.gherkinDocument, gherkinStepWrapper);
                this.markerFactory.gherkinStepExampleUnmatch(this.gherkinDocument, this.gherkinFile, exampleLine.intValue());
            }
        }

        private Set<StepDefinition> filter(IFile gherkinFile, Set<StepDefinition> stepDefinitions) {
            HashSet<StepDefinition> filtered = new HashSet<StepDefinition>();
            String gherkinLocation = gherkinFile.getParent().getFullPath().toString();
            boolean shouldFilterInSameLocation = this.stepPreferences.isGlueOnlyInSameLocationEnabled();
            if (!shouldFilterInSameLocation) {
                return stepDefinitions;
            }
            SameLocationFilter sameLocationFilter = new SameLocationFilter(gherkinLocation);
            FilterUtil.filter(stepDefinitions, (Filter)sameLocationFilter, filtered);
            return filtered;
        }

        private Map<String, String> getExampleVariablesMap(ExamplesTableRow header, ExamplesTableRow values) {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            int i = 0;
            while (i < header.getCells().size()) {
                result.put((String)header.getCells().get(i), (String)values.getCells().get(i));
                ++i;
            }
            return result;
        }

        public void startOfScenarioLifeCycle(Scenario scenario) {
        }

        public void background(Background background) {
        }

        public void scenario(Scenario scenario) {
            this.inScenarioOutline = false;
        }

        public void step(Step step) {
            if (this.inScenarioOutline) {
                this.scenarioOutlineSteps.add(step);
                return;
            }
            try {
                this.validate(step);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }

        public void endOfScenarioLifeCycle(Scenario scenario) {
        }

        public void done() {
        }

        public void close() {
        }

        public void eof() {
        }
    }
}

