/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.editors.jumpto;

import cucumber.eclipse.editor.Activator;
import cucumber.eclipse.editor.steps.StepDefinitionsRepository;
import cucumber.eclipse.editor.steps.StepDefinitionsStorage;
import cucumber.eclipse.editor.util.ExtensionRegistryUtil;
import cucumber.eclipse.steps.integration.IStepDefinitionOpener;
import cucumber.eclipse.steps.integration.StepDefinition;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

class JumpToStepDefinition {
    JumpToStepDefinition() {
    }

    public static StepDefinition findStepDefinitionMatch(int selectionLineNumber, IFile gherkinFile) throws CoreException {
        String id;
        IMarker stepDefinitionMatchMarker = JumpToStepDefinition.findStepDefinitionMatchMarker(selectionLineNumber, gherkinFile);
        if (stepDefinitionMatchMarker != null && (id = (String)stepDefinitionMatchMarker.getAttribute("cucumber.eclipse.marker.stepdef.matches.jdt_handler_identifier")) != null) {
            StepDefinitionsRepository repository = StepDefinitionsStorage.INSTANCE.getOrCreate(gherkinFile.getProject(), null);
            Set<StepDefinition> stepDefinitions = repository.getAllStepDefinitions();
            for (StepDefinition step : stepDefinitions) {
                if (!id.equals(step.getId())) continue;
                return step;
            }
        }
        return null;
    }

    public static IMarker findStepDefinitionMatchMarker(int selectionLineNumber, IFile gherkinFile) throws CoreException {
        IMarker[] markers;
        IMarker stepDefinitionMatchMarker = null;
        IMarker[] iMarkerArray = markers = gherkinFile.findMarkers("cucumber.eclipse.marker.stepdef.matches", false, 0);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            Integer lineNumber = (Integer)marker.getAttribute("lineNumber");
            if (lineNumber.equals(selectionLineNumber)) {
                stepDefinitionMatchMarker = marker;
                break;
            }
            ++n2;
        }
        if (stepDefinitionMatchMarker == null) {
            return null;
        }
        return stepDefinitionMatchMarker;
    }

    public static void openEditor(StepDefinition stepDefinition) {
        try {
            List<IStepDefinitionOpener> openers = ExtensionRegistryUtil.getStepDefinitionOpener();
            for (IStepDefinitionOpener opener : openers) {
                if (!opener.canOpen(stepDefinition)) continue;
                opener.openInEditor(stepDefinition);
                return;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            Activator.getDefault().getLog().log((IStatus)new Status(4, "cucumber.eclipse.editor", String.format("Failed to open step definition %s", stepDefinition.getSource().getFullPath()), (Throwable)e));
        }
    }
}

