/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.analytics.handlers;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.tree.TestOpsTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.analytics.constants.ComposerIntegrationAnalyticsMessageConstants;
import com.kms.katalon.composer.integration.analytics.parts.ExecutionHistoryPart;
import com.kms.katalon.composer.integration.analytics.parts.PlanViewerPart;
import com.kms.katalon.composer.integration.analytics.parts.ReleasePart;
import com.kms.katalon.composer.integration.analytics.utils.ReportImporter;
import com.kms.katalon.testcloud.core.service.ITestCloudController;
import com.kms.katalon.testops.core.model.exception.TestOpsException;
import com.kms.katalon.testops.core.services.ITestOpsController;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.internal.workbench.PartServiceImpl;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenTestOpsHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private static EModelService modelService;
    @Inject
    private MApplication application;
    @Inject
    private IEclipseContext context;
    @Inject
    private ITestOpsController testOpsController;
    @Inject
    private ITestCloudController testCloudController;
    private static final String EXECUTION_HISTORY_COMPOSITE_PART_ID = "execution_history_composite_part_id";
    private static final String RELEASE_COMPOSITE_PART_ID = "testops_release_composite_part_id";
    private static final String TESTOPS_BUNDLE_URI = "bundleclass://com.kms.katalon.composer.integration.analytics/";
    private static final String EXECUTION_PART_URI;
    private static final String RELEASE_PART_URI;
    private static final String PLAN_COMPOSITE_PART_ID = "plan_composite_part_id";
    private static final String PLAN_PART_URI;

    static {
        EXECUTION_PART_URI = TESTOPS_BUNDLE_URI + ExecutionHistoryPart.class.getName();
        RELEASE_PART_URI = TESTOPS_BUNDLE_URI + ReleasePart.class.getName();
        PLAN_PART_URI = TESTOPS_BUNDLE_URI + PlanViewerPart.class.getName();
    }

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/OPEN_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object instanceof TestOpsTreeEntity) {
                    OpenTestOpsHandler.this.openTestOps((TestOpsTreeEntity)object);
                }
            }
        });
    }

    @Inject
    @Optional
    public void projectOpened(@UIEventTopic(value="PROJECT/OPENED") Object eventData) {
        this.eventBroker.send("PROJECT/RELOAD_SESSION", null);
    }

    @Inject
    @Optional
    public void projectClosed(@UIEventTopic(value="PROJECT/CLOSED") Object eventData) {
        this.closeExecutionView();
        this.closePlanView();
        this.closeReleaseView();
        this.cancelAllReportDownloadJob();
        this.eventBroker.send("PROJECT/RELOAD_SESSION", null);
    }

    @Inject
    @Optional
    public void projectReloadSession(@UIEventTopic(value="PROJECT/RELOAD_SESSION") Object eventData) {
        try {
            this.testOpsController.reload(null);
        }
        catch (TestOpsException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void openTestOps(TestOpsTreeEntity sourceObject) {
        switch (sourceObject.getTesOpsAction()) {
            case OPEN_EXECUTION: {
                this.openExecutionView();
                return;
            }
            case OPEN_RELEASE: {
                this.openReleaseView();
                return;
            }
            case OPEN_PLAN: {
                this.openPlanView();
                return;
            }
        }
    }

    private void openReleaseView() {
        MCompositePart executionHistoryCompositePart = null;
        try {
            MPartStack stack = (MPartStack)modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
            if (stack != null) {
                EPartService partService;
                executionHistoryCompositePart = (MCompositePart)modelService.find(RELEASE_COMPOSITE_PART_ID, (MUIElement)stack);
                if (executionHistoryCompositePart == null) {
                    executionHistoryCompositePart = (MCompositePart)modelService.createModelElement(MCompositePart.class);
                    executionHistoryCompositePart.setElementId(RELEASE_COMPOSITE_PART_ID);
                    executionHistoryCompositePart.setLabel(ComposerIntegrationAnalyticsMessageConstants.LBL_RELEASES);
                    executionHistoryCompositePart.setCloseable(true);
                    executionHistoryCompositePart.setContributionURI(RELEASE_PART_URI);
                    executionHistoryCompositePart.setIconURI(ImageConstants.URL_TESTOPS_RELEASES);
                    executionHistoryCompositePart.setTooltip(ComposerIntegrationAnalyticsMessageConstants.LBL_RELEASES);
                    stack.getChildren().add(executionHistoryCompositePart);
                }
                if ((partService = (EPartService)this.context.getActive(EPartService.class)) == null) {
                    partService = (EPartService)this.context.getActive(PartServiceImpl.class);
                }
                partService.activate((MPart)executionHistoryCompositePart, true);
                stack.setSelectedElement((MUIElement)executionHistoryCompositePart);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void closeReleaseView() {
        MCompositePart releaseCompositePart = null;
        try {
            MPartStack stack = (MPartStack)modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
            if (stack != null && (releaseCompositePart = (MCompositePart)modelService.find(RELEASE_COMPOSITE_PART_ID, (MUIElement)stack)) != null) {
                stack.getChildren().remove(releaseCompositePart);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void closeExecutionView() {
        MCompositePart executionHistoryCompositePart = null;
        try {
            MPartStack stack = (MPartStack)modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
            if (stack != null && (executionHistoryCompositePart = (MCompositePart)modelService.find(EXECUTION_HISTORY_COMPOSITE_PART_ID, (MUIElement)stack)) != null) {
                stack.getChildren().remove(executionHistoryCompositePart);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void openExecutionView() {
        MCompositePart executionHistoryCompositePart = null;
        try {
            MPartStack stack = (MPartStack)modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
            if (stack != null) {
                EPartService partService;
                executionHistoryCompositePart = (MCompositePart)modelService.find(EXECUTION_HISTORY_COMPOSITE_PART_ID, (MUIElement)stack);
                if (executionHistoryCompositePart == null) {
                    executionHistoryCompositePart = (MCompositePart)modelService.createModelElement(MCompositePart.class);
                    executionHistoryCompositePart.setElementId(EXECUTION_HISTORY_COMPOSITE_PART_ID);
                    executionHistoryCompositePart.setLabel(ComposerIntegrationAnalyticsMessageConstants.LBL_EXECUTIONS);
                    executionHistoryCompositePart.setCloseable(true);
                    executionHistoryCompositePart.setContributionURI(EXECUTION_PART_URI);
                    executionHistoryCompositePart.setIconURI(ImageConstants.URL_TESTOPS_EXECUTIONS);
                    executionHistoryCompositePart.setTooltip(ComposerIntegrationAnalyticsMessageConstants.LBL_EXECUTIONS);
                    stack.getChildren().add(executionHistoryCompositePart);
                }
                if ((partService = (EPartService)this.context.getActive(EPartService.class)) == null) {
                    partService = (EPartService)this.context.getActive(PartServiceImpl.class);
                }
                partService.activate((MPart)executionHistoryCompositePart, true);
                stack.setSelectedElement((MUIElement)executionHistoryCompositePart);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void closePlanView() {
        MCompositePart planCompositePart = null;
        try {
            MPartStack stack = (MPartStack)modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
            if (stack != null && (planCompositePart = (MCompositePart)modelService.find(PLAN_COMPOSITE_PART_ID, (MUIElement)stack)) != null) {
                stack.getChildren().remove(planCompositePart);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void openPlanView() {
        MCompositePart planCompositePart = null;
        try {
            MPartStack stack = (MPartStack)modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
            if (stack != null) {
                EPartService partService;
                planCompositePart = (MCompositePart)modelService.find(PLAN_COMPOSITE_PART_ID, (MUIElement)stack);
                if (planCompositePart == null) {
                    planCompositePart = (MCompositePart)modelService.createModelElement(MCompositePart.class);
                    planCompositePart.setElementId(PLAN_COMPOSITE_PART_ID);
                    planCompositePart.setLabel(ComposerIntegrationAnalyticsMessageConstants.LBL_PLANS);
                    planCompositePart.setCloseable(true);
                    planCompositePart.setContributionURI(PLAN_PART_URI);
                    planCompositePart.setIconURI(ImageConstants.URL_TESTOPS_PLAN);
                    planCompositePart.setTooltip(ComposerIntegrationAnalyticsMessageConstants.LBL_PLANS);
                    stack.getChildren().add(planCompositePart);
                }
                if ((partService = (EPartService)this.context.getActive(EPartService.class)) == null) {
                    partService = (EPartService)this.context.getActive(PartServiceImpl.class);
                }
                partService.activate((MPart)planCompositePart, true);
                stack.setSelectedElement((MUIElement)planCompositePart);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void cancelAllReportDownloadJob() {
        ReportImporter.cancelAllJob();
    }
}

