/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.capability.repository.impl;

import com.katalon.capability.constant.DriverType;
import com.katalon.capability.exception.UnsupportedDriverTypeException;
import com.katalon.capability.exception.WriteCapabilityException;
import com.katalon.capability.exception.WriteCustomCapabilityException;
import com.katalon.capability.factory.ICapabilityHandlerFactory;
import com.katalon.capability.handler.ICapabilityHandler;
import com.katalon.capability.model.CapabilitySetting;
import com.katalon.capability.model.CustomCapabilitySetting;
import com.katalon.capability.model.ICapabilitySetting;
import com.katalon.capability.repository.ICapabilityRepository;
import com.katalon.capability.repository.ICustomCapabilityRepository;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CustomCapabilityRepositoryImpl
implements ICustomCapabilityRepository {
    private static final String CUSTOM_CAPABILITY_ROOT_FOLDER = "%s" + File.separator + PropertySettingStoreUtil.EXTERNAL_SETTING_ROOT_FOLDER_NAME + File.separator + "execution";
    private final ICapabilityHandlerFactory capabilityHandlerFactory;
    private final ICapabilityRepository capabilityRepository;

    @Inject
    public CustomCapabilityRepositoryImpl(ICapabilityHandlerFactory capabilityHandlerFactory, ICapabilityRepository capabilityRepository) {
        this.capabilityHandlerFactory = capabilityHandlerFactory;
        this.capabilityRepository = capabilityRepository;
    }

    @Override
    public List<CustomCapabilitySetting> getAppCustomCapabilities() {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        if (currentProject == null) {
            return new ArrayList<CustomCapabilitySetting>();
        }
        File customCapabilityRootFolder = new File(CUSTOM_CAPABILITY_ROOT_FOLDER.formatted(currentProject.getFolderLocation()));
        if (!customCapabilityRootFolder.exists() || !customCapabilityRootFolder.isDirectory()) {
            return new ArrayList<CustomCapabilitySetting>();
        }
        ArrayList<CustomCapabilitySetting> result = new ArrayList<CustomCapabilitySetting>();
        File[] fileArray = customCapabilityRootFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File customProfile = fileArray[n2];
            if (this.isCustomCapabilityFolder(customProfile)) {
                if (this.isEmpty(customProfile)) {
                    result.add(new CustomCapabilitySetting(customProfile.getName()));
                } else {
                    LinkedHashMap<DriverType, CapabilitySetting> capabilityMap = new LinkedHashMap<DriverType, CapabilitySetting>();
                    File[] fileArray2 = customProfile.listFiles();
                    int n3 = fileArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        CapabilitySetting capabilitySetting;
                        File capabilityFile = fileArray2[n4];
                        if (capabilityFile.isFile() && !capabilityFile.isHidden() && (capabilitySetting = this.readCapabilitySetting(capabilityFile)) != null) {
                            capabilityMap.put(capabilitySetting.getDriverType(), capabilitySetting);
                        }
                        ++n4;
                    }
                    result.add(new CustomCapabilitySetting(customProfile.getName(), capabilityMap));
                }
            }
            ++n2;
        }
        result.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        return result;
    }

    @Override
    public void saveCustomCapability(File customCapabilityRootFolder, CustomCapabilitySetting customCapabilitySetting) throws WriteCustomCapabilityException, UnsupportedDriverTypeException, IOException, WriteCapabilityException {
        if (customCapabilityRootFolder == null || customCapabilitySetting == null) {
            return;
        }
        File customCapabilityFolder = new File(customCapabilityRootFolder, customCapabilitySetting.getName());
        if (!customCapabilityFolder.exists() && !customCapabilityFolder.mkdirs()) {
            throw new WriteCustomCapabilityException("Cannot create custom capability folder: %s".formatted(customCapabilityFolder.getAbsolutePath()));
        }
        Map capabilitySettingMap = customCapabilitySetting.getValues();
        if (capabilitySettingMap == null || capabilitySettingMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : capabilitySettingMap.entrySet()) {
            ICapabilityHandler capabilityHandler;
            DriverType driverType = (DriverType)entry.getKey();
            ICapabilitySetting capabilitySetting = (ICapabilitySetting)entry.getValue();
            if (driverType == null || capabilitySetting == null || (capabilityHandler = this.capabilityHandlerFactory.getCapabilityHandler(driverType)) == null) continue;
            String capabilityFileName = capabilityHandler.buildCapabilityFileName();
            File capabilityFile = new File(customCapabilityFolder, capabilityFileName);
            this.capabilityRepository.writeCapabilityMapToFile(capabilityFile.getAbsolutePath(), Collections.singletonMap(driverType, capabilitySetting.getValue()));
        }
    }

    private CapabilitySetting readCapabilitySetting(File capabilityFile) {
        Map<DriverType, Map<String, Object>> capability = this.capabilityRepository.readCapabilityMapFromFile(capabilityFile.getAbsolutePath());
        return capability.entrySet().stream().findFirst().map(entry -> new CapabilitySetting((DriverType)entry.getKey(), (Map)entry.getValue())).orElse(null);
    }

    private boolean isEmpty(File customProfile) {
        File[] files = customProfile.listFiles();
        return files == null || files.length == 0;
    }

    private boolean isCustomCapabilityFolder(File customProfile) {
        return customProfile.isDirectory() && !customProfile.isHidden();
    }
}

