/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest;

import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.integration.IntegratedType;
import com.kms.katalon.integration.qtest.QTestIntegrationAuthenticationManager;
import com.kms.katalon.integration.qtest.QTestIntegrationUserManager;
import com.kms.katalon.integration.qtest.api.services.BasicApiWebServiceClient;
import com.kms.katalon.integration.qtest.api.services.design.model.ExtendedTestCase;
import com.kms.katalon.integration.qtest.api.services.design.transform.ExtendedTestCaseJsonUnmarshaller;
import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.entity.QTestProject;
import com.kms.katalon.integration.qtest.entity.QTestStep;
import com.kms.katalon.integration.qtest.entity.QTestTestCase;
import com.kms.katalon.integration.qtest.entity.QTestUser;
import com.kms.katalon.integration.qtest.exception.QTestException;
import com.kms.katalon.integration.qtest.exception.QTestIOException;
import com.kms.katalon.integration.qtest.exception.QTestInvalidFormatException;
import com.kms.katalon.integration.qtest.exception.QTestUnauthorizedException;
import com.kms.katalon.integration.qtest.helper.QTestAPIRequestHelper;
import com.kms.katalon.integration.qtest.helper.QTestHttpRequestHelper;
import com.kms.katalon.integration.qtest.provider.QTestWebServiceClientProvider;
import com.kms.katalon.integration.qtest.setting.QTestSettingStore;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.qas.api.Request;
import org.qas.api.internal.util.json.JsonArray;
import org.qas.api.internal.util.json.JsonException;
import org.qas.api.internal.util.json.JsonObject;
import org.qas.qtest.api.internal.model.FieldValue;
import org.qas.qtest.api.services.design.TestDesignServiceClient;
import org.qas.qtest.api.services.design.model.CreateTestCaseRequest;
import org.qas.qtest.api.services.design.model.GetTestCaseRequest;
import org.qas.qtest.api.services.design.model.ListTestStepRequest;
import org.qas.qtest.api.services.design.model.TestCase;
import org.qas.qtest.api.services.design.model.TestStep;
import org.qas.qtest.api.services.design.model.transform.CreateTestCaseRequestMarshaller;
import org.qas.qtest.api.services.design.model.transform.GetTestCaseRequestMarshaller;

public class QTestIntegrationTestCaseManager {
    private QTestIntegrationTestCaseManager() {
    }

    public static QTestTestCase getQTestTestCaseByIntegratedEntity(IntegratedEntity integratedEntity) {
        if (integratedEntity == null || integratedEntity.getType() != IntegratedType.TESTCASE) {
            return null;
        }
        Map properties = integratedEntity.getProperties();
        if (properties == null) {
            return null;
        }
        String id = (String)properties.get("id");
        String name = (String)properties.get("name");
        String parentId = (String)properties.get("parentId");
        String pid = (String)properties.get("pid");
        String versionId = (String)properties.get("versionId");
        String version = (String)properties.get("version");
        QTestTestCase testCase = new QTestTestCase(Long.parseLong(id), name, Long.parseLong(parentId), pid);
        testCase.setVersionId(Long.parseLong(versionId));
        testCase.setVersion(version);
        return testCase;
    }

    public static IntegratedEntity getIntegratedEntityByQTestTestCase(QTestTestCase qTestTC) {
        IntegratedEntity testCaseIntegratedEntity = new IntegratedEntity();
        testCaseIntegratedEntity.setProductName("qTest");
        testCaseIntegratedEntity.setType(IntegratedType.TESTCASE);
        testCaseIntegratedEntity.getProperties().put("id", Long.toString(qTestTC.getId()));
        testCaseIntegratedEntity.getProperties().put("name", qTestTC.getName());
        testCaseIntegratedEntity.getProperties().put("parentId", Long.toString(qTestTC.getParentId()));
        testCaseIntegratedEntity.getProperties().put("pid", qTestTC.getPid());
        testCaseIntegratedEntity.getProperties().put("versionId", Long.toString(qTestTC.getVersionId()));
        testCaseIntegratedEntity.getProperties().put("version", qTestTC.getVersion());
        return testCaseIntegratedEntity;
    }

    public static void deleteTestCaseOnQTest(QTestTestCase qTestTC, QTestProject qTestProject, IQTestCredential credential) throws QTestException {
        if (qTestProject == null) {
            throw new QTestUnauthorizedException("Cannot find qTest project. Please select a qTest project on qTest setting page.");
        }
        LinkedHashMap<String, Object> bodyProperties = new LinkedHashMap<String, Object>();
        int testCaseType = QTestTestCase.getType();
        bodyProperties.put("id", Integer.toString(testCaseType) + "-" + qTestTC.getId());
        bodyProperties.put("objId", qTestTC.getId());
        bodyProperties.put("parentId", qTestTC.getParentId());
        bodyProperties.put("type", testCaseType);
        String url = "/p/" + Long.toString(qTestProject.getId()) + "/portal/tree/delete";
        QTestIntegrationAuthenticationManager.authenticate(credential.getUsername(), credential.getPassword());
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("data", QTestHttpRequestHelper.createDataBody(bodyProperties, true));
        QTestHttpRequestHelper.sendPostRequest(credential, url, body);
    }

    public static QTestTestCase addTestCase(QTestProject qTestProject, long parentId, String name, String description, IQTestCredential credential) throws Exception {
        String accessToken = credential.getToken().getAccessTokenHeader();
        if (!QTestIntegrationAuthenticationManager.validateToken(accessToken)) {
            throw new QTestUnauthorizedException("Token is not valid");
        }
        BasicApiWebServiceClient webServiceClient = QTestWebServiceClientProvider.getBasicApiWebServiceClient();
        long projectId = qTestProject.getId();
        ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
        try {
            JsonArray reponseJsonArray = QTestIntegrationTestCaseManager.getTestCaseFieldJsonArray(qTestProject.getId(), credential);
            QTestUser user = QTestIntegrationUserManager.getUser(qTestProject, credential);
            fieldValues.add(QTestIntegrationTestCaseManager.getTestCaseFieldValue("Type", "Automation", reponseJsonArray));
            FieldValue assignedUserField = QTestIntegrationTestCaseManager.getTestCaseFieldValue("Assigned To", "", reponseJsonArray);
            assignedUserField.setProperty("field_value", (Object)("[" + user.getId() + "]"));
            fieldValues.add(assignedUserField);
        }
        catch (JsonException jsonException) {}
        TestCase testCase = new TestCase().withName(name).withDescription(QTestIntegrationTestCaseManager.getUploadedDescription(description)).withParentId(Long.valueOf(parentId)).withFieldValues(fieldValues);
        CreateTestCaseRequest testCaseRequest = new CreateTestCaseRequest().withProjectId(Long.valueOf(projectId)).withTestCase(testCase);
        Request request = new CreateTestCaseRequestMarshaller().marshall(testCaseRequest);
        ExtendedTestCase testCaseResult = (ExtendedTestCase)((Object)webServiceClient.sendRequest(request, ExtendedTestCaseJsonUnmarshaller.getInstance()));
        QTestTestCase qTestCase = new QTestTestCase(testCaseResult.getId(), name, parentId, testCaseResult.getPid());
        qTestCase.setVersionId(testCaseResult.getTestCaseVersionId());
        qTestCase.setVersion(testCaseResult.getVersion());
        return qTestCase;
    }

    private static void updateTestCase(IQTestCredential credential, QTestProject qTestProject, QTestTestCase testCase) throws QTestException {
        String serverUrl = credential.getServerUrl();
        String url = serverUrl + "/api/v3/projects/" + Long.toString(qTestProject.getId()) + "/test-cases/" + testCase.getId();
        try {
            JsonArray reponseJsonArray = QTestIntegrationTestCaseManager.getTestCaseFieldJsonArray(qTestProject.getId(), credential);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            QTestUser user = QTestIntegrationUserManager.getUser(qTestProject, credential);
            JsonArray propertiesArray = new JsonArray();
            fieldValues.add(QTestIntegrationTestCaseManager.getTestCaseFieldValue("Type", "Automation", reponseJsonArray));
            FieldValue assignedUserField = QTestIntegrationTestCaseManager.getTestCaseFieldValue("Assigned To", "", reponseJsonArray);
            assignedUserField.setProperty("field_value", (Object)("[" + user.getId() + "]"));
            fieldValues.add(assignedUserField);
            LinkedHashMap<String, JsonArray> testCasePropertiesMap = new LinkedHashMap<String, JsonArray>();
            for (FieldValue fieldValue : fieldValues) {
                JsonObject fieldJsonObject = new JsonObject();
                fieldJsonObject.put("field_id", (Object)fieldValue.getId());
                fieldJsonObject.put("field_value", (Object)fieldValue.getValue());
                propertiesArray.put((Object)fieldJsonObject);
            }
            testCasePropertiesMap.put("properties", propertiesArray);
            QTestAPIRequestHelper.sendPutRequestViaAPI(url, credential.getToken(), new JsonObject(testCasePropertiesMap).toString());
        }
        catch (JsonException ex) {
            throw QTestInvalidFormatException.createInvalidJsonFormatException(ex.getMessage());
        }
    }

    public static String getUploadedDescription(String description) {
        String[] stringLines;
        if (description == null) {
            return "";
        }
        StringBuilder descriptionBuilder = new StringBuilder();
        String[] stringArray = stringLines = description.split("\n");
        int n = stringLines.length;
        int n2 = 0;
        while (n2 < n) {
            String stringLine = stringArray[n2];
            descriptionBuilder.append("<p>").append(StringEscapeUtils.escapeHtml((String)stringLine)).append("</p>");
            ++n2;
        }
        return descriptionBuilder.toString();
    }

    private static JsonArray getTestCaseFieldJsonArray(long projectId, IQTestCredential credential) throws QTestException {
        String response;
        block3: {
            String serverUrl = credential.getServerUrl();
            String url = serverUrl + "/api/v3/projects/" + Long.toString(projectId) + "/settings/test-cases/fields";
            response = QTestAPIRequestHelper.sendGetRequestViaAPI(url, credential.getToken());
            try {
                if (response != null && !response.isEmpty()) break block3;
                return null;
            }
            catch (JsonException jsonException) {
                throw QTestInvalidFormatException.createInvalidJsonFormatException(response);
            }
        }
        JsonArray responseJsonArray = new JsonArray(response);
        return responseJsonArray;
    }

    public static FieldValue getTestCaseFieldValue(String fieldName, String typeName, JsonArray responseJsonArray) throws JsonException {
        int index = 0;
        while (index < responseJsonArray.length()) {
            JsonObject fieldJsonObject = responseJsonArray.getJsonObject(index);
            String responseFieldName = fieldJsonObject.getString("label");
            if (fieldName.equalsIgnoreCase(responseFieldName)) {
                if (fieldJsonObject.has("allowed_values")) {
                    JsonArray allowedValueJsonArray = fieldJsonObject.getJsonArray("allowed_values");
                    int entryIndex = 0;
                    while (entryIndex < allowedValueJsonArray.length()) {
                        JsonObject entryJsonObject = allowedValueJsonArray.getJsonObject(entryIndex);
                        if (typeName.equalsIgnoreCase(entryJsonObject.getString("label"))) {
                            FieldValue fieldValue = new FieldValue(Long.valueOf(fieldJsonObject.getLong("id")), entryJsonObject.getString("value"));
                            return fieldValue;
                        }
                        ++entryIndex;
                    }
                }
                return new FieldValue(Long.valueOf(fieldJsonObject.getLong("id")), null);
            }
            ++index;
        }
        return null;
    }

    public static QTestTestCase getTestCaseFromQTest(IQTestCredential credential, long projectId, long qTestId, Long qTestVersionId) throws Exception {
        return QTestIntegrationTestCaseManager.getTestCaseFromQTest(credential, projectId, qTestId, qTestVersionId, false);
    }

    public static QTestTestCase getTestCaseFromQTest(IQTestCredential credential, long projectId, long qTestId, Long qTestVersionId, boolean includeTestSteps) throws Exception {
        String accessToken = credential.getToken().getAccessTokenHeader();
        if (!QTestIntegrationAuthenticationManager.validateToken(accessToken)) {
            throw new QTestUnauthorizedException("Token is not valid");
        }
        BasicApiWebServiceClient webServiceClient = QTestWebServiceClientProvider.getBasicApiWebServiceClient();
        GetTestCaseRequest getTestCaseRequest = new GetTestCaseRequest().withProjectId(Long.valueOf(projectId)).withTestCaseId(Long.valueOf(qTestId)).withTestCaseVersion(qTestVersionId).withIncludeTeststeps(includeTestSteps);
        Request request = new GetTestCaseRequestMarshaller().marshall(getTestCaseRequest);
        ExtendedTestCase testCaseResult = (ExtendedTestCase)((Object)webServiceClient.sendRequest(request, ExtendedTestCaseJsonUnmarshaller.getInstance()));
        QTestTestCase qTestTestCase = new QTestTestCase(qTestId, testCaseResult.getName(), testCaseResult.getParentId(), testCaseResult.getPid());
        qTestTestCase.setVersionId(testCaseResult.getTestCaseVersionId());
        qTestTestCase.setDescription(testCaseResult.getDescription());
        qTestTestCase.setVersion(testCaseResult.getVersion());
        List testSteps = testCaseResult.getTestSteps();
        for (TestStep testStep : testSteps) {
            QTestStep qTestStep = new QTestStep();
            qTestStep.setId(testStep.getId());
            qTestStep.setDescription(testStep.getDescription());
            qTestStep.setExpectedResult(testStep.getExpected());
            qTestStep.setOrder(testSteps.indexOf(testStep) + 1);
            qTestTestCase.addStep(qTestStep);
        }
        return qTestTestCase;
    }

    public static URL navigatedUrlToQTestTestCase(QTestProject qTestProject, QTestTestCase testCase, String projectDir) throws QTestIOException {
        try {
            String url = QTestSettingStore.getServerUrl(QTestSettingStore.isEncryptionEnabled(projectDir), projectDir);
            return new URL(url + "/p/" + Long.toString(qTestProject.getId()) + "/portal/project#id=" + Long.toString(testCase.getId()) + "&object=" + QTestTestCase.getType() + "&tab=testdesign");
        }
        catch (IOException ex) {
            throw new QTestIOException(ex);
        }
    }

    public static long getTestCaseVersionId(IQTestCredential credential, long projectId, long testCaseId) throws QTestException {
        int versionSize;
        JsonArray childrenJsonArray;
        block4: {
            String serverUrl = credential.getServerUrl();
            if (!QTestIntegrationAuthenticationManager.validateToken(credential.getToken().getAccessTokenHeader())) {
                throw new QTestUnauthorizedException("Token is not valid");
            }
            String url = serverUrl + "/api/v3/projects/" + Long.toString(projectId) + "/test-cases/" + Long.toString(testCaseId) + "/versions";
            String result = QTestAPIRequestHelper.sendGetRequestViaAPI(url, credential.getToken());
            try {
                childrenJsonArray = new JsonArray(result);
                versionSize = childrenJsonArray.length();
                if (versionSize != 0) break block4;
                return 0L;
            }
            catch (JsonException jsonException) {
                throw QTestInvalidFormatException.createInvalidJsonFormatException(result);
            }
        }
        JsonObject childJsonObject = childrenJsonArray.getJsonObject(versionSize - 1);
        return childJsonObject.getLong("test_case_version_id");
    }

    public static List<QTestStep> getListSteps(IQTestCredential credential, long projectId, QTestTestCase testCase) throws Exception {
        String accessToken = credential.getToken().getAccessTokenHeader();
        if (!QTestIntegrationAuthenticationManager.validateToken(accessToken)) {
            throw new QTestUnauthorizedException("Token is not valid");
        }
        if (testCase.getVersionId() <= 0L) {
            long testCaseVersionId = QTestIntegrationTestCaseManager.getTestCaseVersionId(credential, projectId, testCase.getId());
            testCase.setVersionId(testCaseVersionId);
            QTestTestCase testCaseFromQTest = QTestIntegrationTestCaseManager.getTestCaseFromQTest(credential, projectId, testCase.getId(), testCaseVersionId);
            testCase.setVersion(testCaseFromQTest.getVersion());
            String description = StringEscapeUtils.unescapeHtml((String)testCaseFromQTest.getDescription().replace("<p>", "").replace("</p>", ""));
            testCase.setDescription(description);
        }
        TestDesignServiceClient testDesignService = QTestWebServiceClientProvider.getTestDesignServiceClient();
        testDesignService.setEndpoint(credential.getServerUrl());
        ListTestStepRequest testStepRequest = new ListTestStepRequest().withProjectId(Long.valueOf(projectId)).withTestCaseId(Long.valueOf(testCase.getId())).withTestCaseVersion(Long.valueOf(testCase.getVersionId()));
        List result = testDesignService.listTestStep(testStepRequest);
        ArrayList<QTestStep> qTestSteps = new ArrayList<QTestStep>();
        for (TestStep testStep : result) {
            QTestStep qTestStep = new QTestStep();
            qTestStep.setDescription(testStep.getDescription());
            qTestStep.setExpectedResult(testStep.getExpected());
            qTestStep.setOrder(result.indexOf(testStep) + 1);
            qTestSteps.add(qTestStep);
        }
        return qTestSteps;
    }
}

