/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest;

import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.LogRecordController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.helper.LogRecordHelper;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseGroupLogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationFolderManager;
import com.kms.katalon.integration.qtest.QTestIntegrationProjectManager;
import com.kms.katalon.integration.qtest.QTestIntegrationReportManager;
import com.kms.katalon.integration.qtest.QTestIntegrationTestCaseManager;
import com.kms.katalon.integration.qtest.QTestIntegrationTestSuiteManager;
import com.kms.katalon.integration.qtest.entity.QTestLogUploadedPreview;
import com.kms.katalon.integration.qtest.entity.QTestModule;
import com.kms.katalon.integration.qtest.entity.QTestProject;
import com.kms.katalon.integration.qtest.entity.QTestReport;
import com.kms.katalon.integration.qtest.entity.QTestRun;
import com.kms.katalon.integration.qtest.entity.QTestStep;
import com.kms.katalon.integration.qtest.entity.QTestSuite;
import com.kms.katalon.integration.qtest.entity.QTestTestCase;
import com.kms.katalon.integration.qtest.exception.QTestInvalidFormatException;
import com.kms.katalon.integration.qtest.model.QTestLogEvaluation;
import com.kms.katalon.integration.qtest.model.TestCaseRepo;
import com.kms.katalon.integration.qtest.model.TestSuiteRepo;
import com.kms.katalon.integration.qtest.setting.QTestSettingCredential;
import com.kms.katalon.integration.qtest.setting.QTestSettingStore;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.util.ExceptionUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Whitelist;

public class QTestIntegrationUtil {
    private QTestIntegrationUtil() {
    }

    public static boolean isIntegrationEnable(ProjectEntity projectEntity) {
        if (projectEntity == null) {
            return false;
        }
        String projectDir = projectEntity.getFolderLocation();
        return QTestSettingStore.isIntegrationActive(projectDir);
    }

    public static IntegratedEntity getIntegratedEntity(IntegratedFileEntity fileEntity) {
        return fileEntity.getIntegratedEntity("qTest");
    }

    public static IntegratedFileEntity removeQTestIntegratedEntity(IntegratedFileEntity fileEntity) {
        IntegratedEntity qTestIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity(fileEntity);
        if (qTestIntegratedEntity != null) {
            fileEntity.getIntegratedEntities().remove(qTestIntegratedEntity);
        }
        return fileEntity;
    }

    public static List<TestCaseRepo> getTestCaseRepositories(ProjectEntity projectEntity, List<QTestProject> qTestProjects) {
        ArrayList<TestCaseRepo> testCaseRepositories = new ArrayList<TestCaseRepo>();
        for (QTestProject qTestProject : qTestProjects) {
            for (String testCaseFolderId : qTestProject.getTestCaseFolderIds()) {
                TestCaseRepo repo;
                block8: {
                    repo = new TestCaseRepo();
                    repo.setQTestProject(qTestProject);
                    repo.setFolderId(testCaseFolderId);
                    FolderEntity folderEntity = null;
                    QTestModule qTestModule = null;
                    try {
                        try {
                            IntegratedEntity integratedFolderEntity;
                            folderEntity = FolderController.getInstance().getFolderByDisplayId(projectEntity, testCaseFolderId);
                            if (folderEntity != null && (integratedFolderEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)folderEntity)) != null) {
                                qTestModule = QTestIntegrationFolderManager.getQTestModuleByIntegratedEntity(integratedFolderEntity);
                            }
                        }
                        catch (Exception ex) {
                            LogUtil.logError((Throwable)ex);
                            repo.setQTestModule(qTestModule);
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        repo.setQTestModule(qTestModule);
                        throw throwable;
                    }
                    repo.setQTestModule(qTestModule);
                }
                testCaseRepositories.add(repo);
            }
        }
        return testCaseRepositories;
    }

    public static List<TestSuiteRepo> getTestSuiteRepositories(ProjectEntity projectEntity, List<QTestProject> qTestProjects) {
        ArrayList<TestSuiteRepo> testSuiteRepositories = new ArrayList<TestSuiteRepo>();
        for (QTestProject qTestProject : qTestProjects) {
            for (String testCaseFolderId : qTestProject.getTestSuiteFolderIds()) {
                TestSuiteRepo repo = new TestSuiteRepo();
                repo.setQTestProject(qTestProject);
                repo.setFolderId(testCaseFolderId);
                testSuiteRepositories.add(repo);
            }
        }
        return testSuiteRepositories;
    }

    public static TestCaseRepo getTestCaseRepo(IntegratedFileEntity entity, ProjectEntity projectEntity) throws Exception {
        if (entity == null) {
            return null;
        }
        IntegratedEntity projectIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)projectEntity);
        if (projectIntegratedEntity == null) {
            return null;
        }
        List<QTestProject> qTestProjects = QTestIntegrationProjectManager.getQTestProjectsByIntegratedEntity(projectIntegratedEntity);
        String entityId = entity.getRelativePathForUI().replace(File.separator, "/");
        for (TestCaseRepo testCaseRepo : QTestIntegrationUtil.getTestCaseRepositories(projectEntity, qTestProjects)) {
            String repoFolderId = testCaseRepo.getFolderId();
            if (!entityId.startsWith(repoFolderId + "/") && !entityId.equals(repoFolderId)) continue;
            return testCaseRepo;
        }
        return null;
    }

    public static TestSuiteRepo getTestSuiteRepo(IntegratedFileEntity entity, ProjectEntity projectEntity) throws Exception {
        if (entity == null) {
            return null;
        }
        String entityId = entity.getRelativePathForUI().replace(File.separator, "/");
        return QTestIntegrationUtil.getTestSuiteRepo(entityId, projectEntity);
    }

    public static TestSuiteRepo getTestSuiteRepo(String entityId, ProjectEntity projectEntity) {
        IntegratedEntity projectIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)projectEntity);
        if (projectIntegratedEntity == null) {
            return null;
        }
        List<QTestProject> qTestProjects = QTestIntegrationProjectManager.getQTestProjectsByIntegratedEntity(projectIntegratedEntity);
        for (TestSuiteRepo testSuiteRepo : QTestIntegrationUtil.getTestSuiteRepositories(projectEntity, qTestProjects)) {
            String repoFolderId = testSuiteRepo.getFolderId();
            if (!entityId.startsWith(repoFolderId + "/") && !entityId.equals(repoFolderId)) continue;
            return testSuiteRepo;
        }
        return null;
    }

    public static boolean canBeDownloadedOrDisintegrated(IntegratedFileEntity entity, ProjectEntity projectEntity) throws Exception {
        boolean isIntegrated;
        boolean bl = isIntegrated = QTestIntegrationUtil.getIntegratedEntity(entity) != null;
        if (entity instanceof FolderEntity) {
            TestSuiteRepo testSuiteRepo;
            TestCaseRepo testCaseRepo;
            FolderEntity folderEntity = (FolderEntity)entity;
            if (folderEntity.getFolderType() == FolderEntity.FolderType.TESTCASE ? (testCaseRepo = QTestIntegrationUtil.getTestCaseRepo(entity, projectEntity)) == null : folderEntity.getFolderType() == FolderEntity.FolderType.TESTSUITE && (testSuiteRepo = QTestIntegrationUtil.getTestSuiteRepo(entity, projectEntity)) == null) {
                return false;
            }
            if (isIntegrated) {
                return true;
            }
            for (FileEntity childEntity : FolderController.getInstance().getChildren(folderEntity)) {
                if (!(childEntity instanceof IntegratedFileEntity) || !QTestIntegrationUtil.canBeDownloadedOrDisintegrated((IntegratedFileEntity)childEntity, projectEntity)) continue;
                return true;
            }
            return false;
        }
        if (entity instanceof TestCaseEntity) {
            return isIntegrated && QTestIntegrationUtil.getTestCaseRepo(entity, projectEntity) != null;
        }
        if (entity instanceof TestSuiteEntity) {
            return isIntegrated && QTestIntegrationUtil.getTestSuiteRepo(entity, projectEntity) != null;
        }
        return false;
    }

    public static boolean canBeUploaded(IntegratedFileEntity entity, ProjectEntity projectEntity) throws Exception {
        boolean isNotIntegrated;
        boolean bl = isNotIntegrated = QTestIntegrationUtil.getIntegratedEntity(entity) == null;
        if (entity instanceof FolderEntity) {
            if (((FolderEntity)entity).getFolderType() == FolderEntity.FolderType.TESTCASE) {
                if (QTestIntegrationUtil.getTestCaseRepo(entity, projectEntity) == null) {
                    return false;
                }
            } else if (((FolderEntity)entity).getFolderType() == FolderEntity.FolderType.TESTSUITE) {
                if (QTestIntegrationUtil.getTestSuiteRepo(entity, projectEntity) == null) {
                    return false;
                }
            } else {
                return false;
            }
            FolderEntity folderEntity = (FolderEntity)entity;
            for (FileEntity childEntity : FolderController.getInstance().getChildren(folderEntity)) {
                if (!QTestIntegrationUtil.canBeUploaded((IntegratedFileEntity)childEntity, projectEntity)) continue;
                return true;
            }
            return false;
        }
        if (entity instanceof TestCaseEntity) {
            if (isNotIntegrated && QTestIntegrationUtil.getTestCaseRepo(entity, projectEntity) != null) {
                QTestModule module = QTestIntegrationFolderManager.getQTestModuleByFolderEntity(entity.getParentFolder());
                return module == null || module.getId() > 0L;
            }
            return false;
        }
        if (entity instanceof TestSuiteEntity) {
            return QTestIntegrationUtil.getTestSuiteRepo(entity, projectEntity) != null;
        }
        return false;
    }

    public static String getTempDirPath() {
        String tempDir = ProjectController.getInstance().getTempDir();
        File qTestTempFolder = new File(tempDir, "qTest");
        if (!qTestTempFolder.exists()) {
            qTestTempFolder.mkdirs();
        }
        return qTestTempFolder.getAbsolutePath();
    }

    public static IntegratedFileEntity updateFileIntegratedEntity(IntegratedFileEntity entity, IntegratedEntity newIntegrated) {
        IntegratedEntity oldIntegrated = QTestIntegrationUtil.getIntegratedEntity(entity);
        int index = 0;
        if (oldIntegrated == null) {
            index = entity.getIntegratedEntities().size();
        } else {
            index = entity.getIntegratedEntities().indexOf(oldIntegrated);
            entity.getIntegratedEntities().remove(index);
        }
        if (index >= entity.getIntegratedEntities().size()) {
            entity.getIntegratedEntities().add(newIntegrated);
        } else {
            entity.getIntegratedEntities().add(index, oldIntegrated);
        }
        return entity;
    }

    public static void saveReportEntity(ReportEntity reportEntity, QTestLogUploadedPreview uploadedPreview) throws Exception {
        IntegratedEntity reportIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)reportEntity);
        QTestReport qTestReport = QTestIntegrationReportManager.getQTestReportByIntegratedEntity(reportIntegratedEntity);
        if (qTestReport == null) {
            qTestReport = new QTestReport();
        }
        qTestReport.getTestLogMap().put(uploadedPreview.getTestLogIndex(), uploadedPreview.getQTestLog());
        reportIntegratedEntity = QTestIntegrationReportManager.getIntegratedEntityByQTestReport(qTestReport);
        reportEntity = (ReportEntity)QTestIntegrationUtil.updateFileIntegratedEntity((IntegratedFileEntity)reportEntity, reportIntegratedEntity);
        ReportController.getInstance().updateReport(reportEntity);
    }

    public static TestSuiteEntity addNewTestRunToTestSuite(TestSuiteEntity testSuiteEntity, IntegratedEntity testSuiteIntegratedEntity, QTestSuite qTestSuite, QTestRun testRun, List<QTestSuite> qTestSuiteCollection) throws Exception {
        if (qTestSuite.getTestRuns().contains(testRun)) {
            return testSuiteEntity;
        }
        qTestSuite.getTestRuns().add(testRun);
        int index = 0;
        while (index < qTestSuiteCollection.size()) {
            if (qTestSuiteCollection.get(index).getId() == qTestSuite.getId()) {
                QTestIntegrationTestSuiteManager.addQTestSuiteToIntegratedEntity(qTestSuite, testSuiteIntegratedEntity, index);
                return TestSuiteController.getInstance().updateTestSuite(testSuiteEntity);
            }
            ++index;
        }
        return null;
    }

    public static List<QTestSuite> getUnuploadedQTestSuites(TestSuiteEntity testSuite) throws QTestInvalidFormatException {
        List<QTestSuite> qTestSuites = QTestIntegrationTestSuiteManager.getQTestSuiteListByIntegratedEntity(QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)testSuite));
        ArrayList<QTestSuite> unuploadedQTestSuites = new ArrayList<QTestSuite>();
        for (QTestSuite availableQTestSuite : qTestSuites) {
            if (availableQTestSuite.getId() > 0L) continue;
            unuploadedQTestSuites.add(availableQTestSuite);
        }
        return unuploadedQTestSuites;
    }

    public static TestCaseRepo getNewTestCaseRepo(QTestModule qTestModule, QTestProject qTestProject, FolderEntity folderEntity) {
        TestCaseRepo testCaseRepo = new TestCaseRepo();
        testCaseRepo.setQTestModule(qTestModule);
        testCaseRepo.setQTestProject(qTestProject);
        String folderId = folderEntity.getIdForDisplay();
        testCaseRepo.setFolderId(folderId);
        return testCaseRepo;
    }

    public static TestSuiteRepo getNewTestSuiteRepo(QTestProject qTestProject, FolderEntity folderEntity) {
        TestSuiteRepo testSuiteRepo = new TestSuiteRepo();
        testSuiteRepo.setQTestProject(qTestProject);
        String folderId = folderEntity.getIdForDisplay();
        testSuiteRepo.setFolderId(folderId);
        return testSuiteRepo;
    }

    public static QTestLogEvaluation evaluateTestCaseLog(TestCaseLogRecord testCaseLogRecord, QTestSuite qTestSuite, ReportEntity reportEntity) {
        QTestTestCase qTestCase = QTestIntegrationUtil.getQTestCase(testCaseLogRecord);
        if (qTestCase == null) {
            return QTestLogEvaluation.CANNOT_INTEGRATE;
        }
        if (!QTestIntegrationUtil.isSameQTestProject(testCaseLogRecord, LogRecordController.getInstance().getTestSuiteLogRecord(reportEntity))) {
            return QTestLogEvaluation.CANNOT_INTEGRATE;
        }
        QTestRun qTestRun = QTestIntegrationTestSuiteManager.getTestRunByTestSuiteAndTestCaseId(qTestSuite, qTestCase.getId());
        if (qTestRun != null) {
            int index;
            QTestReport qTestReport;
            IntegratedEntity reportIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)reportEntity);
            try {
                qTestReport = QTestIntegrationReportManager.getQTestReportByIntegratedEntity(reportIntegratedEntity);
            }
            catch (Exception exception) {
                return QTestLogEvaluation.CANNOT_INTEGRATE;
            }
            if (qTestReport != null && (index = QTestIntegrationUtil.getTestCaseLogIndexByIndexInReport(testCaseLogRecord, reportEntity)) >= 0 && qTestReport.getTestLogMap().get(index) != null) {
                return QTestLogEvaluation.INTEGRATED;
            }
        }
        return QTestLogEvaluation.CAN_INTEGRATE;
    }

    private static boolean isSameQTestProject(TestCaseLogRecord testCaseLogRecord, TestSuiteLogRecord testSuiteLogRecord) {
        TestSuiteRepo testSuiteRepo;
        TestCaseRepo testCaseRepo;
        block5: {
            ProjectEntity projectEntity;
            block4: {
                try {
                    projectEntity = ProjectController.getInstance().getCurrentProject();
                    testCaseRepo = QTestIntegrationUtil.getTestCaseRepo((IntegratedFileEntity)TestCaseController.getInstance().getTestCaseByDisplayId(testCaseLogRecord.getId()), projectEntity);
                    if (testCaseRepo != null && testCaseRepo.getQTestProject() != null) break block4;
                    return false;
                }
                catch (Exception ex) {
                    LogUtil.logError((Throwable)ex);
                    return false;
                }
            }
            TestSuiteEntity testSuiteEntity = QTestIntegrationUtil.getTestSuiteEntity(testSuiteLogRecord);
            testSuiteRepo = QTestIntegrationUtil.getTestSuiteRepo((IntegratedFileEntity)testSuiteEntity, projectEntity);
            if (testSuiteRepo != null && testSuiteRepo.getQTestProject() != null) break block5;
            return false;
        }
        return testCaseRepo.getQTestProject().getId() == testSuiteRepo.getQTestProject().getId();
    }

    public static QTestTestCase getQTestCase(TestCaseLogRecord testCaseLogRecord) {
        try {
            TestCaseEntity testCaseEntity = TestCaseController.getInstance().getTestCaseByDisplayId(testCaseLogRecord.getId());
            if (testCaseEntity != null) {
                return QTestIntegrationTestCaseManager.getQTestTestCaseByIntegratedEntity(QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)testCaseEntity));
            }
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
        }
        return null;
    }

    public static int getTestCaseLogIndex(TestCaseLogRecord testCaseLogRecord, ReportEntity reportEntity) {
        TestSuiteLogRecord testSuiteLogRecord = LogRecordController.getInstance().getTestSuiteLogRecord(reportEntity);
        if (testCaseLogRecord == null || testSuiteLogRecord == null) {
            return -1;
        }
        return LogRecordHelper.getLogRecordIndex((ILogRecord)testCaseLogRecord);
    }

    public static int getTestCaseLogIndexByIndexInReport(TestCaseLogRecord testCaseLogRecord, ReportEntity reportEntity) {
        TestSuiteLogRecord testSuiteLogRecord = LogRecordController.getInstance().getTestSuiteLogRecord(reportEntity);
        if (testCaseLogRecord == null || testSuiteLogRecord == null) {
            return -1;
        }
        List rawLogRecord = LogRecordHelper.reduceRawLogRecords((TestSuiteLogRecord)testSuiteLogRecord, (ILogRecord[])testSuiteLogRecord.getChildRecords());
        int i = 0;
        while (i < rawLogRecord.size()) {
            if (testCaseLogRecord instanceof TestCaseGroupLogRecord && rawLogRecord.get(i) instanceof TestCaseGroupLogRecord) {
                TestCaseGroupLogRecord testCaseLogRecordGroupLog = (TestCaseGroupLogRecord)testCaseLogRecord;
                TestCaseGroupLogRecord rawLogRecordGroupLog = (TestCaseGroupLogRecord)rawLogRecord.get(i);
                if (rawLogRecordGroupLog.getIndexInReport() == testCaseLogRecordGroupLog.getIndexInReport()) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public static QTestSuite getSelectedQTestSuite(TestSuiteLogRecord testSuiteLogRecord) {
        TestSuiteEntity testSuiteEntity;
        block6: {
            block5: {
                if (testSuiteLogRecord != null) break block5;
                return null;
            }
            testSuiteEntity = QTestIntegrationUtil.getTestSuiteEntity(testSuiteLogRecord);
            if (testSuiteEntity != null) break block6;
            return null;
        }
        try {
            IntegratedEntity testSuiteIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)testSuiteEntity);
            if (testSuiteIntegratedEntity != null) {
                List<QTestSuite> qTestSuiteCollection = QTestIntegrationTestSuiteManager.getQTestSuiteListByIntegratedEntity(testSuiteIntegratedEntity);
                return QTestIntegrationTestSuiteManager.getSelectedQTestSuiteByIntegratedEntity(qTestSuiteCollection);
            }
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
        }
        return null;
    }

    public static ReportEntity saveReportEntity(QTestReport qTestReport, ReportEntity reportEntity) {
        try {
            IntegratedEntity reportIntegratedEntity = QTestIntegrationReportManager.getIntegratedEntityByQTestReport(qTestReport);
            reportEntity = (ReportEntity)QTestIntegrationUtil.updateFileIntegratedEntity((IntegratedFileEntity)reportEntity, reportIntegratedEntity);
            reportEntity = ReportController.getInstance().updateReport(reportEntity);
            return reportEntity;
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            return null;
        }
    }

    public static TestSuiteEntity getTestSuiteEntity(TestSuiteLogRecord testSuiteLogRecord) throws Exception {
        return TestSuiteController.getInstance().getTestSuiteByDisplayId(testSuiteLogRecord.getId(), ProjectController.getInstance().getCurrentProject());
    }

    public static QTestRun getQTestRun(QTestTestCase qTestCase, List<QTestRun> currentQTestRuns) {
        if (qTestCase == null || currentQTestRuns == null) {
            return null;
        }
        for (QTestRun currentQTestRun : currentQTestRuns) {
            if (qTestCase.getId() != currentQTestRun.getQTestCaseId()) continue;
            return currentQTestRun;
        }
        return null;
    }

    public static List<QTestRun> getCurrentQTestRuns(TestSuiteEntity testSuiteEntity, ProjectEntity projectEntity) throws Exception {
        IntegratedEntity testSuiteIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)testSuiteEntity);
        if (testSuiteIntegratedEntity != null) {
            List<QTestSuite> qTestSuiteCollection = QTestIntegrationTestSuiteManager.getQTestSuiteListByIntegratedEntity(testSuiteIntegratedEntity);
            QTestSuite selectedQTestSuite = QTestIntegrationTestSuiteManager.getSelectedQTestSuiteByIntegratedEntity(qTestSuiteCollection);
            if (selectedQTestSuite == null) {
                return Collections.emptyList();
            }
            QTestProject qTestProject = QTestIntegrationUtil.getTestSuiteRepo((IntegratedFileEntity)testSuiteEntity, projectEntity).getQTestProject();
            return QTestIntegrationTestSuiteManager.getTestRuns(selectedQTestSuite, qTestProject, QTestSettingCredential.getCredential(projectEntity.getFolderLocation()));
        }
        return Collections.emptyList();
    }

    public static boolean isFolderReportInTestSuiRepo(FolderEntity folderEntity, ProjectEntity projectEntity) {
        if (folderEntity.getFolderType() != FolderEntity.FolderType.REPORT) {
            return false;
        }
        String testSuiteId = ReportController.getInstance().getTestSuiteFolderId(folderEntity.getIdForDisplay());
        TestSuiteRepo testSuiteRepo = QTestIntegrationUtil.getTestSuiteRepo(testSuiteId, projectEntity);
        return testSuiteRepo != null;
    }

    public static boolean isTestSuiteIntegrated(TestSuiteEntity testSuiteEntity) throws QTestInvalidFormatException {
        IntegratedEntity testSuiteIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)testSuiteEntity);
        if (testSuiteIntegratedEntity == null) {
            return false;
        }
        List<QTestSuite> qTestSuiteCollection = QTestIntegrationTestSuiteManager.getQTestSuiteListByIntegratedEntity(testSuiteIntegratedEntity);
        if (qTestSuiteCollection == null || qTestSuiteCollection.isEmpty()) {
            return false;
        }
        return !qTestSuiteCollection.stream().filter(qTestSuite -> qTestSuite.getId() > 0L).collect(Collectors.toList()).isEmpty();
    }

    public static boolean isIntegrated(IntegratedFileEntity integratedFileEntity, ProjectEntity currentProject) throws Exception {
        boolean integrated;
        if (QTestIntegrationUtil.getTestSuiteRepo(integratedFileEntity, currentProject) != null && integratedFileEntity instanceof FolderEntity && QTestIntegrationUtil.getIntegratedEntity(integratedFileEntity) != null) {
            return true;
        }
        if (!(QTestIntegrationUtil.getTestCaseRepo(integratedFileEntity, currentProject) != null || QTestIntegrationUtil.getTestSuiteRepo(integratedFileEntity, currentProject) != null && integratedFileEntity instanceof TestSuiteEntity)) {
            return false;
        }
        boolean bl = integrated = QTestIntegrationUtil.getIntegratedEntity(integratedFileEntity) != null;
        if (integrated && integratedFileEntity instanceof TestSuiteEntity) {
            integrated = QTestIntegrationUtil.isTestSuiteIntegrated((TestSuiteEntity)integratedFileEntity);
        }
        return integrated;
    }

    public static String getListTestStepDescription(QTestTestCase qTestTestCase) {
        ArrayList<String> descriptions = new ArrayList<String>();
        for (QTestStep testStep : qTestTestCase.getSteps()) {
            String stepDescription = QTestIntegrationUtil.getTestStepDescription(testStep);
            descriptions.add(stepDescription);
        }
        return StringUtils.join(descriptions, (char)'\n');
    }

    public static String getTestStepDescription(QTestStep qTestStep) {
        return String.format("Step %d: [Step Description: %s, Expected Result: %s]", qTestStep.getOrder(), QTestIntegrationUtil.getHtmlInnerText(qTestStep.getDescription()), QTestIntegrationUtil.getHtmlInnerText(qTestStep.getExpectedResult()));
    }

    public static String getHtmlInnerText(String html) {
        Document doc = Jsoup.parse((String)html);
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        doc.outputSettings(outputSettings);
        doc.select("br").before("\\n");
        doc.select("p").before("\\n");
        String str = doc.html().replaceAll("\\\\n", "");
        str = Jsoup.clean((String)str, (String)"", (Whitelist)Whitelist.none(), (Document.OutputSettings)outputSettings);
        return str;
    }

    public static boolean isUnderTestCaseRoot(IntegratedFileEntity integratedFileEntity) {
        try {
            ProjectEntity project = ProjectController.getInstance().getCurrentProject();
            FolderEntity testCaseRoot = FolderController.getInstance().getTestCaseRoot(project);
            return integratedFileEntity.getIdForDisplay().startsWith(testCaseRoot.getName());
        }
        catch (ControllerException e) {
            ExceptionUtil.throwUnchecked((Exception)((Object)e));
            return false;
        }
    }
}

