/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest.setting;

public enum QTestVersion {
    V6("6"),
    V7("7");

    private final String text;

    private QTestVersion(String text) {
        this.text = text;
    }

    public String toString() {
        return this.text;
    }

    public int getVersionNumber() {
        return Integer.parseInt(this.toString());
    }

    public boolean higherThan(QTestVersion that) {
        return this.getVersionNumber() > that.getVersionNumber();
    }

    public static QTestVersion getLastest() {
        int lastest = 0;
        QTestVersion lastestVersion = null;
        QTestVersion[] qTestVersionArray = QTestVersion.values();
        int n = qTestVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            QTestVersion version = qTestVersionArray[n2];
            if (lastest < version.getVersionNumber()) {
                lastest = version.getVersionNumber();
                lastestVersion = version;
            }
            ++n2;
        }
        return lastestVersion;
    }

    public static String[] valuesAsStrings() {
        QTestVersion[] arrayOfValues = QTestVersion.values();
        String[] arrayOfNames = new String[arrayOfValues.length];
        int index = 0;
        while (index < arrayOfValues.length) {
            StringBuilder displayedValue = new StringBuilder(arrayOfValues[index].toString());
            if (arrayOfValues[index] == QTestVersion.getLastest()) {
                displayedValue.append(" or higher");
            }
            arrayOfNames[index] = displayedValue.toString();
            ++index;
        }
        return arrayOfNames;
    }

    public static QTestVersion valueOf(String string) {
        return Enum.valueOf(QTestVersion.class, string);
    }
}

