/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.CompressionLevel;
import net.lingala.zip4j.model.enums.CompressionMethod;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class ZipUtil {
    public static void extract(File file, File destFolder) throws IOException {
        try (java.util.zip.ZipFile zipFile = new java.util.zip.ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File entryDestination = new File(destFolder, FilenameUtils.separatorsToSystem((String)entry.getName()));
                if (entry.isDirectory()) {
                    entryDestination.mkdirs();
                    continue;
                }
                entryDestination.getParentFile().mkdirs();
                InputStream in = zipFile.getInputStream(entry);
                FileOutputStream out = new FileOutputStream(entryDestination);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                IOUtils.closeQuietly((InputStream)in);
                ((OutputStream)out).close();
            }
        }
    }

    public static void extractContent(File file, File destFolder, int startFragment) throws IOException {
        try (java.util.zip.ZipFile zipFile = new java.util.zip.ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (startFragment > 0) {
                    int startOffset = StringUtils.ordinalIndexOf((String)entryName, (String)"/", (int)startFragment);
                    if (startOffset < 0) continue;
                    entryName = entryName.substring(startOffset + 1, entryName.length());
                }
                File entryDestination = new File(destFolder, entryName);
                if (entry.isDirectory()) {
                    entryDestination.mkdirs();
                    continue;
                }
                entryDestination.getParentFile().mkdirs();
                InputStream in = zipFile.getInputStream(entry);
                FileOutputStream out = new FileOutputStream(entryDestination);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                IOUtils.closeQuietly((InputStream)in);
                ((OutputStream)out).close();
            }
        }
    }

    /*
     * Loose catch block
     */
    public static Path compress(List<Path> files, Path zipfile) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            Path path;
            ZipOutputStream zipOutputStream;
            OutputStream zipFileOutputStream;
            block17: {
                block16: {
                    zipFileOutputStream = Files.newOutputStream(zipfile, new OpenOption[0]);
                    zipOutputStream = new ZipOutputStream(zipFileOutputStream);
                    for (Path file : files) {
                        InputStream fileInputStream = Files.newInputStream(file, new OpenOption[0]);
                        ZipEntry zipEntry = new ZipEntry(file.toFile().getName());
                        zipOutputStream.putNextEntry(zipEntry);
                        IOUtils.copy((InputStream)fileInputStream, (OutputStream)zipOutputStream);
                        IOUtils.closeQuietly((InputStream)fileInputStream);
                    }
                    path = zipfile;
                    if (zipOutputStream == null) break block16;
                    zipOutputStream.close();
                }
                if (zipFileOutputStream == null) break block17;
                zipFileOutputStream.close();
            }
            return path;
            {
                catch (Throwable throwable2) {
                    try {
                        if (zipOutputStream != null) {
                            zipOutputStream.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (zipFileOutputStream != null) {
                            zipFileOutputStream.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static ZipOutputStream createZip(Path filePath) throws IOException {
        return new ZipOutputStream(Files.newOutputStream(filePath, new OpenOption[0]));
    }

    public static void appendFile(ZipOutputStream zip, Path file) throws IOException {
        InputStream fileInputStream = Files.newInputStream(file, new OpenOption[0]);
        ZipEntry zipEntry = new ZipEntry(file.toFile().getName());
        zip.putNextEntry(zipEntry);
        IOUtils.copy((InputStream)fileInputStream, (OutputStream)zip);
        IOUtils.closeQuietly((InputStream)fileInputStream);
    }

    public static void closeZip(ZipOutputStream zip) {
        if (zip == null) {
            return;
        }
        IOUtils.closeQuietly((OutputStream)zip);
    }

    public static ZipFile compressFolder(File outputFile, File inputFolder) throws FileCompressionException, IOException {
        if (outputFile.exists()) {
            outputFile.delete();
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ZipFile returnedZipFile = new ZipFile(outputFile);){
                ZipParameters parameters = new ZipParameters();
                parameters.setCompressionMethod(CompressionMethod.DEFLATE);
                parameters.setCompressionLevel(CompressionLevel.NORMAL);
                returnedZipFile.addFolder(inputFolder, parameters);
                return returnedZipFile;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ZipException e) {
            throw new FileCompressionException("Cannot zip folder: " + inputFolder.getAbsolutePath(), e);
        }
    }

    public static void extractAll(File file, File destinationFolder) throws FileCompressionException, IOException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ZipFile zipFile = new ZipFile(file.getAbsolutePath());){
                zipFile.extractAll(destinationFolder.getAbsolutePath());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ZipException e) {
            throw new FileCompressionException("Cannot extract file: " + file.getAbsolutePath(), e);
        }
    }

    public static final class FileCompressionException
    extends Exception {
        private static final long serialVersionUID = -6494232220859297938L;

        public FileCompressionException(Throwable cause) {
            super(cause);
        }

        public FileCompressionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

