/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.module;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.Command;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.json.JsonInput;

public class Browser {
    private final BiDi bidi;
    private final Function<JsonInput, String> userContextInfoMapper = jsonInput -> {
        Map response = (Map)jsonInput.read(Map.class);
        return (String)response.get("userContext");
    };
    private final Function<JsonInput, List<String>> userContextsInfoMapper = jsonInput -> {
        Map response = (Map)jsonInput.read(Map.class);
        List userContextsResponse = (List)response.get("userContexts");
        ArrayList userContexts = new ArrayList();
        userContextsResponse.forEach(map -> {
            String userContext = (String)map.get("userContext");
            userContexts.add(userContext);
        });
        return userContexts;
    };

    public Browser(WebDriver driver) {
        this.bidi = ((HasBiDi)driver).getBiDi();
    }

    public String createUserContext() {
        return this.bidi.send(new Command<String>("browser.createUserContext", Map.of(), this.userContextInfoMapper));
    }

    public List<String> getUserContexts() {
        return this.bidi.send(new Command<List<String>>("browser.getUserContexts", Map.of(), this.userContextsInfoMapper));
    }

    public void removeUserContext(String userContext) {
        this.bidi.send(new Command("browser.removeUserContext", Map.of("userContext", userContext)));
    }
}

