/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.devtools.CdpEndpointFinder;
import org.openqa.selenium.devtools.Connection;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpClient;

public class SeleniumCdpConnection
extends Connection {
    private static final Logger LOG = Logger.getLogger(SeleniumCdpConnection.class.getName());

    private SeleniumCdpConnection(HttpClient client, String url) {
        super(client, url);
    }

    public static Optional<Connection> create(WebDriver driver) {
        if (!(driver instanceof HasCapabilities)) {
            throw new IllegalStateException("Given webdriver instance must have capabilities");
        }
        return SeleniumCdpConnection.create(((HasCapabilities)driver).getCapabilities());
    }

    public static Optional<Connection> create(Capabilities capabilities) {
        Require.nonNull((String)"Capabilities", (Object)capabilities);
        return SeleniumCdpConnection.create(HttpClient.Factory.createDefault(), capabilities);
    }

    public static Optional<Connection> create(HttpClient.Factory clientFactory, Capabilities capabilities) {
        Optional<HttpClient> client;
        Require.nonNull((String)"HTTP client factory", (Object)clientFactory);
        Require.nonNull((String)"Capabilities", (Object)capabilities);
        Optional<Connection> cdpUri = Optional.ofNullable(capabilities.getCapability("se:cdp")).flatMap(uri -> {
            if (uri instanceof String) {
                try {
                    return Optional.of(new URI((String)uri));
                }
                catch (URISyntaxException e) {
                    return Optional.empty();
                }
            }
            return Optional.empty();
        });
        if (cdpUri.isPresent()) {
            client = Optional.of(CdpEndpointFinder.getHttpClient(clientFactory, (URI)cdpUri.get()));
        } else {
            Optional<URI> reportedUri = CdpEndpointFinder.getReportedUri(capabilities);
            client = reportedUri.map(uri -> CdpEndpointFinder.getHttpClient(clientFactory, uri));
            try {
                cdpUri = client.flatMap(CdpEndpointFinder::getCdpEndPoint);
            }
            catch (Exception e) {
                try {
                    client.ifPresent(HttpClient::close);
                }
                catch (Exception ex) {
                    e.addSuppressed(ex);
                }
                throw e;
            }
            if (cdpUri.isEmpty()) {
                try {
                    client.ifPresent(HttpClient::close);
                }
                catch (Exception e) {
                    LOG.log(Level.FINE, "failed to close the http client used to check the reported CDP endpoint: " + String.valueOf(reportedUri.get()), e);
                }
            }
        }
        return cdpUri.map(uri -> new SeleniumCdpConnection((HttpClient)client.get(), uri.toString()));
    }
}

