/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.dialog;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.control.TreeEntitySelectionComposite;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.EntityLabelProvider;
import com.kms.katalon.composer.components.impl.providers.EntityProvider;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.explorer.providers.FolderEntityTreeViewerFilter;
import com.kms.katalon.composer.folder.handlers.NewFolderHandler;
import com.kms.katalon.composer.mobile.objectspy.constant.ComposerMobileObjectspyMessageConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AddElementToObjectRepositoryDialog
extends AbstractDialog {
    private static final int NEW_FOLDER_ID = 1025;
    private TreeEntitySelectionComposite treeComposite;
    private FolderTreeEntity selectedFolderTreeEntity;

    public AddElementToObjectRepositoryDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void registerControlModifyListeners() {
        final TreeViewer treeViewer = this.treeComposite.getTreeViewer();
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null || selection.isEmpty() || selection.size() != 1) {
                    AddElementToObjectRepositoryDialog.this.getButton(0).setEnabled(false);
                    AddElementToObjectRepositoryDialog.this.getButton(1025).setEnabled(false);
                    return;
                }
                AddElementToObjectRepositoryDialog.this.getButton(0).setEnabled(true);
                AddElementToObjectRepositoryDialog.this.getButton(1025).setEnabled(true);
                AddElementToObjectRepositoryDialog.this.selectedFolderTreeEntity = (FolderTreeEntity)selection.getFirstElement();
            }
        });
        this.getButton(1025).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)treeViewer.getSelection();
                try {
                    FolderTreeEntity newFolderTreeEntity = new NewFolderHandler().createNewFolderEntity(AddElementToObjectRepositoryDialog.this.getShell(), selection.toArray(), EventBrokerSingleton.getInstance().getEventBroker());
                    if (newFolderTreeEntity == null) {
                        return;
                    }
                    AddElementToObjectRepositoryDialog.this.updateTreeEntityInput();
                    treeViewer.setSelection((ISelection)new StructuredSelection((Object)newFolderTreeEntity));
                    treeViewer.getControl().setFocus();
                }
                catch (Exception ex) {
                    LoggerSingleton.logError((Throwable)ex);
                }
            }
        });
    }

    protected void setInput() {
        this.getButton(0).setEnabled(false);
        this.getButton(1025).setEnabled(false);
        this.updateTreeEntityInput();
    }

    private void updateTreeEntityInput() {
        this.treeComposite.setInput(this.getTreeInput());
        this.treeComposite.getTreeViewer().expandToLevel(2);
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        EntityProvider contentProvider = new EntityProvider();
        container.setLayout((Layout)new FillLayout(256));
        this.treeComposite = new TreeEntitySelectionComposite(container, 2048, (ITreeContentProvider)contentProvider, (AbstractEntityViewerFilter)new FolderEntityTreeViewerFilter(contentProvider), (IEntityLabelProvider)new EntityLabelProvider());
        return container;
    }

    protected Point getInitialSize() {
        return new Point(super.getInitialSize().x, 400);
    }

    private Object[] getTreeInput() {
        try {
            return new Object[]{new FolderTreeEntity(FolderController.getInstance().getObjectRepositoryRoot(ProjectController.getInstance().getCurrentProject()), null)};
        }
        catch (Exception veryImportantException) {
            LoggerSingleton.logError((Throwable)veryImportantException);
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, ComposerMobileObjectspyMessageConstants.DIA_BTN_NEW_FOLDER, true);
        super.createButtonsForButtonBar(parent);
    }

    public FolderTreeEntity getSelectedFolderTreeEntity() {
        return this.selectedFolderTreeEntity;
    }

    public String getDialogTitle() {
        return ComposerMobileObjectspyMessageConstants.DIA_TITLE_FOLDER_BROWSER;
    }
}

