/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.dialog;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.mobile.execution.handler.IosInstallDependenciesHandler;
import com.kms.katalon.composer.mobile.execution.handler.IosInstallWebDriverAgent;
import com.kms.katalon.composer.mobile.objectspy.constant.ComposerMobileObjectspyMessageConstants;
import com.kms.katalon.composer.mobile.objectspy.util.IOSIssueDetective;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ErrorStartMobileApplicationHaveTroubleshootDialog
extends MultiStatusErrorDialog {
    private Shell parentShell;
    private Button btnTroubleshoot;
    private IOSIssueDetective.StartIOSErrorType errorType;
    private boolean runWithIOSDevice;

    public ErrorStartMobileApplicationHaveTroubleshootDialog(Shell parentShell, String errorMessage, String errorReason, String detailsMessage, boolean runWithIOSDevice) {
        super(parentShell, errorMessage, errorReason, detailsMessage);
        this.parentShell = parentShell;
        this.errorType = IOSIssueDetective.detectIssueFromMessage(errorReason);
        this.runWithIOSDevice = runWithIOSDevice;
    }

    public ErrorStartMobileApplicationHaveTroubleshootDialog(String errorMessage, String errorReason, String detailsMessage, boolean runWithIOSDevice) {
        this(Display.getCurrent().getActiveShell(), errorMessage, errorReason, detailsMessage, runWithIOSDevice);
    }

    private boolean shoudTroubleshootDisplay() {
        return this.runWithIOSDevice && this.errorType != IOSIssueDetective.StartIOSErrorType.UNDEFINED;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (this.shoudTroubleshootDisplay()) {
            this.btnTroubleshoot = this.createButton(parent, 22, ComposerMobileObjectspyMessageConstants.BTN_TROUBLESHOOT, false);
        }
    }

    protected void registerControlModifyListeners() {
        super.registerControlModifyListeners();
        if (!this.shoudTroubleshootDisplay()) {
            return;
        }
        this.btnTroubleshoot.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ErrorStartMobileApplicationHaveTroubleshootDialog.this.openTroubleshootDialog();
            }
        });
    }

    private void openTroubleshootDialog() {
        String errorMessage = "";
        switch (this.errorType) {
            case DEPENDENCIES: {
                errorMessage = ComposerMobileObjectspyMessageConstants.DIA_ERROR_MSG_DEPENDENCIES_ERROR_WHEN_STARTING;
                break;
            }
            case WEB_DRIVER_AGENT: {
                errorMessage = ComposerMobileObjectspyMessageConstants.DIA_ERROR_MSG_WEBDRIVERAGENT_ERROR_WHEN_STARTING;
                break;
            }
        }
        if (errorMessage.isEmpty()) {
            return;
        }
        MessageDialog dialog = new MessageDialog(this.parentShell, ComposerMobileObjectspyMessageConstants.DIA_TILTE_INSTALLATION_INSTRUCTION, null, errorMessage, 2, new String[]{DialogButton.OK.getText(), DialogButton.CANCEL.getText()}, 0);
        this.close();
        DialogButton result = DialogButton.indexOf(dialog.open());
        block4 : switch (result) {
            case OK: {
                switch (this.errorType) {
                    case DEPENDENCIES: {
                        IosInstallDependenciesHandler dependenciesInstaller = new IosInstallDependenciesHandler();
                        if (!dependenciesInstaller.canExecute()) break block4;
                        dependenciesInstaller.execute(this.parentShell);
                        break block4;
                    }
                    case WEB_DRIVER_AGENT: {
                        IosInstallWebDriverAgent webDriverAgentInstaller = new IosInstallWebDriverAgent();
                        if (!webDriverAgentInstaller.canExecute()) break block4;
                        webDriverAgentInstaller.execute(this.parentShell);
                        break block4;
                    }
                }
                break;
            }
            case CANCEL: {
                this.open();
                break;
            }
        }
    }

    private static enum DialogButton {
        OK(0, "OK"),
        CANCEL(1, "Cancel"),
        UNDEFINED(2, null);

        private int index;
        private String text;

        private DialogButton(int index, String text) {
            this.index = index;
            this.text = text;
        }

        private int getIndex() {
            return this.index;
        }

        private String getText() {
            return this.text;
        }

        public static DialogButton indexOf(int index) {
            DialogButton[] dialogButtonArray = DialogButton.values();
            int n = dialogButtonArray.length;
            int n2 = 0;
            while (n2 < n) {
                DialogButton option = dialogButtonArray[n2];
                if (option.getIndex() == index) {
                    return option;
                }
                ++n2;
            }
            return UNDEFINED;
        }
    }
}

