/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.element.impl;

import com.kms.katalon.composer.mobile.objectspy.element.SnapshotMobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.TreeMobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.impl.BasicMobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.impl.CapturedMobileElement;
import com.kms.katalon.composer.mobile.objectspy.util.MobileElementHelper;
import com.kms.katalon.controller.EntityController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.enums.mobile.LocatorStrategy;
import com.kms.katalon.core.enums.mobile.MobilePlatform;
import com.kms.katalon.core.mobile.keyword.internal.MobileLocatorFinder;
import com.kms.katalon.core.testobject.MobileTestObject;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.execution.setting.MobileSettingStore;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public abstract class RenderedTreeSnapshotMobileElement<T>
extends BasicMobileElement
implements SnapshotMobileElement<T> {
    private static final long serialVersionUID = -6452866868131771671L;
    private final RenderedTreeSnapshotMobileElement<T> parentElement;
    private List<RenderedTreeSnapshotMobileElement<T>> childrenElement;
    private CapturedMobileElement capturedElement;
    private String locator = "";
    private LocatorStrategy locatorStrategy = LocatorStrategy.XPATH;

    protected RenderedTreeSnapshotMobileElement() {
        this(null);
    }

    protected RenderedTreeSnapshotMobileElement(RenderedTreeSnapshotMobileElement<T> parentElement) {
        this.parentElement = parentElement;
    }

    @Override
    public RenderedTreeSnapshotMobileElement<T> getParentElement() {
        return this.parentElement;
    }

    protected String makeXpath() {
        Object xpath;
        String tagName = this.getTagName();
        int index = this.getIndexPropertyForElement(tagName);
        Object object = xpath = StringUtils.isEmpty((String)tagName) ? "//*" : "/" + tagName;
        if (index > 0) {
            xpath = (String)xpath + "[" + index + "]";
        }
        if (this.parentElement == null) {
            return "/" + (String)xpath;
        }
        String parentXpath = this.parentElement.getXpath();
        xpath = (StringUtils.isEmpty((String)parentXpath) ? "//*" : parentXpath) + (String)xpath;
        return xpath;
    }

    private int getIndexPropertyForElement(String tagName) {
        if (StringUtils.isEmpty((String)tagName) || this.parentElement == null) {
            return 0;
        }
        int index = 1;
        for (RenderedTreeSnapshotMobileElement<T> sibling : this.parentElement.getChildrenElement()) {
            if (sibling == this || !tagName.equals(sibling.getTagName())) continue;
            ++index;
        }
        return index;
    }

    public List<RenderedTreeSnapshotMobileElement<T>> getChildrenElement() {
        if (this.childrenElement == null) {
            this.childrenElement = new ArrayList<RenderedTreeSnapshotMobileElement<T>>();
        }
        return this.childrenElement;
    }

    public void setChildrenElement(List<RenderedTreeSnapshotMobileElement<T>> childrenElement) {
        this.childrenElement = childrenElement;
    }

    @Override
    public CapturedMobileElement getCapturedElement() {
        return this.capturedElement;
    }

    @Override
    public void setCapturedElement(CapturedMobileElement capturedElement) {
        this.capturedElement = capturedElement;
    }

    @Override
    public CapturedMobileElement newCapturedElement(AppiumDriver appiumDriver, Map<Integer, CapturedMobileElement> hashCapturedElements) {
        MobileElementHelper helper = new MobileElementHelper();
        int thisTreeElementHash = helper.calculateHashValue(this);
        CapturedMobileElement capturedElement = hashCapturedElements.get(thisTreeElementHash);
        if (capturedElement == null) {
            capturedElement = new CapturedMobileElement(this, true);
            capturedElement.setName(EntityController.toValidFileName((String)this.getName()));
            capturedElement.setAttributes(this.getAttributes());
            MobilePlatform mobilePlatform = capturedElement.getPlatform();
            if (Objects.isNull(mobilePlatform)) {
                if (appiumDriver instanceof AndroidDriver) {
                    capturedElement.setPlatform(MobilePlatform.ANDROID);
                } else if (appiumDriver instanceof IOSDriver) {
                    capturedElement.setPlatform(MobilePlatform.IOS);
                }
            }
            MobileTestObject mobileTestObject = capturedElement.toMobileTestObject();
            Map<LocatorStrategy, String> locatorCollection = capturedElement.getLocatorCollection();
            LocatorStrategy[] locatorStrategyArray = LocatorStrategy.values();
            int n = locatorStrategyArray.length;
            int n2 = 0;
            while (n2 < n) {
                LocatorStrategy locatorStrategy = locatorStrategyArray[n2];
                String locator = locatorCollection.get(locatorStrategy);
                if (StringUtils.isBlank((String)locator)) {
                    locator = MobileLocatorFinder.findLocator((TestObject)mobileTestObject, (LocatorStrategy)locatorStrategy);
                    locatorCollection.put(locatorStrategy, locator);
                }
                ++n2;
            }
            MobileSettingStore mobileSettingStore = new MobileSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation());
            LocatorStrategy locatorStrategy = mobileSettingStore.getDefaultLocatorStrategy();
            List locatorStrategies = LocatorStrategy.getLocatorStrategies((MobilePlatform)capturedElement.getPlatform());
            List locatorStrategyList = locatorStrategies.stream().map(LocatorStrategy::getName).collect(Collectors.toList());
            int locatorStrategyIndex = locatorStrategyList.indexOf(locatorStrategy.toString());
            if (locatorStrategyIndex == -1) {
                locatorStrategy = MobileSettingStore.DEFAULT_LOCATOR;
            }
            capturedElement.setLocatorStrategy(locatorStrategy);
            String locator = locatorCollection.get(locatorStrategy);
            capturedElement.setLocator(locator);
            this.setCapturedElement(capturedElement);
        }
        return capturedElement;
    }

    protected void buildLocator(AppiumDriver appiumDriver) {
    }

    @Override
    public TreeMobileElement findBestMatch(CapturedMobileElement needToVerify) {
        if (needToVerify == null) {
            return null;
        }
        if (this.containsAllAttributes(needToVerify.getAttributes())) {
            return this;
        }
        for (TreeMobileElement treeMobileElement : this.getChildrenElement()) {
            TreeMobileElement found = treeMobileElement.findBestMatch(needToVerify);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private boolean containsAllAttributes(Map<String, String> attributesToVerify) {
        if (attributesToVerify == null || attributesToVerify.isEmpty()) {
            return false;
        }
        Map<String, String> attributes = this.getAttributes();
        for (Map.Entry<String, String> entryToVerify : attributesToVerify.entrySet()) {
            String key = entryToVerify.getKey();
            if (attributes.containsKey(key) && ObjectUtils.equals((Object)attributes.get(key), (Object)entryToVerify.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getLocator() {
        return this.locator;
    }

    public void setLocator(String locator) {
        this.locator = locator;
    }

    @Override
    public LocatorStrategy getLocatorStrategy() {
        return this.locatorStrategy;
    }

    public void setLocatorStrategy(LocatorStrategy locatorStrategy) {
        this.locatorStrategy = locatorStrategy;
    }
}

