/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.util;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArgumentListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.helper.KeywordHelper;
import com.kms.katalon.core.keyword.internal.KeywordMain;
import com.kms.katalon.core.mobile.constants.StringConstants;
import com.kms.katalon.core.mobile.helper.MobileCommonHelper;
import com.kms.katalon.core.mobile.keyword.builtin.SetTextKeyword;
import com.kms.katalon.core.mobile.keyword.internal.MobileDriverFactory;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.core.testobject.TestObject;
import io.appium.java_client.AppiumBy;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.android.nativekey.AndroidKey;
import io.appium.java_client.android.nativekey.KeyEvent;
import io.appium.java_client.ios.IOSDriver;
import io.appium.java_client.remote.SupportsContextSwitching;
import io.appium.java_client.remote.SupportsRotation;
import java.io.File;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Keys;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.ScreenOrientation;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;

public class MobileActionHelper {
    private static final int timeout = 10;
    private static final FailureHandling flowControl = FailureHandling.STOP_ON_FAILURE;
    private AppiumDriver driver;

    public MobileActionHelper(AppiumDriver driver) {
        this.driver = driver;
    }

    public WebElement findElement(TestObject to, int timeout) throws Exception {
        List<WebElement> elements = this.findElements(to, timeout);
        if (elements != null && elements.size() > 0) {
            return elements.get(0);
        }
        return null;
    }

    public List<WebElement> findElements(TestObject testObject, int timeout) throws Exception {
        if (testObject == null) {
            throw new IllegalArgumentException("Test object cannot be null");
        }
        return MobileCommonHelper.findElements((AppiumDriver)this.driver, (TestObject)testObject, (int)timeout);
    }

    public void tap(TestObject to) throws Exception {
        KeywordHelper.checkTestObjectParameter((TestObject)to);
        WebElement element = this.findElement(to, 10);
        if (element == null) {
            KeywordMain.stepFailed((String)MessageFormat.format(StringConstants.KW_MSG_OBJ_NOT_FOUND, to.getObjectId()), (FailureHandling)flowControl, null);
            return;
        }
        element.click();
    }

    public void tapAndHold(TestObject to) throws Exception {
        WebElement element = this.findElement(to, 10);
        Point location = element.getLocation();
        Dimension size = element.getSize();
        Point tapPoint = new Point(location.x + size.width / 2, location.y + size.height / 2);
        MobileCommonHelper.touchAndHold((AppiumDriver)MobileDriverFactory.getDriver(), (Point)tapPoint, (Duration)Duration.ofMillis(2000L));
    }

    public void swipe(int startX, int startY, int endX, int endY) throws Exception {
        try {
            MobileCommonHelper.swipe((AppiumDriver)this.driver, (Point)new Point(startX, startY), (Point)new Point(endX, endY));
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e, (String)"Exception while swipe | startX = %s | startY = %s | endX = %s | endY = %s".formatted(startX, startY, endX, endY));
            throw e;
        }
    }

    public String getText(TestObject to) throws Exception {
        KeywordHelper.checkTestObjectParameter((TestObject)to);
        WebElement element = this.findElement(to, 10);
        if (element == null) {
            KeywordMain.stepFailed((String)MessageFormat.format(StringConstants.KW_MSG_OBJ_NOT_FOUND, to.getObjectId()), (FailureHandling)flowControl, null);
            return null;
        }
        return element.getText();
    }

    public void setText(TestObject to, String text) throws Exception {
        KeywordHelper.checkTestObjectParameter((TestObject)to);
        WebElement element = this.findElement(to, 10);
        if (element == null) {
            KeywordMain.stepFailed((String)MessageFormat.format(StringConstants.KW_MSG_OBJ_NOT_FOUND, to.getObjectId()), (FailureHandling)flowControl, null);
            return;
        }
        element.clear();
        new SetTextKeyword().sendKeys(element, text);
    }

    /*
     * Unable to fully structure code
     */
    public void hideKeyboard() {
        block12: {
            try {
                try {
                    this.driver.executeScript("mobile: hideKeyboard", new Object[0]);
                    break block12;
                }
                catch (WebDriverException v0) {
                    if (!(this.driver instanceof IOSDriver)) break block12;
                    var5_3 = keys = new String[]{"Done", "Return"};
                    var4_4 = keys.length;
                    var3_5 = 0;
                    ** while (var3_5 < var4_4)
                }
lbl-1000:
                // 1 sources

                {
                    key = var5_3[var3_5];
                    try {
                        LoggerSingleton.logInfo((String)("HideKeyboard by pressKey: " + key));
                        params = new HashMap<String, String>();
                        params.put("strategy", "pressKey");
                        params.put("key", key);
                        this.driver.executeScript("mobile: hideKeyboard", new Object[]{params});
                        break block12;
                    }
                    catch (WebDriverException v1) {
                        classChain = MessageFormat.format("**/XCUIElementTypeButton[`label == ''{0}''`]", new Object[]{key});
                        button = this.driver.findElement(AppiumBy.iOSClassChain((String)classChain));
                        if (button != null) {
                            try {
                                button.click();
                                break block12;
                            }
                            catch (WebDriverException v2) {}
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException v3) {}
                        ++var3_5;
                    }
                    continue;
lbl37:
                    // 1 sources

                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e, (String)"Exception while hideKeyboard");
                throw e;
            }
        }
    }

    public void clearText(TestObject to) throws Exception {
        KeywordHelper.checkTestObjectParameter((TestObject)to);
        WebElement element = this.findElement(to, 10);
        if (element == null) {
            KeywordMain.stepFailed((String)MessageFormat.format(StringConstants.KW_MSG_OBJ_NOT_FOUND, to.getObjectId()), (FailureHandling)flowControl, null);
            return;
        }
        element.clear();
    }

    public void scrollToText(String text) {
        List elements;
        if (this.driver instanceof AndroidDriver) {
            String uiSelector = String.format("new UiSelector().textContains(\"%s\")", text);
            String uiScrollable = String.format("new UiScrollable(new UiSelector().scrollable(true).instance(0)).scrollIntoView(%s)", uiSelector);
            ((AndroidDriver)this.driver).findElement(AppiumBy.androidUIAutomator((String)uiScrollable));
        } else if (this.driver instanceof IOSDriver && (elements = ((IOSDriver)this.driver).findElements(AppiumBy.xpath((String)("//*[contains(@label, '" + text + "') or contains(@text, '" + text + "')]")))) != null && !elements.isEmpty()) {
            RemoteWebElement remoteElement = (RemoteWebElement)elements.get(elements.size() - 1);
            String elementId = remoteElement.getId();
            HashMap<String, String> scrollObject = new HashMap<String, String>();
            scrollObject.put("elementId", elementId);
            this.driver.executeScript("mobile:scrollToElement", new Object[]{scrollObject});
        }
    }

    private boolean internalSwitchToNativeContext(AppiumDriver driver) {
        return this.internalSwitchToContext(driver, "NATIVE");
    }

    private boolean internalSwitchToWebViewContext(AppiumDriver driver) {
        return this.internalSwitchToContext(driver, "WEBVIEW");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean internalSwitchToContext(AppiumDriver driver, String contextName) {
        try {
            String context;
            Iterator iterator = ((SupportsContextSwitching)driver).getContextHandles().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(context = (String)iterator.next()).contains(contextName));
            ((SupportsContextSwitching)driver).context(context);
            return true;
        }
        catch (WebDriverException webDriverException) {}
        return false;
    }

    public void pressBack() throws Exception {
        if (this.driver instanceof AndroidDriver) {
            ((AndroidDriver)this.driver).pressKey(new KeyEvent(AndroidKey.BACK));
        } else {
            KeywordMain.stepFailed((String)StringConstants.KW_MSG_UNSUPPORT_ACT_FOR_THIS_DEVICE, (FailureHandling)flowControl, null);
        }
    }

    public void switchToLandscape() throws Exception {
        ((SupportsRotation)this.driver).rotate(ScreenOrientation.LANDSCAPE);
    }

    public void switchToPortrait() throws Exception {
        ((SupportsRotation)this.driver).rotate(ScreenOrientation.PORTRAIT);
    }

    public void switchToWebView() throws Exception {
        boolean result = this.internalSwitchToWebViewContext(this.driver);
        if (result) {
            RunConfiguration.storeDriver((Object)this.driver);
        } else {
            KeywordMain.stepFailed((String)StringConstants.KW_LOG_FAILED_SWITCH_WEB_VIEW, (FailureHandling)flowControl, null);
        }
    }

    public void switchToNative() throws Exception {
        boolean result = this.internalSwitchToNativeContext(this.driver);
        if (result) {
            RunConfiguration.storeDriver((Object)this.driver);
        } else {
            KeywordMain.stepFailed((String)StringConstants.KW_LOG_FAILED_SWITCH_NATIVE, (FailureHandling)flowControl, null);
        }
    }

    public File takeScreenshot() throws Exception {
        File tempFile;
        block3: {
            tempFile = (File)this.driver.getScreenshotAs(OutputType.FILE);
            if (tempFile.exists()) break block3;
            KeywordMain.stepFailed((String)StringConstants.KW_MSG_UNABLE_TO_TAKE_SCREENSHOT, (FailureHandling)flowControl, null);
            return null;
        }
        return tempFile;
    }

    public String getKeys(ArgumentListExpressionWrapper arguments) {
        Object keys = new String();
        boolean isSpecialKey = false;
        for (ExpressionWrapper expr : arguments.getExpressions()) {
            List children = expr.getAstChildren();
            boolean bl = isSpecialKey = children.size() > 0;
            if (isSpecialKey) {
                keys = (String)keys + children.stream().map(child -> {
                    if (child instanceof ConstantExpressionWrapper) {
                        String keyName = ((ConstantExpressionWrapper)child).getValue().toString();
                        return Keys.valueOf((String)keyName).toString();
                    }
                    return "";
                }).collect(Collectors.joining());
                continue;
            }
            children = expr.getParent().getAstChildren();
            keys = (String)keys + children.stream().map(child -> {
                if (child instanceof ConstantExpressionWrapper) {
                    return ((ConstantExpressionWrapper)child).getValue().toString();
                }
                return "";
            }).collect(Collectors.joining());
        }
        return keys;
    }

    public void sendKeys(TestObject to, String strokeKeys) throws Exception {
        KeywordHelper.checkTestObjectParameter((TestObject)to);
        WebElement element = this.findElement(to, 10);
        if (element == null) {
            KeywordMain.stepFailed((String)MessageFormat.format(StringConstants.KW_MSG_OBJ_NOT_FOUND, to.getObjectId()), (FailureHandling)flowControl, null);
            return;
        }
        element.sendKeys(new CharSequence[]{strokeKeys});
    }

    public void pressKeyCode(String keyCode) throws Exception {
        if (!(this.driver instanceof AndroidDriver)) {
            throw new UnsupportedOperationException();
        }
        try {
            AndroidKey key = AndroidKey.valueOf((String)keyCode);
            ((AndroidDriver)this.driver).pressKey(new KeyEvent(key));
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public void tapAtPosition(Number x, Number y) throws Exception {
        try {
            MobileCommonHelper.tap((AppiumDriver)this.driver, (Point)new Point(x.intValue(), y.intValue()));
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e, (String)"Exception while tap at position | x = %s | y = %s".formatted(x, y));
            throw e;
        }
    }

    public void pressHome() {
        if (this.driver instanceof AndroidDriver) {
            ((AndroidDriver)this.driver).pressKey(new KeyEvent(AndroidKey.HOME));
        } else if (this.driver instanceof IOSDriver) {
            this.driver.executeScript("mobile: pressButton", new Object[]{Map.of("name", "home")});
        }
    }

    public void injectImage(String imageFilePath) throws StepFailedException {
        MobileCommonHelper.injectImage((AppiumDriver)this.driver, (String)imageFilePath);
    }
}

