/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import com.kms.katalon.core.logging.KeywordLogger;
import cucumber.api.Argument;
import cucumber.api.HookTestStep;
import cucumber.api.HookType;
import cucumber.api.PickleStepTestStep;
import cucumber.api.Result;
import cucumber.api.TestCase;
import cucumber.api.TestStep;
import cucumber.api.event.EmbedEvent;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestSourceRead;
import cucumber.api.event.TestStepFinished;
import cucumber.api.event.TestStepStarted;
import cucumber.api.event.WriteEvent;
import cucumber.api.formatter.Formatter;
import cucumber.api.formatter.NiceAppendable;
import cucumber.runtime.formatter.TestSourcesModel;
import gherkin.ast.Background;
import gherkin.ast.DocString;
import gherkin.ast.Feature;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.Step;
import gherkin.deps.com.google.gson.Gson;
import gherkin.deps.com.google.gson.GsonBuilder;
import gherkin.deps.net.iharder.Base64;
import gherkin.pickles.PickleCell;
import gherkin.pickles.PickleRow;
import gherkin.pickles.PickleString;
import gherkin.pickles.PickleTable;
import gherkin.pickles.PickleTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSONFormatter
implements Formatter {
    private final KeywordLogger logger = KeywordLogger.getInstance(this.getClass());
    private String currentFeatureFile;
    private List<Map<String, Object>> featureMaps = new ArrayList<Map<String, Object>>();
    private List<Map<String, Object>> currentElementsList;
    private Map<String, Object> currentElementMap;
    private Map<String, Object> currentTestCaseMap;
    private List<Map<String, Object>> currentStepsList;
    private Map<String, Object> currentStepOrHookMap;
    private Map<String, Object> currentBeforeStepHookList = new HashMap<String, Object>();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final NiceAppendable out;
    private final TestSourcesModel testSources = new TestSourcesModel();
    private EventHandler<TestSourceRead> testSourceReadHandler = new EventHandler<TestSourceRead>(){

        public void receive(TestSourceRead event) {
            JSONFormatter.this.handleTestSourceRead(event);
        }
    };
    private EventHandler<TestCaseStarted> caseStartedHandler = new EventHandler<TestCaseStarted>(){

        public void receive(TestCaseStarted event) {
            JSONFormatter.this.handleTestCaseStarted(event);
        }
    };
    private EventHandler<TestStepStarted> stepStartedHandler = new EventHandler<TestStepStarted>(){

        public void receive(TestStepStarted event) {
            JSONFormatter.this.handleTestStepStarted(event);
        }
    };
    private EventHandler<TestStepFinished> stepFinishedHandler = new EventHandler<TestStepFinished>(){

        public void receive(TestStepFinished event) {
            JSONFormatter.this.handleTestStepFinished(event);
        }
    };
    private EventHandler<TestRunFinished> runFinishedHandler = new EventHandler<TestRunFinished>(){

        public void receive(TestRunFinished event) {
            JSONFormatter.this.finishReport();
        }
    };
    private EventHandler<WriteEvent> writeEventhandler = new EventHandler<WriteEvent>(){

        public void receive(WriteEvent event) {
            JSONFormatter.this.handleWrite(event);
        }
    };
    private EventHandler<EmbedEvent> embedEventhandler = new EventHandler<EmbedEvent>(){

        public void receive(EmbedEvent event) {
            JSONFormatter.this.handleEmbed(event);
        }
    };

    public JSONFormatter(Appendable out) {
        this.out = new NiceAppendable(out);
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceRead.class, this.testSourceReadHandler);
        publisher.registerHandlerFor(TestCaseStarted.class, this.caseStartedHandler);
        publisher.registerHandlerFor(TestStepStarted.class, this.stepStartedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.stepFinishedHandler);
        publisher.registerHandlerFor(WriteEvent.class, this.writeEventhandler);
        publisher.registerHandlerFor(EmbedEvent.class, this.embedEventhandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.runFinishedHandler);
    }

    private void handleTestSourceRead(TestSourceRead event) {
        this.testSources.addTestSourceReadEvent(event.uri, event);
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        if (this.currentFeatureFile == null || !this.currentFeatureFile.equals(event.testCase.getUri())) {
            this.currentFeatureFile = event.testCase.getUri();
            Map<String, Object> currentFeatureMap = this.createFeatureMap(event.testCase);
            this.featureMaps.add(currentFeatureMap);
            this.currentElementsList = (List)currentFeatureMap.get("elements");
        }
        this.currentTestCaseMap = this.createTestCase(event.testCase);
        if (this.testSources.hasBackground(this.currentFeatureFile, event.testCase.getLine())) {
            this.currentElementMap = this.createBackground(event.testCase);
            this.currentElementsList.add(this.currentElementMap);
        } else {
            this.currentElementMap = this.currentTestCaseMap;
        }
        this.currentElementsList.add(this.currentTestCaseMap);
        this.currentStepsList = (List)this.currentElementMap.get("steps");
    }

    private void handleTestStepStarted(TestStepStarted event) {
        if (event.testStep instanceof PickleStepTestStep) {
            PickleStepTestStep testStep = (PickleStepTestStep)event.testStep;
            if (this.isFirstStepAfterBackground(testStep)) {
                this.currentElementMap = this.currentTestCaseMap;
                this.currentStepsList = (List)this.currentElementMap.get("steps");
            }
            this.currentStepOrHookMap = this.createTestStep(testStep);
            if (this.currentBeforeStepHookList.containsKey(HookType.Before.toString())) {
                this.currentStepOrHookMap.put(HookType.Before.toString(), this.currentBeforeStepHookList.get(HookType.Before.toString()));
                this.currentBeforeStepHookList.clear();
            }
            this.currentStepsList.add(this.currentStepOrHookMap);
        } else if (event.testStep instanceof HookTestStep) {
            HookTestStep hookTestStep = (HookTestStep)event.testStep;
            this.currentStepOrHookMap = this.createHookStep(hookTestStep);
            this.addHookStepToTestCaseMap(this.currentStepOrHookMap, hookTestStep.getHookType());
        } else {
            throw new IllegalStateException();
        }
    }

    private void handleWrite(WriteEvent event) {
        this.addOutputToHookMap(event.text);
    }

    private void handleEmbed(EmbedEvent event) {
        this.addEmbeddingToHookMap(event.data, event.mimeType);
    }

    private void handleTestStepFinished(TestStepFinished event) {
        this.currentStepOrHookMap.put("match", this.createMatchMap(event.testStep, event.result));
        this.currentStepOrHookMap.put("result", this.createResultMap(event.result));
    }

    private void finishReport() {
        this.out.append((CharSequence)this.gson.toJson(this.featureMaps));
        this.out.close();
    }

    private Map<String, Object> createFeatureMap(TestCase testCase) {
        HashMap<String, Object> featureMap = new HashMap<String, Object>();
        featureMap.put("uri", testCase.getUri());
        featureMap.put("elements", new ArrayList());
        Feature feature = this.testSources.getFeature(testCase.getUri());
        if (feature != null) {
            featureMap.put("keyword", feature.getKeyword());
            featureMap.put("name", this.maskValue(feature.getName()));
            String description = feature.getDescription() != null ? feature.getDescription() : "";
            featureMap.put("description", this.maskValue(description));
            featureMap.put("line", feature.getLocation().getLine());
            featureMap.put("id", TestSourcesModel.convertToId(feature.getName()));
            featureMap.put("tags", feature.getTags());
        }
        return featureMap;
    }

    private Map<String, Object> createTestCase(TestCase testCase) {
        HashMap<String, Object> testCaseMap = new HashMap<String, Object>();
        testCaseMap.put("name", this.maskValue(testCase.getName()));
        testCaseMap.put("line", testCase.getLine());
        testCaseMap.put("type", "scenario");
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testCase.getLine());
        if (astNode != null) {
            testCaseMap.put("id", TestSourcesModel.calculateId(astNode));
            ScenarioDefinition scenarioDefinition = TestSourcesModel.getScenarioDefinition(astNode);
            testCaseMap.put("keyword", scenarioDefinition.getKeyword());
            String description = scenarioDefinition.getDescription() != null ? scenarioDefinition.getDescription() : "";
            testCaseMap.put("description", this.maskValue(description));
        }
        testCaseMap.put("steps", new ArrayList());
        if (!testCase.getTags().isEmpty()) {
            ArrayList tagList = new ArrayList();
            for (PickleTag tag : testCase.getTags()) {
                HashMap<String, String> tagMap = new HashMap<String, String>();
                tagMap.put("name", this.maskValue(tag.getName()));
                tagList.add(tagMap);
            }
            testCaseMap.put("tags", tagList);
        }
        return testCaseMap;
    }

    private Map<String, Object> createBackground(TestCase testCase) {
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testCase.getLine());
        if (astNode != null) {
            Background background = TestSourcesModel.getBackgroundForTestCase(astNode);
            HashMap<String, Object> testCaseMap = new HashMap<String, Object>();
            testCaseMap.put("name", this.maskValue(background.getName()));
            testCaseMap.put("line", background.getLocation().getLine());
            testCaseMap.put("type", "background");
            testCaseMap.put("keyword", background.getKeyword());
            String description = background.getDescription() != null ? background.getDescription() : "";
            testCaseMap.put("description", this.maskValue(description));
            testCaseMap.put("steps", new ArrayList());
            return testCaseMap;
        }
        return null;
    }

    private boolean isFirstStepAfterBackground(PickleStepTestStep testStep) {
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testStep.getStepLine());
        return astNode != null && this.currentElementMap != this.currentTestCaseMap && !TestSourcesModel.isBackgroundStep(astNode);
    }

    private Map<String, Object> createTestStep(PickleStepTestStep testStep) {
        HashMap<String, Object> stepMap = new HashMap<String, Object>();
        stepMap.put("name", this.maskValue(testStep.getStepText()));
        stepMap.put("line", testStep.getStepLine());
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testStep.getStepLine());
        if (!testStep.getStepArgument().isEmpty()) {
            gherkin.pickles.Argument argument = (gherkin.pickles.Argument)testStep.getStepArgument().get(0);
            if (argument instanceof PickleString) {
                stepMap.put("doc_string", this.createDocStringMap(argument, astNode));
            } else if (argument instanceof PickleTable) {
                stepMap.put("rows", this.createDataTableList(argument));
            }
        }
        if (astNode != null) {
            Step step = (Step)astNode.node;
            stepMap.put("keyword", step.getKeyword());
        }
        return stepMap;
    }

    private Map<String, Object> createDocStringMap(gherkin.pickles.Argument argument, TestSourcesModel.AstNode astNode) {
        HashMap<String, Object> docStringMap = new HashMap<String, Object>();
        PickleString docString = (PickleString)argument;
        docStringMap.put("value", this.maskValue(docString.getContent()));
        docStringMap.put("line", docString.getLocation().getLine());
        if (astNode != null) {
            docStringMap.put("content_type", ((DocString)((Step)astNode.node).getArgument()).getContentType());
        }
        return docStringMap;
    }

    private List<Map<String, Object>> createDataTableList(gherkin.pickles.Argument argument) {
        ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>();
        for (PickleRow row : ((PickleTable)argument).getRows()) {
            HashMap<String, List<String>> rowMap = new HashMap<String, List<String>>();
            rowMap.put("cells", this.createCellList(row));
            rowList.add(rowMap);
        }
        return rowList;
    }

    private List<String> createCellList(PickleRow row) {
        ArrayList<String> cells = new ArrayList<String>();
        for (PickleCell cell : row.getCells()) {
            cells.add(cell.getValue());
        }
        return cells;
    }

    private Map<String, Object> createHookStep(HookTestStep hookTestStep) {
        return new HashMap<String, Object>();
    }

    private void addHookStepToTestCaseMap(Map<String, Object> currentStepOrHookMap, HookType hookType) {
        String hookName = hookType.toString().contains("after") ? "after" : "before";
        Map<String, Object> mapToAddTo = switch (hookType) {
            case HookType.Before -> this.currentTestCaseMap;
            case HookType.After -> this.currentTestCaseMap;
            case HookType.BeforeStep -> this.currentBeforeStepHookList;
            case HookType.AfterStep -> this.currentStepsList.get(this.currentStepsList.size() - 1);
            default -> this.currentTestCaseMap;
        };
        if (!mapToAddTo.containsKey(hookName)) {
            mapToAddTo.put(hookName, new ArrayList());
        }
        ((List)mapToAddTo.get(hookName)).add(currentStepOrHookMap);
    }

    private void addOutputToHookMap(String text) {
        if (!this.currentStepOrHookMap.containsKey("output")) {
            this.currentStepOrHookMap.put("output", new ArrayList());
        }
        ((List)this.currentStepOrHookMap.get("output")).add(text);
    }

    private void addEmbeddingToHookMap(byte[] data, String mimeType) {
        if (!this.currentStepOrHookMap.containsKey("embeddings")) {
            this.currentStepOrHookMap.put("embeddings", new ArrayList());
        }
        Map<String, Object> embedMap = this.createEmbeddingMap(data, mimeType);
        ((List)this.currentStepOrHookMap.get("embeddings")).add(embedMap);
    }

    private Map<String, Object> createEmbeddingMap(byte[] data, String mimeType) {
        HashMap<String, Object> embedMap = new HashMap<String, Object>();
        embedMap.put("mime_type", mimeType);
        embedMap.put("data", Base64.encodeBytes((byte[])data));
        return embedMap;
    }

    private Map<String, Object> createMatchMap(TestStep step, Result result) {
        PickleStepTestStep testStep;
        HashMap<String, Object> matchMap = new HashMap<String, Object>();
        if (step instanceof PickleStepTestStep && !(testStep = (PickleStepTestStep)step).getDefinitionArgument().isEmpty()) {
            ArrayList argumentList = new ArrayList();
            for (Argument argument : testStep.getDefinitionArgument()) {
                HashMap<String, Object> argumentMap = new HashMap<String, Object>();
                if (argument.getValue() != null) {
                    argumentMap.put("val", this.maskValue(argument.getValue()));
                    argumentMap.put("offset", argument.getStart());
                }
                argumentList.add(argumentMap);
            }
            matchMap.put("arguments", argumentList);
        }
        if (!result.is(Result.Type.UNDEFINED)) {
            matchMap.put("location", step.getCodeLocation());
        }
        return matchMap;
    }

    private Map<String, Object> createResultMap(Result result) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("status", result.getStatus().lowerCaseName());
        if (result.getErrorMessage() != null) {
            resultMap.put("error_message", this.maskValue(result.getErrorMessage()));
        }
        if (result.getDuration() != null && result.getDuration() != 0L) {
            resultMap.put("duration", result.getDuration());
        }
        return resultMap;
    }

    private String maskValue(String message) {
        if (message == null) {
            return message;
        }
        Pattern pattern = this.logger.getSecureValuesPattern();
        if (pattern == null) {
            return message;
        }
        Matcher matcher = pattern.matcher(message);
        return matcher.replaceAll("\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022");
    }
}

