/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.steps.integration;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Base64;

public abstract class SerializationHelper {
    public static <T> String serialize(T object) throws IOException {
        try (ObjectOutputStream objectOutputStream = null;){
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            byteArrayOutputStream.close();
            String string = Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
            return string;
        }
    }

    public static <T> T deserialize(String serializedObject) throws IOException, ClassNotFoundException {
        try (ObjectInputStream objectInputStream = null;){
            byte[] gherkinStepBytes = Base64.getDecoder().decode(serializedObject);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(gherkinStepBytes);
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            return (T)object;
        }
    }
}

