/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.part;

import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.editors.StringComboBoxCellEditor;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.testsuite.collection.constant.ImageConstants;
import com.kms.katalon.core.enums.mobile.LocatorStrategy;
import com.kms.katalon.core.mobile.helper.MobileCommonHelper;
import com.kms.katalon.core.testobject.ConditionType;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class MobileTestObjectPropertiesTable
extends CTableViewer {
    private Table table = this.getTable();
    private TableViewerColumn tvcName;
    private TableViewerColumn tvcValue;
    private TableViewerColumn tvcCondition;
    private TableViewerColumn tvcSelected;
    private TableColumn tcName;
    private TableColumn tcValue;
    private TableColumn tcCondition;
    private TableColumn tcSelected;
    private TestObjectPropertiesTableListener tableListener;
    private List<WebElementPropertyEntity> properties;
    private boolean selectedAllProperties;

    public MobileTestObjectPropertiesTable(Composite parent) {
        super(parent, 68354);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(ControlUtils.shouldLineVisble((Display)this.table.getDisplay()));
        this.initColumnViewers();
        this.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
    }

    public void setInput(List<WebElementPropertyEntity> properties) {
        this.properties = properties;
        super.setInput(properties);
    }

    public void addListener(TestObjectPropertiesTableListener tableListener) {
        this.tableListener = tableListener;
    }

    private void initColumnViewers() {
        this.initColumnName(this);
        this.initColumnCondition(this);
        this.initColumnValue(this);
        this.initColumnSelected(this);
    }

    private void initColumnName(final CTableViewer tableViewer) {
        this.tvcName = new TableViewerColumn((TableViewer)this, 0);
        this.tcName = this.tvcName.getColumn();
        this.tcName.setText("Name");
        this.tcName.setWidth(175);
        this.tvcName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((WebElementPropertyEntity)element).getName();
            }
        });
        this.tvcName.setEditingSupport(new EditingSupport(this.tvcName.getViewer()){

            protected void setValue(Object element, Object newValue) {
                if (!this.canEdit(element)) {
                    return;
                }
                WebElementPropertyEntity webElement = (WebElementPropertyEntity)element;
                webElement.setName((String)newValue);
                tableViewer.refresh((Object)webElement);
                MobileTestObjectPropertiesTable.this.updateData();
            }

            protected Object getValue(Object element) {
                if (!this.canEdit(element)) {
                    return null;
                }
                return ((WebElementPropertyEntity)element).getName();
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)MobileTestObjectPropertiesTable.this.table);
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
    }

    private void initColumnCondition(final CTableViewer tableViewer) {
        this.tvcCondition = new TableViewerColumn((TableViewer)this, 16384);
        this.tcCondition = this.tvcCondition.getColumn();
        this.tcCondition.setText("Condition");
        this.tcCondition.setWidth(175);
        this.tvcCondition.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((WebElementPropertyEntity)element).getMatchCondition();
            }
        });
        this.tvcCondition.setEditingSupport(new EditingSupport(this.tvcCondition.getViewer()){

            protected void setValue(Object element, Object value) {
                if (!this.canEdit(element)) {
                    return;
                }
                ((WebElementPropertyEntity)element).setMatchCondition(String.valueOf(value));
                tableViewer.refresh(element);
                MobileTestObjectPropertiesTable.this.updateData();
            }

            protected Object getValue(Object element) {
                if (!this.canEdit(element)) {
                    return null;
                }
                return ((WebElementPropertyEntity)element).getMatchCondition();
            }

            protected CellEditor getCellEditor(Object element) {
                StringComboBoxCellEditor comboBoxCellEditor = new StringComboBoxCellEditor((Composite)MobileTestObjectPropertiesTable.this.table, WebElementPropertyEntity.MATCH_CONDITION.getTextValues(), 8);
                return comboBoxCellEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
    }

    private void initColumnValue(final CTableViewer tableViewer) {
        this.tvcValue = new TableViewerColumn((TableViewer)this, 0);
        this.tcValue = this.tvcValue.getColumn();
        this.tcValue.setText("Value");
        this.tcValue.setWidth(350);
        this.tvcValue.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((WebElementPropertyEntity)element).getValue();
            }
        });
        this.tvcValue.setEditingSupport(new EditingSupport(this.tvcValue.getViewer()){

            protected void setValue(Object element, Object value) {
                if (!this.canEdit(element)) {
                    return;
                }
                WebElementPropertyEntity webElement = (WebElementPropertyEntity)element;
                String newPropValue = String.valueOf(value);
                webElement.setValue(newPropValue);
                tableViewer.refresh((Object)webElement);
                MobileTestObjectPropertiesTable.this.updateData();
            }

            protected Object getValue(Object element) {
                if (!this.canEdit(element)) {
                    return null;
                }
                return ((WebElementPropertyEntity)element).getValue();
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)MobileTestObjectPropertiesTable.this.table);
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
    }

    private boolean isAllSelected() {
        if (this.properties == null) {
            return false;
        }
        for (WebElementPropertyEntity property : this.properties) {
            if (property.getIsSelected().booleanValue()) continue;
            return false;
        }
        return true;
    }

    private void toggleAllSelected() {
        this.selectedAllProperties = !this.selectedAllProperties;
        for (WebElementPropertyEntity property : this.properties) {
            property.setIsSelected(Boolean.valueOf(this.selectedAllProperties));
        }
        super.setInput(this.properties);
        this.tcSelected.setImage(this.getCheckboxIcon(this.selectedAllProperties));
        this.updateData();
    }

    private void initColumnSelected(final CTableViewer tableViewer) {
        this.tvcSelected = new TableViewerColumn((TableViewer)this, 16384);
        this.tcSelected = this.tvcSelected.getColumn();
        this.tcSelected.setText("Detect object by?");
        this.tcSelected.setWidth(150);
        this.selectedAllProperties = this.isAllSelected();
        this.tcSelected.setImage(this.getCheckboxIcon(this.selectedAllProperties));
        this.tcSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MobileTestObjectPropertiesTable.this.toggleAllSelected();
                MobileTestObjectPropertiesTable.this.updateData();
            }
        });
        this.tvcSelected.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object property = cell.getElement();
                if (!(property instanceof WebElementPropertyEntity)) {
                    return;
                }
                MobileTestObjectPropertiesTable.this.selectedAllProperties = MobileTestObjectPropertiesTable.this.isAllSelected();
                MobileTestObjectPropertiesTable.this.tcSelected.setImage(MobileTestObjectPropertiesTable.this.getCheckboxIcon(MobileTestObjectPropertiesTable.this.isAllSelected()));
            }
        });
        this.tvcSelected.setEditingSupport(new EditingSupport(this.tvcSelected.getViewer()){

            protected void setValue(Object element, Object value) {
                if (!this.canEdit(element)) {
                    return;
                }
                WebElementPropertyEntity webElement = (WebElementPropertyEntity)element;
                webElement.setIsSelected(Boolean.valueOf((Boolean)value));
                tableViewer.refresh((Object)webElement);
                MobileTestObjectPropertiesTable.this.updateData();
            }

            protected Object getValue(Object element) {
                if (this.canEdit(element) && ((WebElementPropertyEntity)element).getIsSelected().booleanValue()) {
                    return true;
                }
                return false;
            }

            protected CellEditor getCellEditor(Object element) {
                return new CheckboxCellEditor();
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        this.table.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                if (event.index == 3) {
                    WebElementPropertyEntity data = (WebElementPropertyEntity)((TableItem)event.item).getData();
                    Image tmpImage = MobileTestObjectPropertiesTable.this.getCheckboxIcon(data.getIsSelected());
                    int tmpHeight = 0;
                    int tmpX = 0;
                    int tmpY = 0;
                    tmpHeight = ((TableItem)event.item).getBounds().height;
                    tmpX = 5;
                    tmpY = tmpImage.getBounds().height;
                    tmpY = tmpHeight / 2 - tmpY / 2;
                    tmpX = tmpX <= 0 ? event.x : (tmpX += event.x);
                    tmpY = tmpY <= 0 ? event.y : (tmpY += event.y);
                    event.gc.drawImage(tmpImage, tmpX, tmpY);
                }
            }
        });
    }

    public void updateUIByLocatorStrategy(LocatorStrategy locatorStrategy) {
        switch (locatorStrategy) {
            case ATTRIBUTES: {
                this.tcCondition.setWidth(150);
                this.tcSelected.setWidth(150);
                break;
            }
            default: {
                this.tcCondition.setWidth(0);
                this.tcCondition.setResizable(false);
                this.tcSelected.setWidth(0);
                this.tcSelected.setResizable(false);
            }
        }
    }

    private Image getCheckboxIcon(boolean isChecked) {
        return isChecked ? ImageConstants.IMG_16_CHECKED : ImageConstants.IMG_16_UNCHECKED;
    }

    private boolean isWebElementProperty(Object element) {
        return element != null && WebElementPropertyEntity.class.getSimpleName().equals(element.getClass().getSimpleName());
    }

    private void updateData() {
        this.tableListener.onSelectProperties();
    }

    public String updateLocator() {
        TestObject testObject = this.buildTestObject(this.properties);
        String locatorValue = MobileCommonHelper.getAttributeLocatorValue((TestObject)testObject);
        return locatorValue;
    }

    private TestObject buildTestObject(List<WebElementPropertyEntity> properties) {
        TestObject testObject = new TestObject();
        properties.forEach(prop -> testObject.addProperty(prop.getName(), ConditionType.fromValue((String)prop.getMatchCondition()), prop.getValue(), prop.getIsSelected().booleanValue()));
        return testObject;
    }

    public static interface TestObjectPropertiesTableListener {
        public void onSelectProperties();
    }
}

