/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import org.eclipse.jgit.lib.Config;

public class GpgConfig {
    private final GpgFormat keyFormat;
    private final String signingKey;
    private final String program;
    private final boolean signCommits;
    private final boolean signAllTags;
    private final boolean forceAnnotated;
    private final String sshDefaultKeyCommand;
    private final String sshAllowedSignersFile;
    private final String sshRevocationFile;

    public GpgConfig(Config config) {
        this.keyFormat = (GpgFormat)config.getEnum(GpgFormat.values(), "gpg", null, "format", GpgFormat.OPENPGP);
        this.signingKey = config.getString("user", null, "signingKey");
        String exe = config.getString("gpg", this.keyFormat.toConfigValue(), "program");
        if (exe == null && GpgFormat.OPENPGP.equals(this.keyFormat)) {
            exe = config.getString("gpg", null, "program");
        }
        this.program = exe;
        this.signCommits = config.getBoolean("commit", "gpgSign", false);
        this.signAllTags = config.getBoolean("tag", "gpgSign", false);
        this.forceAnnotated = config.getBoolean("tag", "forceSignAnnotated", false);
        this.sshDefaultKeyCommand = config.getString("gpg", "ssh", "defaultKeyCommand");
        this.sshAllowedSignersFile = config.getString("gpg", "ssh", "allowedSignersFile");
        this.sshRevocationFile = config.getString("gpg", "ssh", "revocationFile");
    }

    public GpgFormat getKeyFormat() {
        return this.keyFormat;
    }

    public String getProgram() {
        return this.program;
    }

    public String getSigningKey() {
        return this.signingKey;
    }

    public boolean isSignCommits() {
        return this.signCommits;
    }

    public boolean isSignAllTags() {
        return this.signAllTags;
    }

    public boolean isSignAnnotated() {
        return this.forceAnnotated;
    }

    public String getSshDefaultKeyCommand() {
        return this.sshDefaultKeyCommand;
    }

    public String getSshAllowedSignersFile() {
        return this.sshAllowedSignersFile;
    }

    public String getSshRevocationFile() {
        return this.sshRevocationFile;
    }

    public static enum GpgFormat implements Config.ConfigEnum
    {
        OPENPGP("openpgp"),
        X509("x509"),
        SSH("ssh");

        private final String configValue;

        private GpgFormat(String configValue) {
            this.configValue = configValue;
        }

        @Override
        public boolean matchConfigValue(String s) {
            return this.configValue.equals(s);
        }

        @Override
        public String toConfigValue() {
            return this.configValue;
        }
    }
}

