/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.selenium.ide.format;

import com.kms.katalon.selenium.ide.model.Command;
import com.kms.katalon.selenium.ide.util.ClazzUtils;
import org.apache.commons.lang3.StringUtils;

public interface Formatter {
    public String format(Command var1);

    default public String stringValue(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            value = value.replace("\"", "'");
        }
        return "\"" + value + "\"";
    }

    default public String paramOf(String param) {
        if (StringUtils.isNotBlank((CharSequence)param)) {
            if (((String)(param = ((String)param).trim())).contains("${")) {
                param = ((String)param).replace("${", "+");
                if (((String)(param = ((String)param).replace("}", "+"))).startsWith("+")) {
                    param = ((String)param).replaceFirst("\\+", "");
                } else {
                    param = "\"" + (String)param;
                    param = ((String)param).replaceFirst("\\+", "\" + ");
                }
                if (((String)param).endsWith("+")) {
                    param = ((String)param).substring(0, ((String)param).lastIndexOf("+"));
                } else {
                    String tail = ((String)param).substring(((String)param).lastIndexOf("+"), ((String)param).length());
                    param = ((String)param).substring(0, ((String)param).indexOf("+")) + " + \"" + tail + "\"";
                }
            }
            if (((String)param).startsWith("KEY_")) {
                param = ((String)param).replace("KEY_", "");
                param = "Keys." + (String)param;
            }
        }
        return param;
    }

    default public String valueOf(String param) {
        if (StringUtils.isNotBlank((CharSequence)param) && param.contains("${")) {
            return this.paramOf(param);
        }
        return this.stringValue(param);
    }

    default public String getPattern(String suffixMethodName, String target, String value) {
        boolean hasParam = ClazzUtils.hasParam("get" + suffixMethodName);
        return hasParam ? value : target;
    }

    default public boolean isMatching(String pattern) {
        return pattern.contains("*") || pattern.startsWith("glob:") || pattern.startsWith("regrex:");
    }

    default public String toPattern(String userPattern) {
        if (userPattern.startsWith("glob:")) {
            userPattern = userPattern.replace("glob:", "");
            return com.kms.katalon.selenium.ide.util.StringUtils.convertGlobToRegex(userPattern);
        }
        if (userPattern.startsWith("regex:")) {
            userPattern = userPattern.replace("regex:", "");
        }
        return userPattern.replaceAll("\\*", ".*");
    }

    default public String conditionWithMatchingOrNot(String suffixMethodName, String target, String value) throws Exception {
        String cleanMethodName = this.getCleanCommandTail(suffixMethodName);
        String method = this.getNormalMethod(cleanMethodName, target);
        String pattern = this.getPattern(cleanMethodName, target, value);
        Object ret = "";
        ret = this.isMatching(pattern) ? method + ".matches(\"" + this.toPattern(pattern) + "\")" : "\"" + pattern + "\", " + method;
        return ret;
    }

    default public String conditionWithMatchingOrNotForWaitFor(String suffixMethodName, String target, String value) throws Exception {
        String cleanMethodName = this.getCleanCommandTail(suffixMethodName);
        String method = this.getNormalMethod(cleanMethodName, target);
        String pattern = this.getPattern(cleanMethodName, target, value);
        Object ret = "";
        ret = this.isMatching(pattern) ? method + ".matches(\"" + this.toPattern(pattern) + "\")" : "\"" + pattern + "\".equals(" + method + ")";
        return ret;
    }

    default public String getCleanCommandTail(String commandTail) {
        String method = commandTail.replace("Not", "");
        return method.replace("AndWait", "");
    }

    default public String getWaitIfHas(String commandTail) {
        if (commandTail.lastIndexOf("AndWait") != -1) {
            return "\nselenium.andWait()";
        }
        return null;
    }

    default public String getParamName(String method, String target, String value) {
        boolean hasParam = ClazzUtils.hasParam(this.getCleanCommandTail(method));
        if (hasParam) {
            return this.paramOf(value);
        }
        return this.paramOf(target);
    }

    default public String getParamMethod(String method, String target) throws Exception {
        boolean hasMethod = ClazzUtils.hasMethod(method);
        if (!hasMethod) {
            throw new Exception("Method is not found");
        }
        boolean hasParam = ClazzUtils.hasParam(method);
        if (hasParam) {
            return "(" + this.valueOf(target) + ")";
        }
        return "()";
    }

    default public String getNormalMethod(String commandTail, String target) throws Exception {
        String methodName = this.getCleanCommandTail(commandTail);
        String param = this.getParamMethod("get" + methodName, target);
        boolean isArray = ClazzUtils.isArrayReturned(methodName);
        String method = methodName + param;
        return isArray ? "join(selenium.get" + method + ", ',')" : "selenium.get" + method;
    }

    default public String getBoolMethod(String commandTail, String target) throws Exception {
        String methodName = this.getCleanCommandTail(commandTail);
        String param = this.getParamMethod("is" + methodName + "Present", target);
        return "selenium.is" + methodName + "Present" + param;
    }

    default public String getBoolCheckedMethod(String commandTail, String target) throws Exception {
        String methodName = this.getCleanCommandTail(commandTail);
        String param = this.getParamMethod("is" + methodName, target);
        return "selenium.is" + methodName + param;
    }

    default public String getBoolWhetherMethod(String commandTail, String target, String value) throws Exception {
        String methodName = this.getCleanCommandTail(commandTail);
        int paramCount = ClazzUtils.getParamCount("get" + methodName);
        StringBuffer params = new StringBuffer();
        params.append("(");
        if (paramCount == 2) {
            params.append("\"" + target + "\"");
            params.append(", \"" + value + "\"");
        } else if (paramCount == 1) {
            params.append("\"" + target + "\"");
        }
        params.append(")");
        return "selenium.get" + methodName + params.toString();
    }
}

