/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.hierarchy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyBuilder;
import org.eclipse.jdt.internal.core.hierarchy.RegionBasedTypeHierarchy;
import org.eclipse.jdt.internal.core.hierarchy.TypeHierarchy;

public class RegionBasedHierarchyBuilder
extends HierarchyBuilder {
    public RegionBasedHierarchyBuilder(TypeHierarchy hierarchy) throws JavaModelException {
        super(hierarchy);
    }

    @Override
    public void build(boolean computeSubtypes) {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        try {
            manager.cacheZipFiles(this);
            if (this.hierarchy.focusType == null || computeSubtypes) {
                HashMap allOpenablesInRegion = this.determineOpenablesInRegion((IProgressMonitor)this.hierarchy.progressMonitor.split(30));
                this.hierarchy.initialize(allOpenablesInRegion.size());
                this.createTypeHierarchyBasedOnRegion(allOpenablesInRegion, (IProgressMonitor)this.hierarchy.progressMonitor.split(70));
                ((RegionBasedTypeHierarchy)this.hierarchy).pruneDeadBranches();
            } else {
                this.hierarchy.initialize(1);
                this.buildSupertypes();
            }
        }
        finally {
            manager.flushZipFiles(this);
        }
    }

    private void createTypeHierarchyBasedOnRegion(HashMap allOpenablesInRegion, IProgressMonitor monitor) {
        try {
            int size = allOpenablesInRegion.size();
            if (monitor != null) {
                monitor.beginTask("", size * 2);
            }
            this.infoToHandle = new HashMap(size);
            for (Map.Entry entry : allOpenablesInRegion.entrySet()) {
                JavaProject project = (JavaProject)entry.getKey();
                ArrayList allOpenables = (ArrayList)entry.getValue();
                Openable[] openables = new Openable[allOpenables.size()];
                allOpenables.toArray(openables);
                try {
                    SearchableEnvironment searchableEnvironment = project.newSearchableNameEnvironment(this.hierarchy.workingCopies);
                    this.nameLookup = searchableEnvironment.nameLookup;
                    this.hierarchyResolver.resolve(openables, null, monitor);
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private HashMap determineOpenablesInRegion(IProgressMonitor monitor) {
        try {
            HashMap allOpenables = new HashMap();
            IJavaElement[] roots = ((RegionBasedTypeHierarchy)this.hierarchy).region.getElements();
            int length = roots.length;
            if (monitor != null) {
                monitor.beginTask("", length);
            }
            int i = 0;
            while (i < length) {
                IJavaElement root = roots[i];
                IJavaProject javaProject = root.getJavaProject();
                ArrayList<IJavaElement> openables = (ArrayList<IJavaElement>)allOpenables.get(javaProject);
                if (openables == null) {
                    openables = new ArrayList<IJavaElement>();
                    allOpenables.put(javaProject, openables);
                }
                switch (root.getElementType()) {
                    case 2: {
                        this.injectAllOpenablesForJavaProject((IJavaProject)root, openables);
                        break;
                    }
                    case 3: {
                        this.injectAllOpenablesForPackageFragmentRoot((IPackageFragmentRoot)root, openables);
                        break;
                    }
                    case 4: {
                        this.injectAllOpenablesForPackageFragment((IPackageFragment)root, openables);
                        break;
                    }
                    case 5: 
                    case 6: {
                        openables.add(root);
                        break;
                    }
                    case 7: {
                        IType type = (IType)root;
                        if (type.isBinary()) {
                            openables.add(type.getClassFile());
                            break;
                        }
                        if (openables.contains(type.getCompilationUnit())) break;
                        openables.add(type.getCompilationUnit());
                        break;
                    }
                }
                this.worked(monitor, 1);
                ++i;
            }
            HashMap hashMap = allOpenables;
            return hashMap;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void injectAllOpenablesForJavaProject(IJavaProject project, ArrayList openables) {
        try {
            IPackageFragmentRoot[] devPathRoots = ((JavaProject)project).getPackageFragmentRoots();
            if (devPathRoots == null) {
                return;
            }
            IPackageFragmentRoot[] iPackageFragmentRootArray = devPathRoots;
            int n = devPathRoots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                this.injectAllOpenablesForPackageFragmentRoot(root, openables);
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    private void injectAllOpenablesForPackageFragment(IPackageFragment packFrag, ArrayList openables) {
        try {
            IPackageFragmentRoot root = (IPackageFragmentRoot)packFrag.getParent();
            int kind = root.getKind();
            if (kind != 0) {
                boolean isSourcePackageFragment;
                boolean bl = isSourcePackageFragment = kind == 1;
                if (isSourcePackageFragment) {
                    ICompilationUnit[] cus;
                    ICompilationUnit[] iCompilationUnitArray = cus = packFrag.getCompilationUnits();
                    int n = cus.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICompilationUnit cu = iCompilationUnitArray[n2];
                        openables.add(cu);
                        ++n2;
                    }
                } else {
                    IOrdinaryClassFile[] classFiles;
                    IOrdinaryClassFile[] iOrdinaryClassFileArray = classFiles = packFrag.getOrdinaryClassFiles();
                    int n = classFiles.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IOrdinaryClassFile classFile = iOrdinaryClassFileArray[n3];
                        openables.add(classFile);
                        ++n3;
                    }
                }
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    private void injectAllOpenablesForPackageFragmentRoot(IPackageFragmentRoot root, ArrayList openables) {
        try {
            IJavaElement[] packFrags;
            IJavaElement[] iJavaElementArray = packFrags = root.getChildren();
            int n = packFrags.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement pf = iJavaElementArray[n2];
                IPackageFragment packFrag = (IPackageFragment)pf;
                this.injectAllOpenablesForPackageFragment(packFrag, openables);
                ++n2;
            }
        }
        catch (JavaModelException e) {
            return;
        }
    }
}

