/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.adapter;

import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.dal.fileservice.EntityService;
import com.kms.katalon.entity.Entity;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public abstract class EntityReferenceXmlAdapter<K, V extends Entity>
extends XmlAdapter<K, V> {
    protected EntityService getEntityService() throws DALException {
        try {
            return EntityService.getInstance();
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public V unmarshal(K referenceId) throws DALException {
        EntityService entityService = this.getEntityService();
        Unmarshaller oldUnmarshaller = entityService.getUnmarshaller();
        try {
            entityService.changeUnmarshaller(entityService.newUnmarshaller());
            V v = this.safelyUnmarshal(referenceId);
            return v;
        }
        finally {
            entityService.changeUnmarshaller(oldUnmarshaller);
        }
    }

    protected abstract V safelyUnmarshal(K var1) throws DALException;
}

