/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.dataprovider;

import com.kms.katalon.dal.IWebElementDataProvider;
import com.kms.katalon.dal.fileservice.manager.FolderFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.WebElementFileServiceManager;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.SaveWebElementInfoEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebElementFileServiceDataProvider
implements IWebElementDataProvider {
    public void importWebElement(List<SaveWebElementInfoEntity> entities) throws Exception {
        ArrayList<WebElementEntity> webElements = new ArrayList<WebElementEntity>();
        HashMap<FolderEntity, FolderEntity> foldersMap = new HashMap<FolderEntity, FolderEntity>();
        for (SaveWebElementInfoEntity webElementInfoEntity : entities) {
            if (webElementInfoEntity.getFolder() != null) {
                FolderEntity folderEntity = FolderFileServiceManager.addNewFolder(webElementInfoEntity.getFolder().getParentFolder(), webElementInfoEntity.getFolder().getName());
                if (folderEntity == null) continue;
                foldersMap.put(webElementInfoEntity.getFolder(), folderEntity);
                continue;
            }
            if (webElementInfoEntity.getWebElement() == null) continue;
            FolderEntity newParentFolder = (FolderEntity)foldersMap.get(webElementInfoEntity.getWebElement().getParentFolder());
            if (newParentFolder != null) {
                webElementInfoEntity.getWebElement().setParentFolder(newParentFolder);
            }
            webElements.add(webElementInfoEntity.getWebElement());
        }
        for (WebElementEntity webElementEntity : webElements) {
            WebElementFileServiceManager.updateTestObject(webElementEntity);
        }
    }

    public FolderEntity importWebElementFolder(FolderEntity folder, FolderEntity parentFolder) throws Exception {
        return WebElementFileServiceManager.importWebElementFolder(folder, parentFolder);
    }

    public WebElementEntity importWebElement(WebElementEntity webElement, FolderEntity parentFolder) throws Exception {
        return WebElementFileServiceManager.importWebElement(webElement, parentFolder);
    }

    public WebElementEntity getWebElement(String webElementValue) throws Exception {
        return WebElementFileServiceManager.getWebElement(webElementValue);
    }

    public String getAvailableWebElementName(FolderEntity parentFolder, String name) throws Exception {
        return WebElementFileServiceManager.getAvailableWebElementName(parentFolder, name);
    }

    public void deleteWebElement(WebElementEntity webElement) throws Exception {
        WebElementFileServiceManager.deleteWebElement(webElement);
    }

    public WebElementEntity updateTestObject(WebElementEntity entity) throws Exception {
        return WebElementFileServiceManager.updateTestObject(entity);
    }

    public WebElementEntity copyWebElement(WebElementEntity webElement, FolderEntity destinationFolder) throws Exception {
        return WebElementFileServiceManager.copyWebElement(webElement, destinationFolder);
    }

    public WebElementEntity moveWebElement(WebElementEntity webElement, FolderEntity destinationFolder) throws Exception {
        return WebElementFileServiceManager.moveWebElement(webElement, destinationFolder);
    }

    public List<WebElementEntity> getChildWebElementsOfFolder(FolderEntity folder) throws Exception {
        return FolderFileServiceManager.getChildWebElementsOfFolder(folder);
    }

    public List<WebElementEntity> getWebElementPropertyByRefElement(String refElement, ProjectEntity project, boolean isExactly) throws Exception {
        return WebElementFileServiceManager.getWebElementPropertyByRefElement(refElement, project, isExactly);
    }

    public WebElementPropertyEntity getRefElementProperty(WebElementEntity webElement) {
        return WebElementFileServiceManager.getRefElementProperty(webElement);
    }

    public WebElementEntity saveNewTestObject(WebElementEntity newTestObject) throws Exception {
        return WebElementFileServiceManager.saveNewTestObject(newTestObject);
    }

    public WebElementEntity getWebElementByScriptName(String scriptName, ProjectEntity projectEntity) throws Exception {
        return WebElementFileServiceManager.getWebElementByScriptName(scriptName, projectEntity);
    }

    public Map<String, File> getObjectRepositoryLookup() {
        return WebElementFileServiceManager.getObjectRepositoryLookup();
    }

    public List<Object> getAllChildren(FolderEntity parentFolder) throws Exception {
        return WebElementFileServiceManager.getAllFiles(parentFolder);
    }

    public List<Object> getAllDirectChildren(FolderEntity parentFolder) throws Exception {
        return WebElementFileServiceManager.getAllChildren(parentFolder);
    }
}

