/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.manager;

import com.kms.katalon.dal.TestSuiteCollectionDataProvider;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.dal.fileservice.EntityService;
import com.kms.katalon.dal.fileservice.FileServiceConstant;
import com.kms.katalon.dal.fileservice.constants.StringConstants;
import com.kms.katalon.dal.fileservice.dataprovider.setting.FileServiceDataProviderSetting;
import com.kms.katalon.dal.fileservice.manager.EntityFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.FolderFileServiceManager;
import com.kms.katalon.dal.fileservice.util.PathValidationUtil;
import com.kms.katalon.dal.state.DataProviderState;
import com.kms.katalon.entity.dal.exception.DuplicatedFileNameException;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class TestSuiteFileServiceManager {
    public static TestSuiteEntity getTestSuite(String testSuitePk) throws Exception {
        FileEntity entity = EntityFileServiceManager.get(new File(testSuitePk));
        if (entity instanceof TestSuiteEntity) {
            return (TestSuiteEntity)entity;
        }
        return null;
    }

    public static TestSuiteEntity initTestSuite(TestSuiteEntity testSuiteEntity) throws Exception {
        return testSuiteEntity;
    }

    public static void deleteTestSuite(TestSuiteEntity testSuite) throws Exception {
        EntityFileServiceManager.delete((FileEntity)testSuite);
        File script = TestSuiteFileServiceManager.getTestSuiteScriptFile(testSuite);
        if (script.exists()) {
            script.delete();
        }
        FolderFileServiceManager.refreshFolder(testSuite.getParentFolder());
    }

    public static TestSuiteEntity updateTestSuite(TestSuiteEntity testSuite) throws Exception {
        EntityService.getInstance().saveEntity((FileEntity)testSuite);
        return testSuite;
    }

    public static TestSuiteEntity renameTestSuite(String newName, TestSuiteEntity testSuite) throws DALException, FilePathTooLongException {
        try {
            TestSuiteFileServiceManager.validateData(testSuite);
            testSuite = TestSuiteFileServiceManager.resetParentForChildElement(testSuite);
            TestSuiteEntity oldTestSuite = testSuite.clone();
            oldTestSuite.setName(newName);
            PathValidationUtil.validatePathLength((FileEntity)oldTestSuite);
            EntityService.getInstance().getEntityCache().remove((FileEntity)testSuite, true);
            File script = TestSuiteFileServiceManager.getTestSuiteScriptFile(testSuite);
            if (script.exists()) {
                script.renameTo(new File(testSuite.getParentFolder().getLocation(), newName + ".groovy"));
            }
            testSuite.setName(newName);
            EntityService.getInstance().saveEntity((FileEntity)testSuite);
            TestSuiteFileServiceManager.updateTestSuiteReferences(testSuite);
            FolderFileServiceManager.refreshFolder(testSuite.getParentFolder());
            return testSuite;
        }
        catch (FilePathTooLongException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    private static void updateTestSuiteReferences(TestSuiteEntity testSuite) throws DALException {
        TestSuiteCollectionDataProvider tsCollectionDataProvider = new FileServiceDataProviderSetting().getTestSuiteCollectionDataProvider();
        tsCollectionDataProvider.updateTestSuiteCollectionReferences(testSuite, testSuite.getProject());
    }

    public static void validateData(TestSuiteEntity testSuiteEntity) throws Exception {
        if (TestSuiteFileServiceManager.nameChanged(testSuiteEntity)) {
            EntityService.getInstance().validateName(testSuiteEntity.getName());
            File file = new File(testSuiteEntity.getLocation());
            if (file.exists()) {
                throw new DuplicatedFileNameException(MessageFormat.format(StringConstants.MNG_EXC_EXISTED_TEST_SUITE_NAME, testSuiteEntity.getName()));
            }
        }
    }

    public static TestSuiteEntity resetParentForChildElement(TestSuiteEntity testSuite) throws Exception {
        return testSuite;
    }

    private static boolean nameChanged(TestSuiteEntity testSuiteEntity) throws Exception {
        String oldName;
        String pk = EntityService.getInstance().getEntityCache().getKey((FileEntity)testSuiteEntity);
        if (pk == null) {
            pk = TestSuiteFileServiceManager.getTestSuite(testSuiteEntity.getId()).getId();
        }
        return !(oldName = pk.substring(pk.lastIndexOf(File.separator) + 1, pk.indexOf(TestSuiteEntity.getTestSuiteFileExtension()))).equalsIgnoreCase(testSuiteEntity.getName());
    }

    public static TestSuiteEntity saveNewTestSuite(TestSuiteEntity newTestSuite) throws Exception {
        if (newTestSuite == null || newTestSuite.getProject() == null || newTestSuite.getParentFolder() == null) {
            return null;
        }
        PathValidationUtil.validatePathLength((FileEntity)newTestSuite);
        EntityService.getInstance().saveEntity((FileEntity)newTestSuite);
        FolderFileServiceManager.refreshFolder(newTestSuite.getParentFolder());
        return newTestSuite;
    }

    public static String getAvailableTestSuiteName(FolderEntity parentFolder, String name) throws Exception {
        return EntityService.getInstance().getAvailableName(parentFolder.getLocation(), name, true);
    }

    public static TestSuiteEntity copyTestSuite(TestSuiteEntity testSuite, FolderEntity destinationFolder) throws Exception {
        TestSuiteEntity coppiedTestSuite = EntityFileServiceManager.copy(testSuite, destinationFolder);
        File script = TestSuiteFileServiceManager.getTestSuiteScriptFile(testSuite);
        if (script.exists()) {
            FileUtils.copyFile((File)script, (File)TestSuiteFileServiceManager.getTestSuiteScriptFile(coppiedTestSuite));
        }
        return coppiedTestSuite;
    }

    public static TestSuiteEntity moveTestSuite(TestSuiteEntity testSuite, FolderEntity destinationFolder) throws Exception {
        TestSuiteEntity cachedTestSuite = (TestSuiteEntity)EntityService.getInstance().getEntityByPath(testSuite.getId());
        File script = TestSuiteFileServiceManager.getTestSuiteScriptFile(testSuite);
        cachedTestSuite = EntityFileServiceManager.move(cachedTestSuite, destinationFolder);
        if (script.exists()) {
            FileUtils.moveFile((File)script, (File)TestSuiteFileServiceManager.getTestSuiteScriptFile(cachedTestSuite));
        }
        TestSuiteFileServiceManager.updateTestSuiteReferences(cachedTestSuite);
        return cachedTestSuite;
    }

    public static TestSuiteEntity getTestSuiteByName(FolderEntity parentFolder, String testSuiteName) throws Exception {
        List<TestSuiteEntity> testSuites = FolderFileServiceManager.getChildTestSuitesOfFolder(parentFolder);
        for (TestSuiteEntity testSuite : testSuites) {
            if (!testSuite.getName().equals(testSuiteName)) continue;
            return testSuite;
        }
        return null;
    }

    public static TestSuiteEntity getTestSuiteByDisplayId(String testSuiteId) throws Exception {
        if (StringUtils.isBlank((String)testSuiteId)) {
            return null;
        }
        ProjectEntity projectEntity = DataProviderState.getInstance().getCurrentProject();
        String testSuitePk = projectEntity.getFolderLocation() + File.separator + testSuiteId.replace("/", File.separator) + TestSuiteEntity.getTestSuiteFileExtension();
        return TestSuiteFileServiceManager.getTestSuite(testSuitePk);
    }

    public static TestSuiteEntity getByGUID(String guid, ProjectEntity project) throws Exception {
        File testSuiteFolder;
        File projectFolder = new File(project.getFolderLocation());
        if (projectFolder.exists() && projectFolder.isDirectory() && (testSuiteFolder = new File(FileServiceConstant.getTestSuiteRootFolderLocation(projectFolder.getAbsolutePath()))).exists() && testSuiteFolder.isDirectory()) {
            return TestSuiteFileServiceManager.getByGUID(testSuiteFolder.getAbsolutePath(), guid, project);
        }
        return null;
    }

    private static TestSuiteEntity getByGUID(String testSuiteFolder, String guid, ProjectEntity project) throws Exception {
        File folder = new File(testSuiteFolder);
        if (folder.exists() && folder.isDirectory()) {
            File[] fileArray = folder.listFiles(EntityFileServiceManager.fileFilter);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                TestSuiteEntity result;
                File file = fileArray[n2];
                if (file.isFile() && file.getName().toLowerCase().endsWith(TestSuiteEntity.getTestSuiteFileExtension().toLowerCase())) {
                    FileEntity entity = EntityFileServiceManager.get(file);
                    if (entity instanceof TestSuiteEntity && ((TestSuiteEntity)entity).getTestSuiteGuid().equals(guid)) {
                        return (TestSuiteEntity)entity;
                    }
                } else if (file.isDirectory() && (result = TestSuiteFileServiceManager.getByGUID(file.getAbsolutePath(), guid, project)) != null) {
                    return result;
                }
                ++n2;
            }
        }
        return null;
    }

    public static File getTestSuiteScriptFile(TestSuiteEntity testSuite) throws DALException {
        return new File(testSuite.getProject().getFolderLocation(), testSuite.getIdForDisplay() + ".groovy");
    }

    public static File newTestSuiteScriptFile(TestSuiteEntity testSuite) throws DALException {
        File script = TestSuiteFileServiceManager.getTestSuiteScriptFile(testSuite);
        if (script.exists()) {
            return script;
        }
        try {
            script.createNewFile();
        }
        catch (IOException e) {
            throw new DALException((Exception)e);
        }
        return script;
    }

    public static List<TestSuiteEntity> getAll(ProjectEntity project) throws DALException {
        try {
            List<TestSuiteEntity> allTestSuites = EntityFileServiceManager.getDescendants(FolderFileServiceManager.getTestSuiteRoot(project), TestSuiteEntity.class);
            return allTestSuites;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }
}

