/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.testcloud.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.core.exception.HttpClientException;
import com.kms.katalon.core.exception.InvalidTokenException;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryService;
import com.kms.katalon.network.core.model.Authentication;
import com.kms.katalon.network.core.model.BearerAuthentication;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.model.exception.MalformedContentException;
import com.kms.katalon.network.core.model.exception.NetworkErrorException;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.session.core.model.AuthenticationToken;
import com.kms.katalon.session.core.model.KatOneJwtToken;
import com.kms.katalon.testcloud.core.model.APITestCloudMobileDevice;
import com.kms.katalon.testcloud.core.model.TestCloudApplication;
import com.kms.katalon.testcloud.core.model.TestCloudApplicationRequest;
import com.kms.katalon.testcloud.core.model.TestCloudConfiguration;
import com.kms.katalon.testcloud.core.model.TestCloudDeviceRequest;
import com.kms.katalon.testcloud.core.model.TestCloudEnvironment;
import com.kms.katalon.testcloud.core.model.TestCloudExecutionSessionResponse;
import com.kms.katalon.testcloud.core.model.TestCloudMobileDevice;
import com.kms.katalon.testcloud.core.model.TestCloudRemoteServerUrlRequest;
import com.kms.katalon.testcloud.core.model.TestCloudSessionTypeRequest;
import com.kms.katalon.testcloud.core.model.TestCloudSessionTypes;
import com.kms.katalon.testcloud.core.model.TestCloudTunnel;
import com.kms.katalon.testcloud.core.model.TestCloudUsage;
import com.kms.katalon.testcloud.core.model.exception.TestCloudException;
import com.kms.katalon.testcloud.core.service.ITestCloudService;
import com.kms.katalon.testcloud.dto.ApplicationPage;
import com.kms.katalon.testcloud.dto.TestCloudApplicationDto;
import com.kms.katalon.testcloud.dto.TestCloudDeviceDto;
import com.kms.katalon.testcloud.helper.SessionHelper;
import jakarta.inject.Inject;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class TestCloudService
implements ITestCloudService {
    private final Logger logger = LoggerFactory.getLogger(TestCloudService.class);
    private final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private String PAGE_TOKEN = "0";
    private int SIZE = 60;
    @Inject
    private IDiscoveryService discoveryService;
    @Inject
    private INetworkPreferences networkPreferences;
    @Inject
    private IHttpClient httpClient;
    @Inject
    SessionHelper sessionHelper;

    private Map<String, String> getTestcloudGenericHeader() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("tc-channel", this.sessionHelper.getKatalonStudioChannel());
        return headers;
    }

    public List<TestCloudMobileDevice> requestTestCloudDevices(String testCloudBaseUrl, TestCloudDeviceRequest request) throws NetworkErrorException, JsonMappingException, JsonProcessingException {
        URI uri = null;
        try {
            URI baseUri = new URI(testCloudBaseUrl);
            URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/ees/devices");
            uriBuilder.setParameter("availableOnly", String.valueOf(request.isAvailableOnly()));
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            this.logger.error(e.getMessage());
        }
        AuthenticationToken katOneToken = request.getKatOneToken();
        Map<String, String> headers = this.getTestcloudGenericHeader();
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        BearerAuthentication authentication = Authentication.BearerAuthentication((String)katOneToken.getAccessToken());
        headers.put("x-organization-id", request.getOrganizationId());
        headers.put("x-project-id", request.getProjectId());
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).authentication((Authentication)authentication).proxy(proxyConfig).build();
        HttpResponse response = null;
        try {
            response = this.httpClient.get(uri, httpOptions);
        }
        catch (HttpException e) {
            throw new NetworkErrorException((Throwable)e);
        }
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
        List devices = (List)this.objectMapper.readValue(response.getBody(), (TypeReference)new TypeReference<List<TestCloudDeviceDto>>(){});
        return devices.stream().map(d -> d.toDomainModel()).flatMap(Collection::stream).toList();
    }

    public List<TestCloudApplication> requestTestCloudApplications(String baseUrl, TestCloudApplicationRequest request) throws NetworkErrorException, MalformedContentException {
        String pageToken = this.PAGE_TOKEN;
        ArrayList<TestCloudApplicationDto> applications = new ArrayList<TestCloudApplicationDto>();
        ApplicationPage applicationPage = null;
        do {
            try {
                request.setPageToken(pageToken);
                request.setStatus("READY");
                applicationPage = this.getApplicationPage(baseUrl, request);
                if (applicationPage.getItems() != null) {
                    applications.addAll(applicationPage.getItems());
                }
                pageToken = applicationPage.getPageToken();
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        } while (Objects.nonNull(applicationPage) && applicationPage.getCount() == this.SIZE);
        return applications.stream().map(a -> a.toDomainModel()).collect(Collectors.toList());
    }

    private ApplicationPage getApplicationPage(String baseUrl, TestCloudApplicationRequest request) throws URISyntaxException, InvalidTokenException, HttpClientException, NetworkErrorException, MalformedContentException {
        String applicationId;
        String status;
        String platform;
        String projectId;
        URI uri = null;
        URI baseUri = new URI(baseUrl);
        URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/ees/apps");
        uriBuilder.setParameter("pageToken", request.getPageToken());
        uriBuilder.setParameter("size", String.valueOf(request.getSize() > 0 ? request.getSize() : this.SIZE));
        ArrayList<CallSite> queries = new ArrayList<CallSite>();
        String organizationId = request.getOrganizationId();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{organizationId})) {
            queries.add((CallSite)((Object)("organizationId==" + organizationId)));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{projectId = request.getProjectId()})) {
            queries.add((CallSite)((Object)("projectId==" + projectId)));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{platform = request.getPlatform()})) {
            queries.add((CallSite)((Object)("platform==" + platform)));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{status = request.getStatus()})) {
            queries.add((CallSite)((Object)("status==" + status.toUpperCase())));
        }
        if ((applicationId = request.getApplicationId()) != null) {
            queries.add((CallSite)((Object)("id==" + applicationId)));
        }
        uriBuilder.setParameter("q", String.join((CharSequence)";", queries));
        uri = uriBuilder.build();
        AuthenticationToken katOneToken = request.getKatOneToken();
        BearerAuthentication authentication = Authentication.BearerAuthentication((String)katOneToken.getAccessToken());
        Map<String, String> headers = this.getTestcloudGenericHeader();
        headers.put("x-organization-id", request.getOrganizationId());
        headers.put("x-project-id", request.getProjectId());
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).authentication((Authentication)authentication).proxy(proxyConfig).build();
        HttpResponse response = null;
        try {
            response = this.httpClient.get(uri, httpOptions);
        }
        catch (HttpException e) {
            throw new NetworkErrorException((Throwable)e);
        }
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
        return (ApplicationPage)response.json(ApplicationPage.class);
    }

    public String getTestCloudMobileRemoteServerUrl(String baseUrl, TestCloudRemoteServerUrlRequest request) throws URISyntaxException {
        try {
            URI baseUri = new URI(baseUrl);
            URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath(request.isSupportNewTestCloudHub() ? "wd/hub" : "/hub");
            AuthenticationToken katOneToken = request.getKatOneToken();
            uriBuilder.setUserInfo("token", katOneToken.getAccessToken());
            return uriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            this.logger.error(e.getMessage());
            return null;
        }
    }

    public TestCloudSessionTypes requestTestCloudSessionTypes(String baseUrl, TestCloudSessionTypeRequest request) throws TestCloudException, NetworkErrorException, URISyntaxException, MalformedContentException {
        URI uri = null;
        URI baseUri = new URI(baseUrl);
        URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/ees/test-session-types");
        uri = uriBuilder.build();
        Map<String, String> headers = this.getTestcloudGenericHeader();
        headers.put("x-organization-id", request.getOrganizationId());
        headers.put("x-project-id", request.getProjectId());
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        AuthenticationToken katOneToken = request.getKatOneToken();
        BearerAuthentication authentication = Authentication.BearerAuthentication((String)katOneToken.getAccessToken());
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).authentication((Authentication)authentication).proxy(proxyConfig).build();
        HttpResponse response = null;
        try {
            response = this.httpClient.get(uri, httpOptions);
        }
        catch (HttpException e) {
            throw new NetworkErrorException((Throwable)e);
        }
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
        return (TestCloudSessionTypes)response.json(TestCloudSessionTypes.class);
    }

    public TestCloudApplication requestTestCloudApplication(String baseUrl, TestCloudApplicationRequest request) throws NetworkErrorException, MalformedContentException {
        String pageToken = this.PAGE_TOKEN;
        ArrayList<TestCloudApplicationDto> applications = new ArrayList<TestCloudApplicationDto>();
        ApplicationPage applicationPage = null;
        try {
            request.setPageToken(pageToken);
            request.setStatus("READY");
            request.setSize(this.SIZE);
            applicationPage = this.getApplicationPage(baseUrl, request);
            applications.addAll(applicationPage.getItems());
            pageToken = applicationPage.getPageToken();
        }
        catch (HttpClientException | InvalidTokenException | URISyntaxException e) {
            this.logger.error(e.getMessage());
        }
        if (!applications.isEmpty()) {
            return ((TestCloudApplicationDto)applications.get(0)).toDomainModel();
        }
        return null;
    }

    private void handleError(int statusCode, String responseBody) throws NetworkErrorException {
        throw new NetworkErrorException(responseBody);
    }

    private void handleServerError(int statusCode, String responseBody) throws NetworkErrorException {
        throw new NetworkErrorException(responseBody);
    }

    public TestCloudConfiguration[] getConfigurations(String baseUrl, AuthenticationToken katOneToken, Long organizationId, Long projectId) throws NetworkErrorException, JsonProcessingException {
        URI uri = null;
        try {
            URI baseUri = new URI(baseUrl);
            URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/configurations");
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            this.logger.error(e.getMessage());
        }
        Map<String, String> headers = this.getTestcloudGenericHeader();
        headers.put("x-organization-id", Long.toString(organizationId));
        if (projectId != null) {
            headers.put("x-project-id", Long.toString(projectId));
        }
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        BearerAuthentication authentication = Authentication.BearerAuthentication((String)katOneToken.getAccessToken());
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).authentication((Authentication)authentication).proxy(proxyConfig).build();
        HttpResponse response = null;
        try {
            response = this.httpClient.get(uri, httpOptions);
        }
        catch (HttpException e) {
            throw new NetworkErrorException((Throwable)e);
        }
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
        List configurations = (List)this.objectMapper.readValue(response.getBody(), (TypeReference)new TypeReference<List<TestCloudConfiguration>>(){});
        return (TestCloudConfiguration[])configurations.toArray(TestCloudConfiguration[]::new);
    }

    public TestCloudEnvironment[] getEnvironments(String baseUrl, AuthenticationToken katOneToken, Long organizationId, Long projectId) throws NetworkErrorException, JsonProcessingException {
        URI uri = null;
        try {
            URI baseUri = new URI(baseUrl);
            URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/test-cloud-environments");
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            this.logger.error(e.getMessage());
        }
        Map<String, String> headers = this.getTestcloudGenericHeader();
        headers.put("x-organization-id", Long.toString(organizationId));
        if (projectId != null) {
            headers.put("x-project-id", Long.toString(projectId));
        }
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        BearerAuthentication authentication = Authentication.BearerAuthentication((String)katOneToken.getAccessToken());
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).authentication((Authentication)authentication).proxy(proxyConfig).build();
        HttpResponse response = null;
        try {
            response = this.httpClient.get(uri, httpOptions);
        }
        catch (HttpException e) {
            throw new NetworkErrorException((Throwable)e);
        }
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
        List environments = (List)this.objectMapper.readValue(response.getBody(), (TypeReference)new TypeReference<List<TestCloudEnvironment>>(){});
        return (TestCloudEnvironment[])environments.toArray(TestCloudEnvironment[]::new);
    }

    public APITestCloudMobileDevice[] getAvailableMobileDevices(String baseUrl, AuthenticationToken katOneToken, Long organizationId, Long projectId) throws JsonMappingException, JsonProcessingException, NetworkErrorException {
        URI uri = null;
        try {
            URI baseUri = new URI(baseUrl);
            URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/ees/devices");
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            this.logger.error(e.getMessage());
        }
        Map<String, String> headers = this.getTestcloudGenericHeader();
        if (Objects.nonNull(organizationId)) {
            headers.put("x-organization-id", organizationId.toString());
            headers.put("x-project-id", Long.toString(projectId));
        }
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        BearerAuthentication authentication = Authentication.BearerAuthentication((String)katOneToken.getAccessToken());
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).authentication((Authentication)authentication).proxy(proxyConfig).build();
        HttpResponse response = null;
        try {
            response = this.httpClient.get(uri, httpOptions);
        }
        catch (HttpException e) {
            throw new NetworkErrorException((Throwable)e);
        }
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
        List devices = (List)this.objectMapper.readValue(response.getBody(), (TypeReference)new TypeReference<List<APITestCloudMobileDevice>>(){});
        return (APITestCloudMobileDevice[])devices.toArray(APITestCloudMobileDevice[]::new);
    }

    public TestCloudTunnel[] getTunnels(String baseUrl, AuthenticationToken katOneToken, Long organizationId, Long projectId) throws NetworkErrorException, JsonMappingException, JsonProcessingException, URISyntaxException {
        String username = null;
        KatOneJwtToken jwtToken = KatOneJwtToken.parseToken((String)katOneToken.getAccessToken());
        if (Objects.nonNull(jwtToken)) {
            username = jwtToken.getEmail();
        }
        URI baseUri = new URI(baseUrl);
        URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setParameter("username", username).setParameter("organizationId", Objects.nonNull(organizationId) ? organizationId.toString() : "").setPath("/tunnel-metadata");
        URI uri = uriBuilder.build();
        Map<String, String> headers = this.getTestcloudGenericHeader();
        headers.put("x-organization-id", Long.toString(organizationId));
        headers.put("x-project-id", Long.toString(projectId));
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        BearerAuthentication authentication = Authentication.BearerAuthentication((String)katOneToken.getAccessToken());
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).authentication((Authentication)authentication).proxy(proxyConfig).build();
        HttpResponse response = null;
        try {
            response = this.httpClient.get(uri, httpOptions);
        }
        catch (HttpException e) {
            throw new NetworkErrorException((Throwable)e);
        }
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
        List devices = (List)this.objectMapper.readValue(response.getBody(), (TypeReference)new TypeReference<List<TestCloudTunnel>>(){});
        return (TestCloudTunnel[])devices.toArray(TestCloudTunnel[]::new);
    }

    public TestCloudUsage getUsage(AuthenticationToken katOneToken, Long organizationId, Long projectId) throws NetworkErrorException, JsonMappingException, JsonProcessingException, URISyntaxException {
        URI baseUri = new URI(this.discoveryService.getServerUrl(ServerType.PLATFORM));
        URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath(String.format("/v1/admin/testcloud-usage/latest/%d", organizationId));
        URI uri = uriBuilder.build();
        Map<String, String> headers = this.getTestcloudGenericHeader();
        headers.put("x-organization-id", Long.toString(organizationId));
        headers.put("x-project-id", Long.toString(projectId));
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        BearerAuthentication authentication = Authentication.BearerAuthentication((String)katOneToken.getAccessToken());
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).authentication((Authentication)authentication).proxy(proxyConfig).build();
        HttpResponse response = null;
        try {
            response = this.httpClient.get(uri, httpOptions);
        }
        catch (HttpException e) {
            throw new NetworkErrorException((Throwable)e);
        }
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
        return (TestCloudUsage)this.objectMapper.readValue(response.getBody(), TestCloudUsage.class);
    }

    public TestCloudExecutionSessionResponse getExecutionSession(String baseUrl, String executionSessionId, AuthenticationToken katOneToken, Long organizationId, Long projectId) throws NetworkErrorException, JsonProcessingException, URISyntaxException {
        URI uri = null;
        URI baseUri = new URI(baseUrl);
        URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/ees/sessions/" + executionSessionId);
        uri = uriBuilder.build();
        Map<String, String> headers = this.getTestcloudGenericHeader();
        headers.put("x-organization-id", Long.toString(organizationId));
        headers.put("x-project-id", Long.toString(projectId));
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        BearerAuthentication authentication = Authentication.BearerAuthentication((String)katOneToken.getAccessToken());
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).authentication((Authentication)authentication).proxy(proxyConfig).build();
        HttpResponse response = null;
        try {
            response = this.httpClient.get(uri, httpOptions);
        }
        catch (HttpException e) {
            throw new NetworkErrorException((Throwable)e);
        }
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
        return (TestCloudExecutionSessionResponse)this.objectMapper.readValue(response.getBody(), TestCloudExecutionSessionResponse.class);
    }
}

