/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.testops.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.core.util.JsonBuilder;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryService;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.network.core.model.Authentication;
import com.kms.katalon.network.core.model.BearerAuthentication;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.model.exception.MalformedContentException;
import com.kms.katalon.network.core.model.exception.NetworkErrorException;
import com.kms.katalon.network.core.services.IDownloadProgress;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.session.core.model.Account;
import com.kms.katalon.session.core.model.AdministrationManagedKsSetting;
import com.kms.katalon.session.core.model.AiConfigPolicy;
import com.kms.katalon.session.core.model.AiConfigPolicyType;
import com.kms.katalon.session.core.model.AuthenticationToken;
import com.kms.katalon.session.core.model.License;
import com.kms.katalon.session.core.model.OrganizationSetting;
import com.kms.katalon.session.core.model.Session;
import com.kms.katalon.session.core.services.ISessionManager;
import com.kms.katalon.testops.core.model.AnalyticsApiKey;
import com.kms.katalon.testops.core.model.AnalyticsExecution;
import com.kms.katalon.testops.core.model.AnalyticsExecutionStage;
import com.kms.katalon.testops.core.model.AnalyticsFileInfo;
import com.kms.katalon.testops.core.model.AnalyticsPlan;
import com.kms.katalon.testops.core.model.AnalyticsProject;
import com.kms.katalon.testops.core.model.AnalyticsRelease;
import com.kms.katalon.testops.core.model.AnalyticsTestCase;
import com.kms.katalon.testops.core.model.AnalyticsTestRun;
import com.kms.katalon.testops.core.model.AnalyticsTracking;
import com.kms.katalon.testops.core.model.AnalyticsUploadInfo;
import com.kms.katalon.testops.core.model.TestOpsProjectStatistics;
import com.kms.katalon.testops.core.model.TestOpsRequestOptions;
import com.kms.katalon.testops.core.model.TestOpsTotalExecutionStatistics;
import com.kms.katalon.testops.core.model.exception.AnalyticsApiException;
import com.kms.katalon.testops.core.model.exception.TestOpsException;
import com.kms.katalon.testops.core.services.ITestOpsService;
import com.kms.katalon.testops.dto.AdministrationManagedAiConfigResponseDto;
import com.kms.katalon.testops.dto.AdministrationManagedAiProviderConfigDto;
import com.kms.katalon.testops.dto.AdministrationManagedAiProviderDto;
import com.kms.katalon.testops.dto.AdministrationManagedAppSettingResponseDto;
import com.kms.katalon.testops.dto.AdministrationManagedAzureOpenAiConfigResponseDto;
import com.kms.katalon.testops.dto.AdministrationManagedGeminiConfigResponseDto;
import com.kms.katalon.testops.dto.AdministrationManagedOpenAiCompatibleConfigResponseDto;
import com.kms.katalon.testops.dto.AdministrationManagedOpenAiConfigResponseDto;
import com.kms.katalon.testops.dto.AnalyticsExecutionPage;
import com.kms.katalon.testops.dto.AnalyticsOrganizationPage;
import com.kms.katalon.testops.dto.AnalyticsPage;
import com.kms.katalon.testops.dto.AnalyticsPlanPage;
import com.kms.katalon.testops.dto.AnalyticsReleasePage;
import com.kms.katalon.testops.dto.OrganizationSettingDto;
import com.kms.katalon.testops.dto.TestCaseIdentity;
import com.kms.katalon.testops.dto.TestOpsProjectStatisticsPage;
import com.kms.katalon.testops.mapper.AdministrationManagedKsSettingMapper;
import com.kms.katalon.util.RetryController;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class TestOpsService
implements ITestOpsService {
    public static final int DEFAULT_RETRY_TIMES = 3;
    public static final String SIZE_OF_EACH_PAGE = "30";
    private static final long DEFAULT_WAIT_TIME = 3L;
    private static final String X_ACCOUNT_ID = "X-Account-Id";
    private static final String X_LICENSE_KEY = "x-license-key";
    private static final String KS_VERSION = "X-KS-Version";
    @Inject
    private IDiscoveryService discoveryService;
    @Inject
    private IHttpClient httpClient;
    @Inject
    private INetworkPreferences networkPreferences;
    @Inject
    private ISessionManager sessionManager;
    private static final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new SimpleModule().addDeserializer(AnalyticsExecutionStage.class, (JsonDeserializer)new AnalyticsExecutionStage.Deserializer()));

    public RequestConfig addRequestTimeout() {
        int CONNECTION_TIMEOUT_MS = 15000;
        return RequestConfig.custom().setConnectionRequestTimeout(CONNECTION_TIMEOUT_MS).setConnectTimeout(CONNECTION_TIMEOUT_MS).setSocketTimeout(CONNECTION_TIMEOUT_MS).build();
    }

    public File downloadReport(Long executionId, IDownloadProgress progress, TestOpsRequestOptions options) throws AnalyticsApiException {
        AuthenticationToken token = options.getSession().getToken();
        String serverUrl = options.getServerUrl();
        try {
            URI baseUri = new URI(serverUrl);
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath(String.format("/api/v1/executions/%d/download-file", executionId)).build();
            BearerAuthentication authentication = new BearerAuthentication(token.getAccessToken());
            ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
            HttpOptions httpOptions = new HttpOptions.Builder().headers(new HashMap()).authentication((Authentication)authentication).proxy(proxyConfig).build();
            File file = File.createTempFile("katalon_tmp_report", ".zip");
            FileOutputStream outputStream = new FileOutputStream(file);
            this.httpClient.download(uri, (OutputStream)outputStream, httpOptions, progress);
            return file;
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            throw AnalyticsApiException.wrap((Exception)e);
        }
    }

    public String extractErrorMessage(String responseBody) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode rootNode = objectMapper.readTree(responseBody);
            String message = rootNode.path("message").asText(null);
            if (message != null) {
                return message;
            }
            message = rootNode.path("error_description").asText(null);
            if (message != null) {
                return message;
            }
            return responseBody;
        }
        catch (Exception exception) {
            return responseBody;
        }
    }

    public String fetchAPIKey(TestOpsRequestOptions options) throws AnalyticsApiException {
        List<AnalyticsApiKey> apiKeys = this.fetchApiKeys(options);
        String firstAPIKey = apiKeys.isEmpty() ? null : apiKeys.get(0).getKey();
        return firstAPIKey;
    }

    public List<AnalyticsApiKey> fetchApiKeys(TestOpsRequestOptions options) throws AnalyticsApiException {
        AuthenticationToken token = options.getSession().getToken();
        String serverUrl = options.getServerUrl();
        try {
            String query = JsonBuilder.object().property("type", (Object)"ApiKey").array("conditions", new Object[0]).array("functions", new Object[0]).object("pagination", ObjectBuilder2 -> ObjectBuilder2.property("page", (Object)0).property("size", (Object)1).array("sorts", new Object[]{"createdAt,asc"})).array("groupBys", new Object[0]).toJson();
            URI baseUri = new URI(serverUrl);
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/api/v1/search").setParameter("q", query).build();
            HttpResponse response = this.sendGetRequest(uri, token);
            AnalyticsPage result = (AnalyticsPage)response.json((TypeReference)new TypeReference<AnalyticsPage<AnalyticsApiKey>>(){});
            return result.getContent();
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap((Exception)e);
        }
    }

    public List<AnalyticsExecution> getCompletedExecutions(Long projectId, int size, TestOpsRequestOptions options) throws AnalyticsApiException {
        try {
            String query = JsonBuilder.object().property("type", (Object)"Execution").array("conditions", ArrayBuilder2 -> {
                ArrayBuilder2.push(new Object[]{JsonBuilder.object().property("key", (Object)"Project.id").property("operator", (Object)"=").property("value", (Object)String.valueOf(projectId)).build()});
                ArrayBuilder2.push(new Object[]{JsonBuilder.object().property("key", (Object)"executionStage").property("operator", (Object)"=").property("value", (Object)"COMPLETED").build()});
                ArrayBuilder2.push(new Object[]{JsonBuilder.object().property("key", (Object)"status").property("operator", (Object)"!=").property("value", (Object)"INCOMPLETE").build()});
            }).object("pagination", ObjectBuilder2 -> ObjectBuilder2.property("page", (Object)0).property("size", (Object)size).array("sorts", new Object[]{"order,desc"})).toJson();
            AuthenticationToken token = options.getSession().getToken();
            String serverUrl = options.getServerUrl();
            URI baseUri = new URI(serverUrl);
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/api/v1/search").setParameter("q", query).build();
            HttpResponse response = this.sendGetRequest(uri, token);
            AnalyticsExecutionPage result = (AnalyticsExecutionPage)response.json(AnalyticsExecutionPage.class, mapper);
            return Arrays.asList(result.getContent());
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap((Exception)e);
        }
    }

    public List<AnalyticsExecution> getCompletedExecutionTestSuite(Long projectId, String testSuitePath, String testSuiteName, int size, TestOpsRequestOptions options) throws AnalyticsApiException {
        try {
            String query = JsonBuilder.object().property("type", (Object)"ExecutionWithoutTestSuiteCollection").array("conditions", ArrayBuilder2 -> {
                ArrayBuilder2.push(new Object[]{JsonBuilder.object().property("key", (Object)"Project.id").property("operator", (Object)"=").property("value", (Object)String.valueOf(projectId)).build()});
                ArrayBuilder2.push(new Object[]{JsonBuilder.object().property("key", (Object)"TestSuite.path").property("operator", (Object)"=").property("value", (Object)testSuitePath).build()});
                ArrayBuilder2.push(new Object[]{JsonBuilder.object().property("key", (Object)"TestSuite.name").property("operator", (Object)"=").property("value", (Object)testSuiteName).build()});
                ArrayBuilder2.push(new Object[]{JsonBuilder.object().property("key", (Object)"TestSuite.type").property("operator", (Object)"=").property("value", (Object)"KATALON_STUDIO").build()});
                ArrayBuilder2.push(new Object[]{JsonBuilder.object().property("key", (Object)"executionStage").property("operator", (Object)"=").property("value", (Object)"COMPLETED").build()});
                ArrayBuilder2.push(new Object[]{JsonBuilder.object().property("key", (Object)"status").property("operator", (Object)"!=").property("value", (Object)"INCOMPLETE").build()});
            }).object("pagination", ObjectBuilder2 -> ObjectBuilder2.property("page", (Object)0).property("size", (Object)Integer.valueOf(SIZE_OF_EACH_PAGE)).array("sorts", new Object[]{"id,desc"})).toJson();
            AuthenticationToken token = options.getSession().getToken();
            String serverUrl = options.getServerUrl();
            URI baseUri = new URI(serverUrl);
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/api/v1/search").setParameter("q", query).build();
            HttpResponse response = this.sendGetRequest(uri, token);
            AnalyticsExecutionPage result = (AnalyticsExecutionPage)response.json(AnalyticsExecutionPage.class, mapper);
            return Arrays.asList(result.getContent());
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap((Exception)e);
        }
    }

    public List<AnalyticsExecution> getExecutions(Long projectId, TestOpsRequestOptions options) throws AnalyticsApiException {
        try {
            AnalyticsExecutionPage response = this.getExecutionPage(projectId, 0, options);
            ArrayList<AnalyticsExecution> executions = new ArrayList<AnalyticsExecution>();
            if (!response.isEmpty()) {
                executions.addAll(Arrays.asList(response.getContent()));
            }
            return executions.stream().filter(e -> e.getExecutionStage() != AnalyticsExecutionStage.RUNNING).collect(Collectors.toList());
        }
        catch (Exception e2) {
            throw AnalyticsApiException.wrap((Exception)e2);
        }
    }

    public List<AnalyticsRelease> getFirstReleasesPage(Long projectId, TestOpsRequestOptions options) throws AnalyticsApiException {
        try {
            AnalyticsReleasePage response = this.getReleasePage(projectId, 0, false, options);
            return Arrays.asList(response.getContent());
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap((Exception)e);
        }
    }

    public List<AnalyticsUploadInfo> getMultipleUploadInfo(Long projectId, Long numberUploadInfo, TestOpsRequestOptions options) throws AnalyticsApiException {
        AuthenticationToken token = options.getSession().getToken();
        String serverUrl = options.getServerUrl();
        try {
            URI baseUri = new URI(serverUrl);
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/api/v1/files/upload-urls").setParameter("projectId", String.valueOf(projectId)).setParameter("numberUrl", String.valueOf(numberUploadInfo)).build();
            HttpResponse response = this.sendGetRequest(uri, token);
            return (List)response.json((TypeReference)new TypeReference<ArrayList<AnalyticsUploadInfo>>(){});
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            throw AnalyticsApiException.wrap((Exception)e);
        }
    }

    public OrganizationSetting getOrganizationSetting(Long organizationId, TestOpsRequestOptions options) throws TestOpsException, URISyntaxException, HttpException {
        AuthenticationToken token = options.getSession().getToken();
        String serverUrl = options.getServerUrl();
        URI baseUri = new URI(serverUrl);
        URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/api/v1/organizations/setting").addParameter("organizationId", Long.toString(organizationId)).build();
        HttpResponse response = this.sendGetRequest(uri, token);
        OrganizationSettingDto organizationSettingDto = (OrganizationSettingDto)response.json(OrganizationSettingDto.class);
        return organizationSettingDto.toDomainModel();
    }

    public List<AnalyticsPlan> getPlans(Long projectId, TestOpsRequestOptions options) throws AnalyticsApiException {
        try {
            String query = JsonBuilder.object().property("type", (Object)"RunConfiguration").array("groupBys", new Object[0]).array("conditions", ArrayBuilder2 -> ArrayBuilder2.push(new Object[]{JsonBuilder.object().property("key", (Object)"Project.id").property("operator", (Object)"=").property("value", (Object)String.valueOf(projectId)).build()})).array("functions", new Object[0]).object("pagination", ObjectBuilder2 -> ObjectBuilder2.property("page", (Object)0).property("size", (Object)Integer.valueOf(SIZE_OF_EACH_PAGE)).array("sorts", new Object[]{"name,asc"})).toJson();
            AuthenticationToken token = options.getSession().getToken();
            String serverUrl = options.getServerUrl();
            URI baseUri = new URI(serverUrl);
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/api/v1/search").setParameter("q", query).build();
            HttpResponse response = this.sendGetRequest(uri, token);
            AnalyticsPlanPage result = (AnalyticsPlanPage)response.json(AnalyticsPlanPage.class);
            return Arrays.asList(result.getContent());
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap((Exception)e);
        }
    }

    public List<AnalyticsProject> getProjects(TestOpsRequestOptions options) throws AnalyticsApiException {
        AuthenticationToken token = options.getSession().getToken();
        String serverUrl = options.getServerUrl();
        try {
            URI baseUri = new URI(serverUrl);
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/api/v1/users/me").build();
            HttpResponse response = this.sendGetRequest(uri, token);
            AnalyticsOrganizationPage organizationPage = (AnalyticsOrganizationPage)response.json(AnalyticsOrganizationPage.class);
            return organizationPage.getProjects();
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap((Exception)e);
        }
    }

    public TestOpsProjectStatistics getProjectStatisticsInLast7Days(Long projectId, TestOpsRequestOptions options) throws AnalyticsApiException {
        try {
            ZonedDateTime today = ZonedDateTime.now();
            ZonedDateTime last7Days = today.minusDays(6L);
            ZonedDateTime startTime = last7Days.with(LocalTime.of(0, 0, 0));
            ZonedDateTime endTime = today.with(LocalTime.of(23, 59, 59));
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssxxx");
            String startTimeString = startTime.format(formatter);
            String endTimeString = endTime.format(formatter);
            String query = JsonBuilder.object().property("type", (Object)"ProjectStatisticsCustomizeTime").array("conditions", ArrayBuilder2 -> {
                ArrayBuilder2.push(new Object[]{JsonBuilder.object().property("key", (Object)"Project.id").property("operator", (Object)"=").property("value", (Object)String.valueOf(projectId)).build()});
                ArrayBuilder2.push(new Object[]{JsonBuilder.object().property("key", (Object)"startTime").property("operator", (Object)">=").property("value", (Object)startTimeString).build()});
                ArrayBuilder2.push(new Object[]{JsonBuilder.object().property("key", (Object)"startTime").property("operator", (Object)"<=").property("value", (Object)endTimeString).build()});
            }).object("pagination", ObjectBuilder2 -> ObjectBuilder2.property("page", (Object)0).property("size", (Object)Integer.valueOf(SIZE_OF_EACH_PAGE)).array("sorts", new Object[]{"name,asc"})).toJson();
            AuthenticationToken token = options.getSession().getToken();
            String serverUrl = options.getServerUrl();
            URI baseUri = new URI(serverUrl);
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/api/v1/search").setParameter("q", query).build();
            HttpResponse response = this.sendGetRequest(uri, token);
            TestOpsProjectStatisticsPage result = (TestOpsProjectStatisticsPage)response.json(TestOpsProjectStatisticsPage.class);
            return Arrays.asList(result.getContent()).get(0);
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap((Exception)e);
        }
    }

    public List<AnalyticsRelease> getReleases(Long projectId, TestOpsRequestOptions options) throws AnalyticsApiException {
        try {
            AnalyticsReleasePage response = this.getReleasePage(projectId, 0, true, options);
            ArrayList<AnalyticsRelease> releases = new ArrayList<AnalyticsRelease>();
            if (!response.isEmpty()) {
                releases.addAll(Arrays.asList(response.getContent()));
            }
            while (!response.isEmpty() && !response.isLast()) {
                response = this.getReleasePage(projectId, response.getPageable().getPageNumber() + 1, true, options);
                releases.addAll(Arrays.asList(response.getContent()));
            }
            return releases;
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap((Exception)e);
        }
    }

    public List<AnalyticsTestCase> getTestCaseRuns(Long projectId, List<String> testCaseIds, TestOpsRequestOptions options) throws AnalyticsApiException {
        AuthenticationToken token = options.getSession().getToken();
        String serverUrl = options.getServerUrl();
        try {
            URI baseUri = new URI(serverUrl);
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/api/v1/test-cases/statistics").build();
            ArrayList<TestCaseIdentity.IdentityResource> identityResources = new ArrayList<TestCaseIdentity.IdentityResource>();
            int numberOfTestCaseIds = 0;
            for (String str : testCaseIds) {
                if (numberOfTestCaseIds > 29) break;
                String[] arr = str.split("/");
                if (arr.length < 2) continue;
                String name = arr[arr.length - 1];
                String path = str.substring(0, str.lastIndexOf(47));
                TestCaseIdentity.IdentityResource identityResource = new TestCaseIdentity.IdentityResource();
                identityResource.setName(name);
                identityResource.setPath(path);
                identityResources.add(identityResource);
                ++numberOfTestCaseIds;
            }
            TestCaseIdentity testCaseIdentity = new TestCaseIdentity();
            testCaseIdentity.setProjectId(projectId);
            testCaseIdentity.setIdentityResources(identityResources);
            HttpResponse response = this.sendPostRequest(uri, token, (HttpEntity)this.asBodyEntity(testCaseIdentity));
            return (List)response.json((TypeReference)new TypeReference<List<AnalyticsTestCase>>(){});
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap((Exception)e);
        }
    }

    public TestOpsTotalExecutionStatistics getTotalExecutionsStatistics(Long projectId, TestOpsRequestOptions options) throws AnalyticsApiException {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssxxx");
            AuthenticationToken token = options.getSession().getToken();
            String serverUrl = options.getServerUrl();
            URI baseUri = new URI(serverUrl);
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/api/v1/total-execution-comparison").setParameter("projectId", String.valueOf(projectId)).setParameter("timeString", ZonedDateTime.now().format(formatter)).build();
            HttpResponse response = this.sendGetRequest(uri, token);
            return (TestOpsTotalExecutionStatistics)response.json(TestOpsTotalExecutionStatistics.class);
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap((Exception)e);
        }
    }

    public List<AnalyticsExecution> sendLog(Long projectId, Long timestamp, String folderName, File file, boolean isEnd, TestOpsRequestOptions options) throws AnalyticsApiException {
        AuthenticationToken token = options.getSession().getToken();
        String serverUrl = options.getServerUrl();
        try {
            URI baseUri = new URI(serverUrl);
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/api/v1/katalon-test-reports").build();
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.addPart("projectId", (ContentBody)new StringBody(String.valueOf(projectId), ContentType.MULTIPART_FORM_DATA));
            builder.addPart("batch", (ContentBody)new StringBody(String.valueOf(timestamp), ContentType.MULTIPART_FORM_DATA));
            builder.addPart("folderPath", (ContentBody)new StringBody(folderName, ContentType.MULTIPART_FORM_DATA));
            builder.addPart("isEnd", (ContentBody)new StringBody("" + isEnd, ContentType.MULTIPART_FORM_DATA));
            builder.addPart("file", (ContentBody)new FileBody(file, ContentType.DEFAULT_BINARY));
            HttpEntity entity = builder.build();
            HttpResponse response = this.sendPostRequest(uri, token, entity);
            return (List)response.json((TypeReference)new TypeReference<ArrayList<AnalyticsExecution>>(){});
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap((Exception)e);
        }
    }

    public void sendTrackingActivity(AnalyticsTracking trackingInfo, TestOpsRequestOptions options) throws AnalyticsApiException {
        AuthenticationToken token = options.getSession().getToken();
        String serverUrl = options.getServerUrl();
        try {
            URI baseUri = new URI(serverUrl);
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/api/v1/tracking").build();
            Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create();
            this.sendPostRequest(uri, token, (HttpEntity)new StringEntity(gson.toJson((Object)trackingInfo), StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap((Exception)e);
        }
    }

    public void updateTestRunResult(Long projectId, AnalyticsTestRun testRun, TestOpsRequestOptions options) throws AnalyticsApiException {
        AuthenticationToken token = options.getSession().getToken();
        String serverUrl = options.getServerUrl();
        try {
            URI baseUri = new URI(serverUrl);
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/api/v1/katalon/test-reports/update-result").setParameter("projectId", String.valueOf(projectId)).build();
            this.sendPostRequest(uri, token, (HttpEntity)this.asBodyEntity(testRun));
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap((Exception)e);
        }
    }

    public void uploadFile(String url, File file, TestOpsRequestOptions options) throws AnalyticsApiException {
        AuthenticationToken token = options != null && options.getSession() != null ? options.getSession().getToken() : null;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileInputStream inputStream = new FileInputStream(file);){
                InputStreamEntity entity = new InputStreamEntity((InputStream)inputStream, file.length());
                this.sendPutRequest(new URI(url), token, (HttpEntity)entity);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (HttpException | IOException | URISyntaxException error) {
            throw AnalyticsApiException.wrap((Exception)error);
        }
    }

    public void uploadFileWithRetry(String url, File file) throws AnalyticsApiException {
        RetryController retryController = new RetryController();
        retryController.setMaxRetries(3);
        retryController.setDelay(3L);
        retryController.execute(currentRetries -> {
            block4: {
                if (currentRetries > 0) {
                    LogUtil.printOutputLine((String)MessageFormat.format("TestOps: Retry uploading file \"{0}\" ({1}/{2})", file.getAbsolutePath(), currentRetries, retryController.getMaxRetries()));
                }
                try {
                    this.uploadFile(url, file, null);
                    retryController.setLastError(null);
                }
                catch (AnalyticsApiException error) {
                    retryController.setLastError((Throwable)error);
                    String details = "";
                    boolean shouldRetry = false;
                    Throwable rootCause = error.getCause();
                    if (rootCause instanceof HttpException) {
                        HttpException httpError = (HttpException)error.getCause();
                        int statusCode = httpError.getStatusCode();
                        shouldRetry = statusCode >= 500 && statusCode < 600 || rootCause instanceof NetworkErrorException;
                        details = MessageFormat.format(" (Status Code: {0})", statusCode);
                    }
                    LogUtil.printAndLogError((Throwable)error, (String)MessageFormat.format("TestOps: Error uploading file \"{0}\"{1}", file.getAbsolutePath(), details));
                    if (!shouldRetry) break block4;
                    return false;
                }
            }
            return true;
        });
        if (retryController.getLastError() != null) {
            throw (AnalyticsApiException)retryController.getLastError();
        }
    }

    public List<AnalyticsExecution> uploadMultipleFileInfo(Long projectId, Long batchId, List<AnalyticsFileInfo> fileInfoList, TestOpsRequestOptions options) throws AnalyticsApiException {
        AuthenticationToken token = options.getSession().getToken();
        String serverUrl = options.getServerUrl();
        try {
            URI baseUri = new URI(serverUrl);
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/api/v1/katalon/test-reports/multiple").setParameter("projectId", String.valueOf(projectId)).setParameter("batch", String.valueOf(batchId)).build();
            HttpResponse response = this.sendPostRequest(uri, token, (HttpEntity)this.asBodyEntity(fileInfoList));
            return (List)response.json((TypeReference)new TypeReference<ArrayList<AnalyticsExecution>>(){});
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            throw AnalyticsApiException.wrap((Exception)e);
        }
    }

    private AnalyticsExecutionPage getExecutionPage(Long projectId, Integer page, TestOpsRequestOptions options) throws Exception {
        String query = JsonBuilder.object().property("type", (Object)"Execution").array("conditions", ArrayBuilder2 -> ArrayBuilder2.push(new Object[]{JsonBuilder.object().property("key", (Object)"Project.id").property("operator", (Object)"=").property("value", (Object)String.valueOf(projectId)).build()})).object("pagination", ObjectBuilder2 -> ObjectBuilder2.property("page", (Object)page).property("size", (Object)Integer.valueOf(SIZE_OF_EACH_PAGE)).array("sorts", new Object[]{"order,desc"})).toJson();
        AuthenticationToken token = options.getSession().getToken();
        String serverUrl = options.getServerUrl();
        URI baseUri = new URI(serverUrl);
        URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/api/v1/search").setParameter("q", query).build();
        HttpResponse response = this.sendGetRequest(uri, token);
        return (AnalyticsExecutionPage)response.json(AnalyticsExecutionPage.class, mapper);
    }

    private AnalyticsReleasePage getReleasePage(Long projectId, Integer page, boolean activeOnly, TestOpsRequestOptions options) throws Exception {
        try {
            String query = JsonBuilder.object().property("type", (Object)"Release").array("groupBys", new Object[0]).array("conditions", ArrayBuilder2 -> {
                ArrayBuilder2.push(new Object[]{JsonBuilder.object().property("key", (Object)"Project.id").property("operator", (Object)"=").property("value", (Object)String.valueOf(projectId)).build()});
                if (activeOnly) {
                    ArrayBuilder2.push(new Object[]{JsonBuilder.object().property("key", (Object)"closed").property("operator", (Object)"=").property("value", (Object)"false").build()});
                }
            }).array("functions", new Object[0]).object("pagination", ObjectBuilder2 -> ObjectBuilder2.property("page", (Object)page).property("size", (Object)Integer.valueOf(SIZE_OF_EACH_PAGE)).array("sorts", new Object[]{"closed,asc", "name,asc"})).toJson();
            AuthenticationToken token = options.getSession().getToken();
            String serverUrl = options.getServerUrl();
            URI baseUri = new URI(serverUrl);
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/api/v1/search").setParameter("q", query).build();
            HttpResponse response = this.sendGetRequest(uri, token);
            return (AnalyticsReleasePage)response.json(AnalyticsReleasePage.class);
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap((Exception)e);
        }
    }

    private void handleError(int statusCode, String responseBody) throws NetworkErrorException {
        throw new NetworkErrorException(this.extractErrorMessage(responseBody), statusCode);
    }

    private void handleServerError(int statusCode, String responseBody) throws NetworkErrorException {
        throw new NetworkErrorException(this.extractErrorMessage(responseBody), statusCode);
    }

    private HttpResponse sendGetRequest(URI uri, AuthenticationToken token) throws HttpException {
        HttpResponse response;
        int statusCode;
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions.Builder httpOptionsBuilder = new HttpOptions.Builder().headers(new HashMap()).proxy(proxyConfig);
        if (Objects.nonNull(token)) {
            BearerAuthentication authentication = new BearerAuthentication(token.getAccessToken());
            httpOptionsBuilder.authentication((Authentication)authentication);
        }
        if ((statusCode = (response = this.httpClient.get(uri, httpOptionsBuilder.build())).getStatusCode()) >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
        return response;
    }

    private HttpResponse sendPostRequest(URI uri, AuthenticationToken token, HttpEntity entity) throws HttpException {
        HttpOptions httpOptions;
        HttpResponse response;
        int statusCode;
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions.Builder httpOptionsBuilder = new HttpOptions.Builder().headers(new HashMap()).proxy(proxyConfig);
        if (Objects.nonNull(token)) {
            BearerAuthentication authentication = new BearerAuthentication(token.getAccessToken());
            httpOptionsBuilder.authentication((Authentication)authentication);
        }
        if ((statusCode = (response = this.httpClient.post(uri, entity, httpOptions = httpOptionsBuilder.build())).getStatusCode()) >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
        return response;
    }

    private HttpResponse sendPutRequest(URI uri, AuthenticationToken token, HttpEntity entity) throws HttpException {
        HttpOptions httpOptions;
        HttpResponse response;
        int statusCode;
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions.Builder httpOptionsBuilder = new HttpOptions.Builder().headers(new HashMap()).proxy(proxyConfig);
        if (Objects.nonNull(token)) {
            BearerAuthentication authentication = new BearerAuthentication(token.getAccessToken());
            httpOptionsBuilder.authentication((Authentication)authentication);
        }
        if ((statusCode = (response = this.httpClient.put(uri, entity, httpOptions = httpOptionsBuilder.build())).getStatusCode()) >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
        return response;
    }

    protected ByteArrayEntity asBodyEntity(Object data) {
        Gson gson = new GsonBuilder().create();
        return new ByteArrayEntity(gson.toJson(data).getBytes(StandardCharsets.UTF_8));
    }

    public AdministrationManagedKsSetting getKsAppSetting() throws URISyntaxException, NetworkErrorException, JsonMappingException, JsonProcessingException, MalformedContentException {
        try {
            HttpOptions httpOptions = this.buildHttpOptions(false);
            URI uri = this.buildUri("/v2/admin/ks/settings");
            HttpResponse response = this.executeGetRequest(uri, httpOptions);
            return this.fromAdminSetting(response);
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)"Failed to retrieve KS Setting");
            return AdministrationManagedKsSetting.defaultSettings().build();
        }
    }

    private AdministrationManagedKsSetting fromAdminSetting(HttpResponse response) {
        try {
            AdministrationManagedAppSettingResponseDto settingDto = (AdministrationManagedAppSettingResponseDto)response.json(AdministrationManagedAppSettingResponseDto.class);
            AdministrationManagedKsSetting setting = Optional.ofNullable(settingDto).map(AdministrationManagedKsSettingMapper::fromAppSettingsDto).orElseGet(() -> AdministrationManagedKsSetting.defaultSettings().build());
            return setting;
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)"Failed to parse KS Setting response, falling back to default settings");
            return AdministrationManagedKsSetting.defaultSettings().build();
        }
    }

    public AiConfigPolicy getAiAppConfig(AdministrationManagedKsSetting setting) throws JsonMappingException, JsonProcessingException, URISyntaxException, NetworkErrorException, MalformedContentException {
        AiConfigPolicy DEFAULT_POLICY = new AiConfigPolicy(AiConfigPolicyType.AI_DISABLED);
        try {
            boolean aiEnabled = Optional.ofNullable(setting.isEnableAi()).orElse(false);
            boolean directUsageAllowed = Optional.ofNullable(setting.isAllowDirectUsage()).orElse(false);
            if (!aiEnabled && !directUsageAllowed) {
                return DEFAULT_POLICY;
            }
            if (aiEnabled && !directUsageAllowed) {
                return new AiConfigPolicy(AiConfigPolicyType.USER_MANAGED_SETTINGS);
            }
            return this.fetchAiConfig();
        }
        catch (Exception e) {
            LogUtil.logError((String)"Failed to retrieve AI Config, error:");
            LogUtil.logError((Throwable)e);
            LogUtil.logError((String)"Fallback to AI DISABLED");
            return DEFAULT_POLICY;
        }
    }

    private URI buildUri(String path) throws URISyntaxException {
        String baseUrl = this.discoveryService.getServerUrl(ServerType.PLATFORM);
        URI baseUri = new URI(baseUrl);
        URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath(path);
        return uriBuilder.build();
    }

    private HttpOptions buildHttpOptions(boolean useLicenceKey) throws JsonMappingException, JsonProcessingException {
        Session session = this.sessionManager.getSession();
        Long accountId = Optional.ofNullable(session.getAccount()).map(Account::getId).orElse(null);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(X_ACCOUNT_ID, accountId.toString());
        headers.put(KS_VERSION, VersionUtil.getCurrentVersion().getVersion());
        if (useLicenceKey) {
            headers.put(X_LICENSE_KEY, Optional.ofNullable(session.getLicense()).map(License::getJwt).orElse(null));
        }
        AuthenticationToken katOneToken = session.getKatOneToken();
        BearerAuthentication authenticate = Authentication.BearerAuthentication((String)katOneToken.getAccessToken());
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        return new HttpOptions.Builder().headers(headers).authentication((Authentication)authenticate).proxy(proxyConfig).build();
    }

    private AiConfigPolicy fetchAiConfig() throws URISyntaxException, NetworkErrorException, MalformedContentException, JsonMappingException, JsonProcessingException {
        HttpOptions httpOptions = this.buildHttpOptions(true);
        URI uri = this.buildUri("/v2/admin/ks/ai-configs");
        HttpResponse response = null;
        try {
            response = this.executeGetRequest(uri, httpOptions);
        }
        catch (Exception e) {
            LogUtil.logError((String)("Failed to retrieve AI Config, error: " + e.getMessage()));
            LogUtil.logError((Throwable)e);
            LogUtil.logError((String)"Fallback to USER SETTINGS");
            return new AiConfigPolicy(AiConfigPolicyType.USER_MANAGED_SETTINGS);
        }
        return this.fromAdminConfig(response);
    }

    private HttpResponse executeGetRequest(URI uri, HttpOptions httpOptions) throws NetworkErrorException {
        try {
            HttpResponse response = this.httpClient.get(uri, httpOptions);
            this.handleResponseErrors(response);
            return response;
        }
        catch (HttpException e) {
            throw new NetworkErrorException((Throwable)e);
        }
    }

    private void handleResponseErrors(HttpResponse response) throws NetworkErrorException {
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
    }

    private AiConfigPolicy fromAdminConfig(HttpResponse response) throws MalformedContentException, JsonMappingException, JsonProcessingException {
        AiConfigPolicy DEFAULT_POLICY = new AiConfigPolicy(AiConfigPolicyType.USER_MANAGED_SETTINGS);
        try {
            List aiConfigDto = response.jsonArray(AdministrationManagedAiConfigResponseDto.class);
            if (aiConfigDto.isEmpty()) {
                return DEFAULT_POLICY;
            }
            AdministrationManagedAiProviderConfigDto config = ((AdministrationManagedAiConfigResponseDto)aiConfigDto.get(0)).getConfig();
            AdministrationManagedAiProviderDto provider = ((AdministrationManagedAiConfigResponseDto)aiConfigDto.get(0)).getProvider();
            AiConfigPolicy aiConfigPolicy = null;
            switch (provider) {
                case OPENAI: {
                    AdministrationManagedOpenAiConfigResponseDto openAiDto = (AdministrationManagedOpenAiConfigResponseDto)config;
                    aiConfigPolicy = new AiConfigPolicy(AiConfigPolicyType.ADMINISTRATION_MANAGED_OPENAI);
                    aiConfigPolicy.setManagedOpenAi(openAiDto.getApiKey(), openAiDto.getOrganization());
                    break;
                }
                case AZURE: {
                    AdministrationManagedAzureOpenAiConfigResponseDto azureOpenAiDto = (AdministrationManagedAzureOpenAiConfigResponseDto)config;
                    aiConfigPolicy = new AiConfigPolicy(AiConfigPolicyType.ADMINISTRATION_MANAGED_AZURE_OPENAI);
                    aiConfigPolicy.setManagedAzureOpenAi(azureOpenAiDto.getApiKey(), azureOpenAiDto.getApiBase(), azureOpenAiDto.getDeploymentName(), azureOpenAiDto.getApiVersion());
                    break;
                }
                case GEMINI: {
                    AdministrationManagedGeminiConfigResponseDto geminiDto = (AdministrationManagedGeminiConfigResponseDto)config;
                    aiConfigPolicy = new AiConfigPolicy(AiConfigPolicyType.ADMINISTRATION_MANAGED_GEMINI);
                    aiConfigPolicy.setManagedGeminiAiConfig(geminiDto.getBaseUrl(), geminiDto.getApiKey());
                    break;
                }
                case OPENAI_COMPATIBLE: {
                    AdministrationManagedOpenAiCompatibleConfigResponseDto openAiCompatibleConfigResponseDto = (AdministrationManagedOpenAiCompatibleConfigResponseDto)config;
                    aiConfigPolicy = new AiConfigPolicy(AiConfigPolicyType.ADMINISTRATION_MANAGED_OPENAI_COMPATIBLE);
                    aiConfigPolicy.setManagedOpenAiCompatibleConfig(openAiCompatibleConfigResponseDto.getBaseUrl(), openAiCompatibleConfigResponseDto.getApiKey(), openAiCompatibleConfigResponseDto.getApiKeyHeaderName());
                    break;
                }
                default: {
                    aiConfigPolicy = DEFAULT_POLICY;
                }
            }
            return aiConfigPolicy;
        }
        catch (Exception e) {
            LogUtil.logError((String)("Failed to set AI Config Policy, error: " + e.getMessage()));
            LogUtil.logError((Throwable)e);
            LogUtil.logError((String)"Fallback to USER SETTINGS");
            return DEFAULT_POLICY;
        }
    }
}

