/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.network.apache.services;

import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.protocol.HttpContext;

public class CustomProxyRoutePlanner
extends DefaultProxyRoutePlanner {
    private final List<Pattern> bypassPatterns;

    public CustomProxyRoutePlanner(HttpHost proxy, List<String> bypassHosts) {
        super(proxy);
        this.bypassPatterns = bypassHosts.stream().map(this::wildcardToPattern).collect(Collectors.toList());
    }

    private Pattern wildcardToPattern(String wildcard) {
        String regex = wildcard.replace(".", "\\.").replace("*", ".*");
        return Pattern.compile(regex);
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        String host = target.getHostName();
        for (Pattern pattern : this.bypassPatterns) {
            if (!pattern.matcher(host).matches()) continue;
            return null;
        }
        return super.determineProxy(target, request, context);
    }
}

