/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.network.apache.services;

import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.network.core.model.RetryOptions;
import com.kms.katalon.network.core.services.IRetryService;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import dev.failsafe.function.CheckedRunnable;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.Objects;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@Creatable
@Singleton
public class RetryService
implements IRetryService {
    private final boolean DEFAULT_ENABLE_RETRY = true;
    private final Duration DEFAULT_RETRY_MAX_DURATION_IN_MILLIS = Duration.ofMillis(180000L);
    private final Duration DEFAULT_RETRY_INTERVAL_IN_MILLIS = Duration.ofMillis(120000L);
    private final Duration DEFAULT_RETRY_MAX_JITTER_IN_MILLIS = Duration.ofMillis(60000L);
    private static IRetryService instance;

    public static IRetryService getInstance() {
        if (Objects.isNull(instance)) {
            BundleContext bundleContext = FrameworkUtil.getBundle(RetryService.class).getBundleContext();
            IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
            instance = (IRetryService)ContextInjectionFactory.make(RetryService.class, (IEclipseContext)context);
        }
        return instance;
    }

    private void executeRunnable(CheckedRunnable runnable) throws Throwable {
        try {
            runnable.run();
        }
        catch (Throwable e) {
            LogUtil.logError((Throwable)e, (String)"Invoking the method has error");
            throw e;
        }
    }

    public <T> void invoke(Class<? extends Throwable> aClass, CheckedRunnable runnable, RetryOptions<?> options) throws Throwable {
        Duration retryMaxJitter;
        Duration retryInterval;
        Duration retryMaxDuration;
        boolean enableRetry;
        if (options != null) {
            enableRetry = options.isEnableRetry();
            retryMaxDuration = options.getRetryMaxDuration();
            retryInterval = options.getRetryInterval();
            retryMaxJitter = options.getRetryMaxJitter();
        } else {
            enableRetry = true;
            retryMaxDuration = this.DEFAULT_RETRY_MAX_DURATION_IN_MILLIS;
            retryInterval = this.DEFAULT_RETRY_INTERVAL_IN_MILLIS;
            retryMaxJitter = this.DEFAULT_RETRY_MAX_JITTER_IN_MILLIS;
        }
        if (!enableRetry) {
            this.executeRunnable(runnable);
        } else {
            RetryPolicy retryPolicy = ((RetryPolicyBuilder)RetryPolicy.builder().handle(aClass)).withMaxRetries(-1).withMaxDuration(retryMaxDuration).withDelay(retryInterval).withJitter(retryMaxJitter).onFailedAttempt(options.getOnFailedAttemptListener()).onRetriesExceeded(options.getOnRetriesExceededListener()).onRetry(options.getOnRetryListener()).build();
            Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]).run(runnable);
        }
    }
}

