/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.compiler;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.jdt.groovy.integration.LanguageSupportFactory;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CompilationParticipant;

public class CompilerCleanerParticipant
extends CompilationParticipant {
    private Set<IProject> building = Collections.synchronizedSet(new HashSet());

    public boolean isActive(IJavaProject javaProject) {
        return GroovyNature.hasGroovyNature((IProject)javaProject.getProject()) && LanguageSupportFactory.isGroovyLanguageSupportInstalled();
    }

    public void buildStarting(BuildContext[] files, boolean isBatch) {
        if (files == null || files.length == 0) {
            return;
        }
        this.building.add(files[0].getFile().getProject());
    }

    public void buildFinished(IJavaProject javaProject) {
        this.building.remove(javaProject.getProject());
    }

    public void cleanStarting(IJavaProject javaProject) {
        if (this.building.isEmpty()) {
            GenericsUtils.clearParameterizedTypeCache();
        }
    }
}

