/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.compiler;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyParser;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class GroovySnippetParser {
    private CategorizedProblem[] problems;

    public CategorizedProblem[] getProblems() {
        return this.problems;
    }

    public ModuleNode parse(CharSequence source) {
        char[] contents = source.toString().toCharArray();
        String fileName = "Snippet" + UUID.randomUUID().toString().replaceAll("-", "") + ".groovy";
        Hashtable options = JavaCore.getOptions();
        options.put("org.eclipse.jdt.core.compiler.groovy.buildGroovyFiles", "enabled");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.8");
        CompilerOptions compilerOptions = new CompilerOptions((Map)options);
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, (IProblemFactory)new DefaultProblemFactory());
        CompilationResult compilationResult = new CompilationResult(fileName.toCharArray(), 0, 0, compilerOptions.maxProblemsPerUnit);
        GroovyCompilationUnitDeclaration gcud = new GroovyParser(compilerOptions, problemReporter, false, true).dietParse(contents, fileName, compilationResult);
        this.problems = compilationResult.getProblems();
        ModuleNode node = gcud.getModuleNode();
        if (node == null) {
            return null;
        }
        for (ClassNode classNode : node.getClasses()) {
            Iterator it = classNode.getMethods().iterator();
            while (it.hasNext()) {
                MethodNode method = (MethodNode)it.next();
                if (!GroovyUtils.isSynthetic((MethodNode)method)) continue;
                it.remove();
            }
        }
        return node;
    }
}

