/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.network.core.model;

import com.kms.katalon.network.core.model.Authentication;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import java.util.HashMap;
import java.util.Map;

public class HttpOptions {
    private Authentication authentication;
    private Map<String, String> headers = new HashMap<String, String>();
    private ProxyConfig proxy;
    private Integer connectTimeout;
    private Integer socketTimeout;

    public static Builder builder() {
        return new Builder();
    }

    private HttpOptions(Builder builder) {
        this.headers = builder.headers;
        this.authentication = builder.authentication;
        this.proxy = builder.proxy;
        this.connectTimeout = builder.connectTimeout;
        this.socketTimeout = builder.socketTimeout;
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public ProxyConfig getProxy() {
        return this.proxy;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setProxy(ProxyConfig proxy) {
        this.proxy = proxy;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(Integer socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public static class Builder {
        private Authentication authentication;
        private Map<String, String> headers = new HashMap<String, String>();
        private ProxyConfig proxy;
        private Integer connectTimeout;
        private Integer socketTimeout;

        public Builder addHeader(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public Builder authentication(Authentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public HttpOptions build() {
            return new HttpOptions(this);
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder proxy(ProxyConfig proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder connectTimeout(Integer timeoutInMs) {
            this.connectTimeout = timeoutInMs;
            return this;
        }

        public Builder socketTimeout(Integer timeoutInMs) {
            this.socketTimeout = timeoutInMs;
            return this;
        }
    }
}

