/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.network.core.model;

import dev.failsafe.event.EventListener;
import dev.failsafe.event.ExecutionAttemptedEvent;
import dev.failsafe.event.ExecutionCompletedEvent;
import java.time.Duration;

public class RetryOptions<T> {
    private boolean enableRetry;
    private Duration retryMaxDuration;
    private Duration retryInterval;
    private Duration retryMaxJitter;
    private EventListener<ExecutionAttemptedEvent<Object>> onFailedAttemptListener;
    private EventListener<ExecutionCompletedEvent<Object>> onRetriesExceededListener;
    private EventListener<ExecutionAttemptedEvent<Object>> onRetryListener;

    private RetryOptions(Builder<T> builder) {
        this.enableRetry = builder.enableRetry;
        this.retryMaxDuration = builder.retryMaxDuration;
        this.retryInterval = builder.retryInterval;
        this.retryMaxJitter = builder.retryMaxJitter;
        this.onFailedAttemptListener = builder.onFailedAttemptListener;
        this.onRetriesExceededListener = builder.onRetriesExceededListener;
        this.onRetryListener = builder.onRetryListener;
    }

    public boolean isEnableRetry() {
        return this.enableRetry;
    }

    public Duration getRetryMaxDuration() {
        return this.retryMaxDuration;
    }

    public Duration getRetryInterval() {
        return this.retryInterval;
    }

    public Duration getRetryMaxJitter() {
        return this.retryMaxJitter;
    }

    public EventListener<ExecutionAttemptedEvent<Object>> getOnFailedAttemptListener() {
        return this.onFailedAttemptListener;
    }

    public EventListener<ExecutionCompletedEvent<Object>> getOnRetriesExceededListener() {
        return this.onRetriesExceededListener;
    }

    public EventListener<ExecutionAttemptedEvent<Object>> getOnRetryListener() {
        return this.onRetryListener;
    }

    public static class Builder<T> {
        private boolean enableRetry;
        private Duration retryMaxDuration;
        private Duration retryInterval;
        private Duration retryMaxJitter;
        private EventListener<ExecutionAttemptedEvent<Object>> onFailedAttemptListener;
        private EventListener<ExecutionCompletedEvent<Object>> onRetriesExceededListener;
        private EventListener<ExecutionAttemptedEvent<Object>> onRetryListener;

        public Builder<T> enableRetry(boolean enableRetry) {
            this.enableRetry = enableRetry;
            return this;
        }

        public Builder<T> retryMaxDuration(Duration retryMaxDuration) {
            this.retryMaxDuration = retryMaxDuration;
            return this;
        }

        public Builder<T> retryInterval(Duration retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        public Builder<T> retryMaxJitter(Duration retryMaxJitter) {
            this.retryMaxJitter = retryMaxJitter;
            return this;
        }

        public Builder<T> onFailedAttemptListener(EventListener<ExecutionAttemptedEvent<Object>> onFailedAttemptListener) {
            this.onFailedAttemptListener = onFailedAttemptListener;
            return this;
        }

        public Builder<T> onRetriesExceededListener(EventListener<ExecutionCompletedEvent<Object>> onRetriesExceededListener) {
            this.onRetriesExceededListener = onRetriesExceededListener;
            return this;
        }

        public Builder<T> onRetryListener(EventListener<ExecutionAttemptedEvent<Object>> onRetryListener) {
            this.onRetryListener = onRetryListener;
            return this;
        }

        public RetryOptions<T> build() {
            return new RetryOptions(this);
        }
    }
}

