/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services;

import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfigType;
import com.kms.katalon.ai.core.model.exception.StudioAssistAvailabilityException;
import com.kms.katalon.ai.core.model.exception.StudioAssistConfigException;
import com.kms.katalon.ai.core.model.llm.CompletionOptions;
import com.kms.katalon.ai.core.services.IStudioAssistService;
import com.kms.katalon.core.reporting.service.IFailureAnalysisService;
import com.kms.katalon.core.reporting.service.dto.FailureAnalysisResponse;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.report.core.models.entities.ExecutedTestEntity;
import jakarta.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class FailureAnalysisService
implements IFailureAnalysisService {
    @Inject
    private IStudioAssistService studioAssistService;
    private static final Logger logger = LoggerFactory.getLogger(FailureAnalysisService.class);

    public FailureAnalysisResponse executeAnalysis(ExecutedTestEntity executedTestEntity) {
        try {
            StudioAssistConfig config = this.studioAssistService.getConfig();
            String message = JsonUtil.toJson((Object)executedTestEntity);
            CompletionOptions completionOptions = this.buildCompletionOptions(config);
            String failureResponse = this.studioAssistService.executeFailureAnalysis(message, completionOptions);
            return this.parseFailureAnalysis(failureResponse);
        }
        catch (Exception e) {
            logger.warn("Failed to analyze failure", (Throwable)e);
            return null;
        }
    }

    public boolean canExecute() {
        try {
            return this.studioAssistService.canExecute();
        }
        catch (StudioAssistAvailabilityException | StudioAssistConfigException e) {
            logger.warn("Cannot execute failure analysis due to studio assist unavailability or misconfiguration", e);
            return false;
        }
    }

    private FailureAnalysisResponse parseFailureAnalysis(String jsonResponse) {
        if (StringUtils.isBlank((CharSequence)jsonResponse)) {
            return null;
        }
        try {
            return (FailureAnalysisResponse)JsonUtil.fromJson((String)jsonResponse, FailureAnalysisResponse.class);
        }
        catch (Exception e) {
            logger.debug("Failed to parse failure analysis JSON, creating basic analysis", (Throwable)e);
            return null;
        }
    }

    private CompletionOptions buildCompletionOptions(StudioAssistConfig config) {
        if (config.getType() == StudioAssistConfigType.GEMINI) {
            return CompletionOptions.builder().responseSchema("{\"type\":\"object\",\"properties\":{\"failedReason\":{\"type\":\"string\"},\"impact\":{\"type\":\"string\"},\"recommendation\":{\"type\":\"string\"},\"confidence\":{\"type\":\"number\",\"minimum\":0,\"maximum\":100,\"description\":\"The model's confidence in the analysis, represented as a whole number (integer) between 0 and 100. For example, 95 means 95% confidence.\"}},\"required\":[\"failedReason\",\"impact\",\"recommendation\",\"confidence\"]}").build();
        }
        return CompletionOptions.builder().responseSchema("{\"type\":\"json_schema\",\"json_schema\":{\"name\":\"response-message-schema\",\"strict\":false,\"schema\":{\"type\":\"object\",\"properties\":{\"failedReason\":{\"type\":\"string\"},\"impact\":{\"type\":\"string\"},\"recommendation\":{\"type\":\"string\"},\"confidence\":{\"type\":\"number\",\"minimum\":0,\"maximum\":100,\"description\":\"The model's confidence in the analysis, represented as a whole number (integer) between 0 and 100. For example, 95 means 95% confidence.\"}},\"required\":[\"failedReason\",\"impact\",\"recommendation\",\"confidence\"]}}}").build();
    }
}

