/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services;

import com.kms.katalon.ai.core.model.prompt.TemplateVariable;
import com.kms.katalon.ai.core.services.IStringTemplateEngine;
import jakarta.inject.Singleton;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class StringTemplateEngine
implements IStringTemplateEngine {
    public String evaluate(String template, List<TemplateVariable> variableList) {
        if (CollectionUtils.isEmpty(variableList)) {
            return template;
        }
        List supportedVariables = variableList.stream().filter(TemplateVariable::isUsable).collect(Collectors.toList());
        if (supportedVariables.size() <= 0) {
            return template;
        }
        LinkedHashMap requiredVariablesInTemplate = new LinkedHashMap();
        StringBuilder result = new StringBuilder();
        Pattern pattern = Pattern.compile("\\$\\{(.*?)}");
        Matcher matcher = pattern.matcher(template);
        while (matcher.find()) {
            String variableName = matcher.group(1);
            Optional<TemplateVariable> variable = supportedVariables.stream().filter(e -> e.getName().equalsIgnoreCase(variableName)).findAny();
            if (!variable.isPresent()) continue;
            String variableValue = null;
            variableValue = !requiredVariablesInTemplate.containsKey(variableName) ? this.loadVariableData(variable) : (String)requiredVariablesInTemplate.get(variableName);
            matcher.appendReplacement(result, Matcher.quoteReplacement(variableValue));
        }
        matcher.appendTail(result);
        return result.isEmpty() ? template : result.toString();
    }

    private String loadVariableData(Optional<TemplateVariable> variable) {
        if (variable.isPresent()) {
            return variable.get().getValue();
        }
        return "";
    }

    public String buidVariableNameWithStringTemplate(String variableName) {
        return String.format("${%s}", variableName);
    }
}

