/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.tagexpressions;

import io.cucumber.tagexpressions.Expression;
import io.cucumber.tagexpressions.TagExpressionException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TagExpressionParser {
    private static Map<String, Assoc> ASSOC = new HashMap<String, Assoc>(){
        {
            this.put("or", Assoc.LEFT);
            this.put("and", Assoc.LEFT);
            this.put("not", Assoc.RIGHT);
        }
    };
    private static Map<String, Integer> PREC = new HashMap<String, Integer>(){
        {
            this.put("(", -2);
            this.put(")", -1);
            this.put("or", 0);
            this.put("and", 1);
            this.put("not", 2);
        }
    };
    private static final char ESCAPING_CHAR = '\\';

    public Expression parse(String infix) {
        List<String> tokens = TagExpressionParser.tokenize(infix);
        if (tokens.isEmpty()) {
            return new True();
        }
        ArrayDeque<String> operators = new ArrayDeque<String>();
        ArrayDeque<Expression> expressions = new ArrayDeque<Expression>();
        TokenType expectedTokenType = TokenType.OPERAND;
        for (String token : tokens) {
            if (this.isUnary(token)) {
                this.check(expectedTokenType, TokenType.OPERAND);
                operators.push(token);
                expectedTokenType = TokenType.OPERAND;
                continue;
            }
            if (this.isBinary(token)) {
                this.check(expectedTokenType, TokenType.OPERATOR);
                while (operators.size() > 0 && this.isOperator((String)operators.peek()) && (ASSOC.get(token) == Assoc.LEFT && PREC.get(token) <= PREC.get(operators.peek()) || ASSOC.get(token) == Assoc.RIGHT && PREC.get(token) < PREC.get(operators.peek()))) {
                    this.pushExpr((String)this.pop(operators), expressions);
                }
                operators.push(token);
                expectedTokenType = TokenType.OPERAND;
                continue;
            }
            if ("(".equals(token)) {
                this.check(expectedTokenType, TokenType.OPERAND);
                operators.push(token);
                expectedTokenType = TokenType.OPERAND;
                continue;
            }
            if (")".equals(token)) {
                this.check(expectedTokenType, TokenType.OPERATOR);
                while (operators.size() > 0 && !"(".equals(operators.peek())) {
                    this.pushExpr((String)this.pop(operators), expressions);
                }
                if (operators.size() == 0) {
                    throw new TagExpressionException("Syntax error. Unmatched )", new Object[0]);
                }
                if ("(".equals(operators.peek())) {
                    this.pop(operators);
                }
                expectedTokenType = TokenType.OPERATOR;
                continue;
            }
            this.check(expectedTokenType, TokenType.OPERAND);
            this.pushExpr(token, expressions);
            expectedTokenType = TokenType.OPERATOR;
        }
        while (operators.size() > 0) {
            if ("(".equals(operators.peek())) {
                throw new TagExpressionException("Syntax error. Unmatched (", new Object[0]);
            }
            this.pushExpr((String)this.pop(operators), expressions);
        }
        return (Expression)expressions.pop();
    }

    private static List<String> tokenize(String expr) {
        ArrayList<String> tokens = new ArrayList<String>();
        boolean isEscaped = false;
        StringBuilder token = null;
        for (int i = 0; i < expr.length(); ++i) {
            char c = expr.charAt(i);
            if ('\\' == c) {
                isEscaped = true;
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (null != token) {
                    tokens.add(token.toString());
                    token = null;
                }
            } else {
                switch (c) {
                    case '(': 
                    case ')': {
                        if (!isEscaped) {
                            if (null != token) {
                                tokens.add(token.toString());
                                token = null;
                            }
                            tokens.add(String.valueOf(c));
                            break;
                        }
                    }
                    default: {
                        if (null == token) {
                            token = new StringBuilder();
                        }
                        token.append(c);
                    }
                }
            }
            isEscaped = false;
        }
        if (null != token) {
            tokens.add(token.toString());
        }
        return tokens;
    }

    private void check(TokenType expectedTokenType, TokenType tokenType) {
        if (expectedTokenType != tokenType) {
            throw new TagExpressionException("Syntax error. Expected %s", expectedTokenType.toString().toLowerCase());
        }
    }

    private <T> T pop(Deque<T> stack) {
        if (stack.isEmpty()) {
            throw new TagExpressionException("empty stack", new Object[0]);
        }
        return stack.pop();
    }

    private void pushExpr(String token, Deque<Expression> stack) {
        switch (token) {
            case "and": {
                Expression rightAndExpr = this.pop(stack);
                stack.push(new And(this.pop(stack), rightAndExpr));
                break;
            }
            case "or": {
                Expression rightOrExpr = this.pop(stack);
                stack.push(new Or(this.pop(stack), rightOrExpr));
                break;
            }
            case "not": {
                stack.push(new Not(this.pop(stack)));
                break;
            }
            default: {
                stack.push(new Literal(token));
            }
        }
    }

    private boolean isUnary(String token) {
        return "not".equals(token);
    }

    private boolean isBinary(String token) {
        return "or".equals(token) || "and".equals(token);
    }

    private boolean isOperator(String token) {
        return ASSOC.get(token) != null;
    }

    private class True
    implements Expression {
        private True() {
        }

        @Override
        public boolean evaluate(List<String> variables) {
            return true;
        }
    }

    private class Not
    implements Expression {
        private final Expression expr;

        Not(Expression expr) {
            this.expr = expr;
        }

        @Override
        public boolean evaluate(List<String> variables) {
            return !this.expr.evaluate(variables);
        }

        public String toString() {
            return "not ( " + this.expr.toString() + " )";
        }
    }

    private class And
    implements Expression {
        private final Expression left;
        private final Expression right;

        And(Expression left, Expression right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean evaluate(List<String> variables) {
            return this.left.evaluate(variables) && this.right.evaluate(variables);
        }

        public String toString() {
            return "( " + this.left.toString() + " and " + this.right.toString() + " )";
        }
    }

    private class Or
    implements Expression {
        private final Expression left;
        private final Expression right;

        Or(Expression left, Expression right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean evaluate(List<String> variables) {
            return this.left.evaluate(variables) || this.right.evaluate(variables);
        }

        public String toString() {
            return "( " + this.left.toString() + " or " + this.right.toString() + " )";
        }
    }

    private class Literal
    implements Expression {
        private final String value;

        Literal(String value) {
            this.value = value;
        }

        @Override
        public boolean evaluate(List<String> variables) {
            return variables.contains(this.value);
        }

        public String toString() {
            return this.value.replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)");
        }
    }

    private static enum Assoc {
        LEFT,
        RIGHT;

    }

    private static enum TokenType {
        OPERAND,
        OPERATOR;

    }
}

