/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.eclipse.codeassist.completions.GroovyExtendedCompletionContext;
import org.codehaus.groovy.eclipse.codeassist.proposals.IGroovyProposal;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.jdt.groovy.ast.MethodNodeWithNamedParams;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.codeassist.InternalCompletionContext;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.ui.text.java.CompletionProposalLabelProvider;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class ProposalUtils {
    public static final char[] ARG_ = new char[]{'%'};
    public static final char[] ARG0 = "arg0".toCharArray();
    public static final char[] ARG1 = "arg1".toCharArray();
    public static final char[] METHOD_TRIGGERS = new char[]{';', ',', '.', '[', ' ', '\t'};
    public static final char[] METHOD_WITH_ARGUMENTS_TRIGGERS = new char[]{'(', '{', '-', ' '};
    public static final char[] TYPE_TRIGGERS = new char[]{';', '.', '=', '[', '(', ' ', '\t'};
    public static final char[] VAR_TRIGGER = new char[]{';', '.', '=', '[', '(', '{', ' ', '\t'};
    public static final ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];
    public static final List<IGroovyProposal> NO_PROPOSALS = Collections.EMPTY_LIST;
    private static ImageDescriptorRegistry registry;
    private static final CompletionProposalLabelProvider labelProvider;
    static boolean substringMatch;

    static {
        try {
            registry = JavaPlugin.getImageDescriptorRegistry();
        }
        catch (Exception e) {
            e.printStackTrace();
            registry = null;
        }
        labelProvider = new CompletionProposalLabelProvider();
        substringMatch = !"false".equals(System.getProperty("jdt.codeCompleteSubstringMatch"));
    }

    private ProposalUtils() {
    }

    public static StyledString createDisplayString(CompletionProposal proposal) {
        return labelProvider.createStyledLabel(proposal);
    }

    public static String createMockFieldName(String methodName) {
        int prefix;
        int n = prefix = methodName.startsWith("is") ? 2 : 3;
        if (methodName.length() > prefix) {
            if (methodName.length() > prefix + 1 && Character.isUpperCase(methodName.charAt(prefix + 1))) {
                return methodName.substring(prefix);
            }
            return Character.toLowerCase(methodName.charAt(prefix)) + methodName.substring(prefix + 1);
        }
        return "$$$$$";
    }

    public static String createCapitalMockFieldName(String methodName) {
        return methodName.length() > 3 ? methodName.substring(3) : "$$$$$";
    }

    public static char[] createMethodSignature(MethodNode node) {
        return ProposalUtils.createMethodSignature(node, 0);
    }

    public static char[] createMethodSignature(MethodNode node, int ignoreParameters) {
        Parameter[] parameters = node instanceof MethodNodeWithNamedParams ? ((MethodNodeWithNamedParams)node).getVisibleParams() : node.getParameters();
        char[][] parameterTypes = new char[parameters.length - ignoreParameters][];
        int i = 0;
        int n = parameterTypes.length;
        while (i < n) {
            parameterTypes[i] = ProposalUtils.createTypeSignature(parameters[i + ignoreParameters].getType());
            ++i;
        }
        char[] returnType = ProposalUtils.createTypeSignature(node.getReturnType());
        StringBuilder signature = new StringBuilder();
        signature.append(node.getName());
        signature.append(Signature.createMethodSignature((char[][])parameterTypes, (char[])returnType));
        char[] chars = new char[signature.length()];
        signature.getChars(0, chars.length, chars, 0);
        return chars;
    }

    public static char[] createTypeSignature(ClassNode node) {
        return GroovyUtils.getTypeSignature((ClassNode)node, (boolean)true, (boolean)true).toCharArray();
    }

    public static char[] createUnresolvedTypeSignature(ClassNode node) {
        return GroovyUtils.getTypeSignature((ClassNode)node, (boolean)true, (boolean)false).toCharArray();
    }

    public static char[] createSimpleTypeName(ClassNode node) {
        if (GroovyUtils.getBaseType((ClassNode)node).isGenericsPlaceHolder()) {
            node = node.redirect();
        }
        return Signature.getSimpleName((char[])Signature.toCharArray((char[])GroovyUtils.getTypeSignatureWithoutGenerics((ClassNode)node, (boolean)false, (boolean)true).toCharArray()));
    }

    public static Optional<ContentAssistContext> getContentAssistContext(JavaContentAssistInvocationContext javaContext) {
        if (javaContext.getCoreContext().isExtended()) {
            GroovyExtendedCompletionContext groovyContext = (GroovyExtendedCompletionContext)((Object)ReflectionUtils.getPrivateField(InternalCompletionContext.class, (String)"extendedContext", (Object)javaContext.getCoreContext()));
            ContentAssistContext context = (ContentAssistContext)ReflectionUtils.getPrivateField(GroovyExtendedCompletionContext.class, (String)"context", (Object)((Object)groovyContext));
            return Optional.ofNullable(context);
        }
        return Optional.empty();
    }

    public static Image getImage(CompletionProposal proposal) {
        return registry.get(labelProvider.createImageDescriptor(proposal));
    }

    public static Image getParameterImage() {
        return registry.get(JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE);
    }

    public static char[][] getParameterNames(Parameter[] parameters) {
        int n = parameters.length;
        if (n > 0) {
            char[][] names = new char[n][];
            int i = 0;
            while (i < n) {
                names[i] = parameters[i].getName().toCharArray();
                ++i;
            }
            return names;
        }
        return CharOperation.NO_CHAR_CHAR;
    }

    public static char[][] getParameterTypeNames(Parameter[] parameters) {
        int n = parameters.length;
        if (n > 0) {
            char[][] names = new char[n][];
            int i = 0;
            while (i < n) {
                names[i] = Signature.toCharArray((char[])Signature.getTypeErasure((char[])ProposalUtils.createTypeSignature(parameters[i].getType())));
                ++i;
            }
            return names;
        }
        return CharOperation.NO_CHAR_CHAR;
    }

    public static AccessRestriction getTypeAccessibility(IType type) {
        PackageFragmentRoot root = (PackageFragmentRoot)type.getAncestor(3);
        try {
            AccessRuleSet accessRuleSet;
            IClasspathEntry entry = root.getResolvedClasspathEntry();
            if (entry instanceof ClasspathEntry && (accessRuleSet = ((ClasspathEntry)entry).getAccessRuleSet()) != null) {
                char[] packageName = type.getPackageFragment().getElementName().toCharArray();
                char[][] packageChars = CharOperation.splitOn((char)'.', (char[])packageName);
                char[] fileWithoutExtension = type.getElementName().toCharArray();
                return accessRuleSet.getViolatedRestriction(CharOperation.concatWith((char[][])packageChars, (char[])fileWithoutExtension, (char)'/'));
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    public static boolean hasWhitespace(char[] chars) {
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (CharOperation.isWhitespace((char)c)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isContentAssistAutoActiavted() {
        return JavaPlugin.getDefault().getPreferenceStore().getBoolean("content_assist_autoactivation");
    }

    public static boolean looselyMatches(String prefix, String target) {
        return ProposalUtils.matches(prefix, target, true, false);
    }

    public static boolean matches(String pattern, String candidate, boolean cmlCaseMatch, boolean subWordMatch) {
        if (pattern.isEmpty()) {
            return true;
        }
        if (cmlCaseMatch && SearchPattern.camelCaseMatch((String)pattern, (String)candidate)) {
            return true;
        }
        if (subWordMatch && CharOperation.getSubWordMatchingRegions((String)pattern, (String)candidate) != null) {
            return true;
        }
        return substringMatch ? CharOperation.substringMatch((String)pattern, (String)candidate) : candidate.startsWith(pattern);
    }
}

