/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.preferences;

import java.util.Arrays;
import org.codehaus.groovy.eclipse.codeassist.GroovyContentAssist;
import org.codehaus.groovy.eclipse.preferences.FieldEditorOverlayPage;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class ContentAssistPreferencesPage
extends FieldEditorOverlayPage
implements IWorkbenchPreferencePage {
    public ContentAssistPreferencesPage() {
        super(1);
        this.setPreferenceStore(GroovyContentAssist.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected String getPageId() {
        return "org.codehaus.groovy.eclipse.editor.codeassist";
    }

    protected void createFieldEditors() {
        Composite fieldGroup = this.createFieldGroup("Insertion");
        this.addField((FieldEditor)new BooleanFieldEditor("org.codehaus.groovy.eclipse.codeassist.arguments.named", "Use named arguments for method calls", fieldGroup));
        this.addField((FieldEditor)new BooleanFieldEditor("org.codehaus.groovy.eclipse.codeassist.closures.literals", "Use closure literals for closure arguments", fieldGroup));
        this.addField((FieldEditor)new BooleanFieldEditor("org.codehaus.groovy.eclipse.codeassist.closures.noparens", "Place trailing closure arguments after closing parenthesis", fieldGroup));
        fieldGroup = this.createFieldGroup("Filtering");
        ((GridData)fieldGroup.getParent().getLayoutData()).verticalIndent = 7;
        this.addField((FieldEditor)new CompletionFilterListEditor("Filtered DGMs", "Default Groovy Methods that will be filtered from content assist", fieldGroup));
        this.insertPageLink("org.eclipse.jdt.ui.preferences.CodeAssistPreferencePage", "Additional preferences are inherited from <a>Java > Editor > Content Assist</a>");
    }

    private Composite createFieldGroup(String label) {
        Group group = new Group(this.getFieldEditorParent(), 32);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo((Control)group);
        group.setFont(group.getParent().getFont());
        group.setLayout((Layout)new GridLayout());
        group.setText(label);
        Composite panel = new Composite((Composite)group, 0);
        panel.setLayoutData((Object)new GridData(1808));
        return panel;
    }

    private void insertPageLink(String page, String text) {
        PreferenceLinkArea linkArea = new PreferenceLinkArea(this.getFieldEditorParent(), 64, page, text, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        GridDataFactory.fillDefaults().indent(0, 8).applyTo(linkArea.getControl());
    }

    private static class CompletionFilterListEditor
    extends ListEditor {
        private Button addMultipleButton;
        private final Shell shell;

        CompletionFilterListEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.shell = parent.getShell();
            this.setPreferenceName("org.codehaus.groovy.eclipse.codeassist.filtereddgms");
        }

        protected String createList(String[] items) {
            StringBuilder sb = new StringBuilder();
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                sb.append(item + ",");
                ++n2;
            }
            return sb.toString();
        }

        protected String getNewInputObject() {
            InputDialog dialog = new InputDialog(this.shell, "Add new DGM to filter", "Select the name of a Default Groovy Method to filter from content assist", "", (IInputValidator)new DGMValidator());
            int res = dialog.open();
            if (res == 0) {
                return dialog.getValue();
            }
            return null;
        }

        public Composite getButtonBoxControl(Composite parent) {
            Composite buttonBox = super.getButtonBoxControl(parent);
            if (this.addMultipleButton == null) {
                this.addMultipleButton = this.createAddMultipleButton(buttonBox, "Add multiple...");
            }
            this.getUpButton().setVisible(false);
            this.getDownButton().setVisible(false);
            return buttonBox;
        }

        private Button createAddMultipleButton(Composite parent, String name) {
            Button button = new Button(parent, 8);
            button.setText(name);
            button.setFont(parent.getFont());
            GridData data = new GridData(768);
            int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
            data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
            button.setLayoutData((Object)data);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    this.addMultiple();
                }
            });
            return button;
        }

        protected void addMultiple() {
            Object[] items = this.getList().getItems();
            StringBuilder sb = new StringBuilder();
            Object[] objectArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = objectArray[n2];
                sb.append(item + "\n");
                ++n2;
            }
            InputDialog input = new InputDialog(this.getShell(), "Add multiple", "Add/remove multiple entries.  Enter one Default Groovy Method name per line.", sb.toString(), new MultiDGMValidator()){

                protected int getInputTextStyle() {
                    return 2050;
                }

                protected Control createDialogArea(Composite parent) {
                    Control child = super.createDialogArea(parent);
                    this.getText().setLayoutData((Object)new GridData(1808));
                    return child;
                }
            };
            int res = input.open();
            if (res == 0) {
                String text = input.getValue();
                items = text.split("\\n");
                Arrays.sort(items);
                this.getList().setItems((String[])items);
                this.getList().deselectAll();
                this.selectionChanged();
            }
        }

        protected String[] parseString(String stringList) {
            Object[] split = stringList.split(",");
            Arrays.sort(split);
            return split;
        }
    }

    private static class DGMValidator
    implements IInputValidator {
        private DGMValidator() {
        }

        public String isValid(String newText) {
            if (newText.trim().length() == 0) {
                return "";
            }
            String[] complianceLevels = JavaConventionsUtil.getSourceComplianceLevels(null);
            IStatus s = JavaConventions.validateMethodName((String)newText, (String)complianceLevels[0], (String)complianceLevels[1]);
            if (s.getSeverity() > 0) {
                return s.getMessage();
            }
            return null;
        }
    }

    private static class MultiDGMValidator
    extends DGMValidator {
        private MultiDGMValidator() {
        }

        @Override
        public String isValid(String newText) {
            String[] splits = newText.split("\\n");
            StringBuilder sb = new StringBuilder();
            String[] stringArray = splits;
            int n = splits.length;
            int n2 = 0;
            while (n2 < n) {
                String split = stringArray[n2];
                String res = super.isValid(split);
                if (res != null) {
                    sb.append(res);
                }
                ++n2;
            }
            return sb.length() > 0 ? sb.toString() : null;
        }
    }
}

