/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.processors;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.eclipse.codeassist.CharArraySourceBuffer;
import org.codehaus.groovy.eclipse.codeassist.GroovyContentAssist;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.processors.AbstractGroovyCompletionProcessor;
import org.codehaus.groovy.eclipse.codeassist.processors.GroovyProposalTypeSearchRequestor;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistLocation;
import org.codehaus.groovy.eclipse.core.ISourceBuffer;
import org.codehaus.groovy.eclipse.core.util.ExpressionFinder;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.groovy.search.ITypeResolver;
import org.eclipse.jdt.internal.codeassist.ISearchRequestor;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class TypeCompletionProcessor
extends AbstractGroovyCompletionProcessor
implements ITypeResolver {
    protected ModuleNode module;
    protected JDTResolver resolver;
    protected static final Set<String> FIELD_MODIFIERS = Set.of("private", "protected", "public", "static", "final");

    public TypeCompletionProcessor(ContentAssistContext context, JavaContentAssistInvocationContext javaContext, SearchableEnvironment nameEnvironment) {
        super(context, javaContext, nameEnvironment);
    }

    public void setResolverInformation(ModuleNode module, JDTResolver resolver) {
        this.module = module;
        this.resolver = resolver;
    }

    @Override
    public List<ICompletionProposal> generateProposals(IProgressMonitor monitor) {
        String expression;
        ContentAssistContext context = this.getContext();
        if (!this.doTypeCompletion(context, expression = context.getQualifiedCompletionExpression())) {
            return Collections.emptyList();
        }
        int replacementStart = this.getReplacementStartOffset();
        SearchableEnvironment environment = this.getNameEnvironment();
        GroovyProposalTypeSearchRequestor requestor = new GroovyProposalTypeSearchRequestor(context, this.getJavaContext(), replacementStart, -1, environment.nameLookup, monitor);
        int lastDotIndex = expression.lastIndexOf(46);
        if (lastDotIndex < 0 || environment.nameLookup.isPackage(expression.substring(0, lastDotIndex).split("\\."))) {
            boolean findMembers = true;
            int matchRule = 1;
            if (requestor.options.camelCaseMatch) {
                matchRule |= 0x80;
            }
            if (requestor.options.subwordMatch) {
                matchRule |= 0x400;
            }
            environment.findTypes(expression.toCharArray(), findMembers, matchRule, this.getSearchFor(), (ISearchRequestor)requestor, monitor);
        } else if (Character.isJavaIdentifierStart(expression.charAt(0)) && expression.chars().allMatch(c -> c == 46 || Character.isJavaIdentifierPart(c))) {
            String qualifier = expression.substring(0, lastDotIndex);
            String pattern = expression.substring(lastDotIndex + 1, expression.length());
            Consumer<IType> checker = outerType -> {
                if (outerType != null && outerType.exists() && qualifier.endsWith(outerType.getElementName())) {
                    try {
                        IType[] iTypeArray = outerType.getTypes();
                        int n = iTypeArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IType innerType = iTypeArray[n2];
                            if (this.isAcceptable(innerType, this.getSearchFor()) && ProposalUtils.matches(pattern, innerType.getElementName(), groovyProposalTypeSearchRequestor.options.camelCaseMatch, groovyProposalTypeSearchRequestor.options.subwordMatch)) {
                                requestor.acceptType(innerType.getPackageFragment().getElementName().toCharArray(), innerType.getElementName().toCharArray(), CharOperation.splitOn((char)'$', (char[])outerType.getTypeQualifiedName().toCharArray()), innerType.getFlags(), ProposalUtils.getTypeAccessibility(innerType));
                            }
                            ++n2;
                        }
                    }
                    catch (JavaModelException e) {
                        GroovyContentAssist.logError(e);
                    }
                }
            };
            ClassNode outerTypeNode = this.resolver.resolve(qualifier);
            if (!ClassHelper.DYNAMIC_TYPE.equals((Object)outerTypeNode)) {
                checker.accept(environment.nameLookup.findType(outerTypeNode.getName(), false, 0));
            } else if (qualifier.indexOf(46) < 0) {
                environment.findTypes(qualifier.toCharArray(), true, 1, this.getSearchFor(), (ISearchRequestor)requestor, monitor);
                List<ICompletionProposal> proposals = requestor.processAcceptedTypes(this.resolver);
                for (ICompletionProposal proposal : proposals) {
                    if (!(proposal instanceof AbstractJavaCompletionProposal)) continue;
                    checker.accept((IType)((AbstractJavaCompletionProposal)proposal).getJavaElement());
                }
            }
        }
        return requestor.processAcceptedTypes(this.resolver);
    }

    protected boolean doTypeCompletion(ContentAssistContext context, String expression) {
        AnnotatedNode completionNode;
        if (expression.isEmpty()) {
            return context.location == ContentAssistLocation.ANNOTATION || context.location == ContentAssistLocation.IMPORT;
        }
        if (context.location == ContentAssistLocation.GENERICS && context.completionNode instanceof GenericsType) {
            return false;
        }
        if (context.location == ContentAssistLocation.PARAMETER && context.completionNode != null && (completionNode = (AnnotatedNode)context.completionNode).getStart() < completionNode.getNameStart() && context.completionLocation >= completionNode.getNameStart()) {
            return false;
        }
        return !TypeCompletionProcessor.isBeforeTypeName(context);
    }

    protected int getSearchFor() {
        switch (this.getContext().location) {
            case EXTENDS: {
                return 5;
            }
            case IMPLEMENTS: {
                return 6;
            }
            case EXCEPTIONS: {
                return 5;
            }
            case ANNOTATION: {
                return 8;
            }
        }
        return 0;
    }

    protected boolean isAcceptable(IType type, int searchFor) throws JavaModelException {
        if (searchFor == 0) {
            return true;
        }
        int kind = TypeDeclaration.kind((int)type.getFlags());
        switch (kind) {
            case 1: 
            case 3: 
            case 4: {
                return searchFor == 5;
            }
            case 2: {
                return searchFor == 6;
            }
        }
        return false;
    }

    protected static boolean isBeforeTypeName(ContentAssistContext context) {
        if (context.location != ContentAssistLocation.CLASS_BODY) {
            return false;
        }
        ExpressionFinder.NameAndLocation nameAndLocation = new ExpressionFinder().findPreviousTypeNameToken((ISourceBuffer)new CharArraySourceBuffer(context.unit.getContents()), context.completionLocation);
        if (nameAndLocation == null) {
            return false;
        }
        if (!(context.completionNode instanceof FieldNode)) {
            return false;
        }
        return !FIELD_MODIFIERS.contains(nameAndLocation.name.trim());
    }
}

