/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.proposals;

import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.eclipse.codeassist.GroovyContentAssist;
import org.eclipse.jface.preference.IPreferenceStore;

public class ProposalFormattingOptions {
    public final boolean noParensAroundClosures;
    public final boolean useBracketsForClosures;
    public final boolean useNamedArguments;
    public final boolean noParens;

    public static ProposalFormattingOptions newFromOptions() {
        IPreferenceStore prefs = GroovyContentAssist.getDefault().getPreferenceStore();
        boolean noParensAroundClosures = prefs.getBoolean("org.codehaus.groovy.eclipse.codeassist.closures.noparens");
        boolean useBracketsForClosures = prefs.getBoolean("org.codehaus.groovy.eclipse.codeassist.closures.literals");
        boolean useNamedArguments = prefs.getBoolean("org.codehaus.groovy.eclipse.codeassist.arguments.named");
        boolean noParensInChains = false;
        return new ProposalFormattingOptions(noParensAroundClosures, useBracketsForClosures, useNamedArguments, false);
    }

    private ProposalFormattingOptions(boolean noParensAroundArgs, boolean useBracketsForClosures, boolean useNamedArguments, boolean noParens) {
        this.noParensAroundClosures = noParensAroundArgs;
        this.useBracketsForClosures = useBracketsForClosures;
        this.useNamedArguments = useNamedArguments;
        this.noParens = noParens;
    }

    public ProposalFormattingOptions newFromExisting(boolean overrideUseNamedArgs, boolean overrideNoParens, MethodNode method) {
        if (overrideUseNamedArgs || overrideNoParens) {
            return new ProposalFormattingOptions(this.noParensAroundClosures, this.useBracketsForClosures, overrideUseNamedArgs, overrideNoParens);
        }
        if (this.useNamedArguments && !(method instanceof ConstructorNode)) {
            return new ProposalFormattingOptions(this.noParensAroundClosures, this.useBracketsForClosures, false, overrideNoParens);
        }
        return this;
    }
}

