/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.relevance.internal;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.codehaus.groovy.eclipse.codeassist.relevance.IRelevanceRule;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IType;

public class CompositeRule
implements IRelevanceRule {
    private final Map<IRelevanceRule, Double> rules;

    public CompositeRule(Map<IRelevanceRule, Double> rules) {
        Assert.isLegal((rules != null && !rules.isEmpty() ? 1 : 0) != 0);
        this.rules = rules;
    }

    @Override
    public int getRelevance(IType type, IType[] contextTypes) {
        double relevance = 0.0;
        for (Map.Entry<IRelevanceRule, Double> entry : this.rules.entrySet()) {
            relevance += entry.getValue() * (double)entry.getKey().getRelevance(type, contextTypes);
        }
        return Math.max(1, (int)Math.ceil(relevance));
    }

    @Override
    public int getRelevance(char[] fullyQualifiedName, IType[] contextTypes, int accessibility, int modifiers) {
        double relevance = 0.0;
        for (Map.Entry<IRelevanceRule, Double> entry : this.rules.entrySet()) {
            relevance += entry.getValue() * (double)entry.getKey().getRelevance(fullyQualifiedName, contextTypes, accessibility, modifiers);
        }
        return Math.max(1, (int)Math.ceil(relevance));
    }

    public static IRelevanceRule of(double weight, IRelevanceRule rule) {
        return new CompositeRule(Collections.singletonMap(rule, weight));
    }

    public static IRelevanceRule of(double weight1, IRelevanceRule rule1, double weight2, IRelevanceRule rule2) {
        IdentityHashMap<IRelevanceRule, Double> rules = new IdentityHashMap<IRelevanceRule, Double>();
        rules.put(rule1, weight1);
        rules.put(rule2, weight2);
        return new CompositeRule(Collections.unmodifiableMap(rules));
    }

    public static IRelevanceRule of(double weight1, IRelevanceRule rule1, double weight2, IRelevanceRule rule2, double weight3, IRelevanceRule rule3) {
        IdentityHashMap<IRelevanceRule, Double> rules = new IdentityHashMap<IRelevanceRule, Double>();
        rules.put(rule1, weight1);
        rules.put(rule2, weight2);
        rules.put(rule3, weight3);
        return new CompositeRule(Collections.unmodifiableMap(rules));
    }
}

