/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.azure.setting;

import com.kms.katalon.core.setting.ReportFormatType;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class ReportFormatHelper {
    private List<ReportFormatType> reportFormatTypes;

    public ReportFormatHelper(List<ReportFormatType> reportFormatTypes) {
        this.reportFormatTypes = reportFormatTypes;
    }

    public boolean match(File file) {
        String extensionFile;
        if (!file.exists()) {
            return false;
        }
        if (this.reportFormatTypes.contains(ReportFormatType.HTML) && file.isDirectory() && StringUtils.equals((CharSequence)file.getName(), (CharSequence)"data")) {
            return true;
        }
        if (!file.isFile()) {
            return false;
        }
        switch (extensionFile = FilenameUtils.getExtension((String)file.getName())) {
            case "html": {
                return this.reportFormatTypes.contains(ReportFormatType.HTML);
            }
            case "csv": {
                return this.reportFormatTypes.contains(ReportFormatType.CSV);
            }
            case "pdf": {
                return this.reportFormatTypes.contains(ReportFormatType.PDF);
            }
            case "png": {
                return this.reportFormatTypes.contains(ReportFormatType.PNG);
            }
            case "log": {
                return this.reportFormatTypes.contains(ReportFormatType.LOG);
            }
        }
        return false;
    }
}

